require 'spongiae/tags'
require 'spongiae/unit'

module Spongiae::Util
    module XmlCallbacks
        
        module InputCallback
            def role_for_tag(name,attrs) nil end # to be overridden
            def check_para_start(name,attrs)
                if is_para_start?(name) then
                    @inPara = true ; @tagStack = []; @tags = []
                elsif @inPara then
                    tag = Spongiae::Tags::MarkupTag.new; tag.type = 1; tag.name = name; tag.attrs = attrs; tag.id = @tags.count
                    tag.role = role_for_tag(name,attrs) 
                    @tagStack << tag
                    @tags << Spongiae::Tags::Placeable.new(@text.length, tag)
                end
            end
            
            def compress_spaces!(re,st)
                @text.gsub! re do |spaces|
                    match = Regexp.last_match
                    @tags.each { |tag0| tag0.pos -= spaces.length - st.length if tag0.pos >= match.end(0) }
                    st
                end
                @tags.select { |tag0| tag0.pos < 0 }.each { |tag1| tag1.pos = 0 } 
                @tags.select { |tag0| tag0.pos > @text.length }.each { |tag1| tag1.pos = @text.length }
            end
            
            def check_para_end(name,compress_spaces = false)
               if is_para_start?(name) then 
                   if compress_spaces then
                        compress_spaces! /([\s\r\n\t][\s\r\n\t]+)/, ' '
                        compress_spaces! /^[\s\r\n\t]+/, ''
                        compress_spaces! /[\s\r\n\t]+$/, ''
                   end
                   @sub.call Spongiae::Unit::Unilingual.new(@file, @path, nil, Spongiae::Tags::TaggedString.new(@text,@tags)) if @text != nil and @text != ''
                   @text = ''; @tags = []; @tagStack = []
                   @inPara = false
               end
            end
            
            def pop_para_end_tag(name)
               if @inPara then
                   if (@text.length == @tags[-1].pos) and (@tags[-1].item.type == +1) and (@tags[-1].item.name == name) then
                       @tags[-1].item.type = 0
                       @tagStack.pop
                   else
                       tag = Spongiae::Tags::MarkupTag.new; tag.type = -1; tag.name = name
                       tag.id = @tagStack.pop.id
                       @tags << Spongiae::Tags::Placeable.new(@text.length, tag)
                   end
               end
            end            
            
           def text(text) 
               @text = @text + text if @inPara
           end
           def characters(text) 
               @text = @text + text if @inPara
           end
        end
        
        module OutputCallback
           def print_para_start(name, attrs = [])
               if is_para_start?(name,attrs) or not @inPara then
                   @dest.print "<#{name}"
                   if attrs.is_a? Hash then
                       attrs.each { |k,v| @dest.print " #{k} = \"#{v.encode(:xml => :text)}\"" }                       
                   elsif attrs.is_a? Array then
                       attrs.each { |item| @dest.print " #{item[0]} = \"#{item[1].encode(:xml => :text)}\"" }
                   end
                   @dest.print ">"
               end
           end
           
           def print_para_end(name)
               if is_para_start?(name) or not @inPara then
                   @dest.print "</#{name}>"
               end               
           end
           
           # Build a translation procedure for most cases
           def self.translation_proc(translations_map,dest)
               Proc.new { |unit|
                      tra = unit.text
                      tra = translations_map[unit.id].restore_tags(unit) if translations_map[unit.id] != nil
                      dest.puts tra.to_native_xml
                    }
           end
        end
           
   end
end
