#! /usr/bin/env ruby 

formatOptions = {}
ARGV.each { |item| formatOptions[$1] = $2 if item =~ /^--fmt:([\w\-]+)=(.+)$/ }
ARGV.reject! { |item| item =~ /^--fmt:([\w\-]+)=(.+)$/ }

if ARGV.count < 1
    puts "Syntax: #{__FILE__} [--fmt:option=value]{0,*} <native original>"
    exit
end

$LOAD_PATH << "#{File.dirname(__FILE__)}/../lib"                # For non-standard installation

require 'getoptlong'


options = {}
GetoptLong.new(
  [ '--seg', '-s', GetoptLong::REQUIRED_ARGUMENT ],
  [ '--src-lang', '--srcLang', '-o', GetoptLong::OPTIONAL_ARGUMENT ],
  [ '--render-format', '-f', GetoptLong::REQUIRED_ARGUMENT ],
).each { |key,val| options[key] = val }

culter = nil
# Load culter module only if required. So, Culter is not mandatory to use Spongiae
if options['--seg'] =~ /^simple$/ then
    require 'culter/simple'; culter = Culter::Simple.new
elsif options['--seg']  =~ /\.srx$/ then
    require 'culter/srx'
    culter = Culter::SRX::SrxDocument.new(options['--seg'])
    if options['--src-lang'] != nil then
        culter = culter.segmenter(options['--src-lang'])
    else
        culter = culter.segmenter('x-unknown')
        puts "SRX found, but missing source language, segmentation will be based on common rules"
    end
end

file = ARGV.shift

require 'spongiae/formats/all'

ext = $1 if file =~ /\.(\w+)$/
fmt = Spongiae::Formats::ALL[ext].sniff(file)
fmt.load!
reader = fmt.create(file,formatOptions)

if options['--render-format'] == nil then
    options['--render-format'] = 'source-para'
    options['--render-format'] = 'align-para' if ext =~ /xl[if]*f$/i
    puts "Did not specify format, using #{options['--render-format']} (file extension #{ext})"
end
dest = file.gsub(/\.(\w+)$/, "-#{options['--render-format']}.html")
puts "Producing #{dest}"

if options['--render-format'] =~ /^t/i then
    def text(unit) unit.traText == nil ? '' : unit.traText.to_html end
else
    def text(unit) unit.srcText end
end

File.open(dest, "w:UTF-8") do |f|
    f.puts <<EOF
<html>
    <head>
        <title>Render #{file} as #{options['--render-format']}</title>
        <meta http-equiv = "Content-Type" content = "text/html; charset=UTF-8">
    </head>
    <body>        
EOF
    f.puts "        <table border=1>" if options['--render-format'] =~ /^a/i
    reader.read_unit do |unit| 
        if options['--render-format'] =~ /^a/i then
           f.puts "<tr>"
           if options['--render-format'] =~ /\-p/i then  
               f.puts "<td>#{unit.srcText.to_html}</td><td>#{unit.traText == nil ? '' : unit.traText.to_html}</td>"
           else # render segments
               src = culter.cut(unit.srcText) 
               tra = unit.traText; if tra != nil then tra = culter.cut(tra) else tra = '' end
               src.each_with_index do |txt,idx|
                   f.puts "<tr>" if idx > 0
                   f.puts "<td>#{txt.to_html}</td>"
                   f.puts "<td rowspan=#{src.count} bgcolor=#EEEEFF>P</td>" if idx == 0
                   f.puts "<td>#{tra[idx] == nil ? '' : tra[idx].to_html}</td>"
                   f.puts "</tr>"
               end
           end
           f.puts "</tr>"
        else
            txt = text(unit)
           if options['--render-format'] =~ /\-p/i then  
               f.puts "<p>#{txt.to_html}</p>"
           else # render segments
               culter.cut(text(unit)) do |seg|
                   f.puts "<p>#{seg.to_html}</p>"
               end
           end
            
        end
    end
    f.puts "        </table>" if options['--render-format'] =~ /^a/i
    f.puts <<EOF
    </body>
</html>
EOF
end
