require 'spongiae/unit'
require 'spongiae/tags'

module Spongiae
   module Formats
       
       class JavaProperties
           
           def initialize(file, props = {})
               @file = file; @props = props
           end
           
           # read_strings : build unit for each string
           # Convert from native2ascii, and treat multi-line entries
           def read_unit(&sub)
               File.open(@file, "r:#{@encoding}") do |f|
                   before = ''
                   while line = f.gets
                       if line =~ /(.+)\s*=\s*(.+)\r?\n/ then
                           key = decode($1); val = decode($2)
                           while val =~ /\\[\s*\r\n]*$/
                             val.sub! /\\[\s*\r\n]*$/, ''
                             val = val + f.gets.gsub(/^\s+/,'')
                           end
                           val.sub! /[\s*\r\n]*$/, ''
                           before.gsub!(/\r?\n$/, '') 
                           yield Spongiae::Unit::Unilingual.new(@file, key, before == '' ? nil : { 'before' => before }, extract_placeables(val))
                           before = ''
                       elsif @props != nil and @props['untranslated'] != nil then
                           before << line                          
                       end
                   end
               end
           end
           
           def decode(v)
               return v.gsub(/\\n/, "\n").gsub(/\\u([0-9A-Fa-f]{4})/) { [Regexp.last_match[1].to_i(16)].pack('U') }
           end
           
           def extract_placeables(st)
               tags = []; st1 = ''
               # Recognize {...} recursive (cannot be done through a regex)
               while (idx = st.index('{')) != nil                   
                   st1 << st[0, idx]; st = st[idx + 1 .. -1]
                   level = 1; tag0 = ''
                   while level > 0
                        idx1 = st.index('{'); idx2 = st.index('}')
                        if idx2 == nil then
                            break 
                        elsif idx1 != nil and idx1 < idx2 then
                            level += 1; tag0 << st[0, idx1 + 1]; st = st[idx1 + 1 .. -1]
                        else
                            level -= 1; tag0 << st[0, idx2 + 1]; st = st[idx2 + 1 .. -1]
                        end
                   end
                   if idx2 == nil then
                       break
                   else
                       tags << Spongiae::Tags::Placeable.new(st1.length , Spongiae::Tags::PlaceHolder.new('{' + tag0.sub(/\}$/,'') + '}', tags.count + 1))
                   end
               end
               if tags.count > 0 then return Spongiae::Tags::TaggedString.new(st1,tags) else return st end 
           end
           
           def translate(dest_file_name,translations_map,props={})
              if @props == nil then @props = props else props.each { |k,v| @props[k] = v } end
              File.open(dest_file_name, 'w:UTF-8') do |dest|
                  read_unit do |unit|
                      tra = unit.text
                      if translations_map[unit.id] != nil then
                         tra = translations_map[unit.id] 
                         dest.puts "#{unit.id} = #{tra.to_native_xml().gsub(/\n/, "\\n\\\n    ").gsub(/[\u0080-\uFFFF]/,"\\u" + $0.ord.to_s(16).rjust(4,"0"))}"
                      elsif props['untranslated'] != nil then
                         dest.puts unit.props['before'] if props['untranslated'] != nil and unit.props != nil and unit.props['before'] != nil
                         tra = nil  # default: do not produce this entry at all
                         if props['untranslated'] == 'empty' then
                             tra = ''
                         elsif props['untranslated'] =~ /^const:(.+)$/ then
                             tra = $1
                         elsif props['untranslated'] =~ /^id/i then
                             tra = unit.id
                         elsif props['untranslated'] =~ /^s(ou)?r|ori/i then
                             tra = unit.srcText
                         end
                         next unless tra != nil
                         dest.puts "#{unit.id} = #{tra.gsub(/\n/, "\\n\\\n    ").gsub(/[\u0080-\uFFFF]/,"\\u" + $0.ord.to_s(16).rjust(4,"0"))}"
                      end
                  end
              end
           end
       end
       
   end
end
 
