#! /usr/bin/env ruby 

$LOAD_PATH << "#{File.dirname(__FILE__)}/../lib"                # For non-standard installation

unless ARGV.count > 2
    require 'spongiae/tmx'
    puts "Spongiae #{Spongiae::VERSION}"
    puts "Syntax: sg_mergeToTmx.rb <dest-file> <source lang> <lang1:file1> <lang2:file2 ... langN:fileN>"
    exit
end

require 'spongiae/tmx'
require 'spongiae/xliff'

File.open(ARGV.shift, "w:UTF-8") do |destTmx|
   writer = Spongiae::TMX::TmxWriter.new(destTmx)
   src_lang = ARGV.shift
   files = {}; ARGV.each do |item| 
       if item =~ /^([\w\-]+):(.+)$/ then files[$1] = $2
       elsif item =~ /[Ff]$/ then # xliff, not TMX
           meta = Spongiae::XLIFF::read_meta(item)
           raise "Could not find target language for #{item}" if meta == nil or meta['traLang'] == nil 
           puts "Using #{item} for lang #{meta['traLang']}"
           files[meta['traLang']] = item
       elsif item !~ /tmx$/i then
           item =~ /\.(.+)$/
           raise "Format #{$1} not supported"
       else
           files['tmx:' + item] = item
       end
   end
   if src_lang =~ /\.(\w+)xli?ff?$/ then
        meta = Spongiae::XLIFF::read_meta(src_lang)
        raise "Could not find target language for #{src_lang}" if meta == nil or meta['traLang'] == nil 
        raise "Could not find source language for #{src_lang}" if meta == nil or meta['srcLang'] == nil 
        files[meta['traLang']] = src_lang
        puts "Using #{src_lang} for lang #{meta['traLang']}"
        src_lang = meta['srcLang']
        puts "Source language is #{src_lang}"
   elsif src_lang =~ /\.tmx$/i then
        files['tmx:' + src_lang] = src_lang
        meta = Spongiae::TMX::read_meta(src_lang)
        src_lang = meta['srcLang']
        puts "Source language is #{src_lang}"
   elsif src_lang =~ /\.\w+$/ then
       raise "Source language is mandatory except if source files are in XLIFF"
   end
   maps = {}; files.each do |lang,filename| 
       if filename =~ /\.\w*xli?ff?$/i then
           maps[lang] = Spongiae::XLIFF::read_units(filename) 
       elsif filename =~ /\.tmx$/i then
           maps[lang] = units = {}
           Spongiae::TMX::TmxReader.new(filename).read_unit { |tu| units[tu.id] = tu }
       elsif filename =~ /\.pot?/i then
           maps[lang] = Hash.new
           require 'spongiae/formats/gettext'
           reader = Spongiae::Formats::GettextPo.new(filename, { :includeDeleted => true })
           reader.read_unit { |tu| maps[lang][tu.id] = tu unless tu.traText == nil or tu.traText.length == 0 }
       else
           if filename =~ /\.(.+)$/ then raise "Format #{$1} cannot be used for merge" else raise "File #{filename} cannot be used for merge" end
       end
   end
   Spongiae::TMX::merge(src_lang, maps) { |tu| writer.add tu.id, tu }
   writer.close
end

