/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.filters2;

import gen.core.filters.Filter;
import gen.core.filters.Filters;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import org.omegat.core.Core;
import org.omegat.filters2.IFilter;
import org.omegat.filters2.master.FilterMaster;
import org.omegat.filters2.master.FiltersTableModel;
import org.omegat.gui.filters2.FilterEditor;
import org.omegat.gui.filters2.FiltersCustomizerPanel;
import org.omegat.gui.preferences.BasePreferencesController;
import org.omegat.util.OStrings;
import org.omegat.util.Preferences;
import org.omegat.util.gui.TableColumnSizer;

public class FiltersCustomizerController
extends BasePreferencesController {
    private FiltersCustomizerPanel panel;
    private final boolean isProjectSpecific;
    private final Filters defaultFilters;
    private final Filters userFilters;
    private final Filters projectFilters;
    private Filters editableFilters;
    private Collection<String> inUseFilters = Collections.emptySet();

    public FiltersCustomizerController() {
        this(false, FilterMaster.createDefaultFiltersConfig(), Preferences.getFilters(), null);
    }

    public FiltersCustomizerController(boolean projectSpecific, Filters defaultFilters, Filters userFilters, Filters projectFilters) {
        this.isProjectSpecific = projectSpecific;
        this.defaultFilters = defaultFilters;
        this.userFilters = userFilters == null ? defaultFilters : userFilters;
        this.projectFilters = projectFilters;
    }

    @Override
    public JComponent getGui() {
        if (this.panel == null) {
            this.initGui();
            this.initFromPrefs();
        }
        return this.panel;
    }

    @Override
    public String toString() {
        return this.isProjectSpecific ? OStrings.getString("FILTERSCUSTOMIZER_TITLE_PROJECTSPECIFIC") : OStrings.getString("FILTERSCUSTOMIZER_TITLE");
    }

    private void initGui() {
        this.panel = new FiltersCustomizerPanel();
        this.panel.filtersTable.setDefaultRenderer(String.class, new FilterFormatCellRenderer());
        this.panel.filtersTable.getSelectionModel().addListSelectionListener(e -> {
            if (e.getValueIsAdjusting()) {
                return;
            }
            ListSelectionModel lsm = (ListSelectionModel)e.getSource();
            if (lsm.isSelectionEmpty()) {
                this.panel.editButton.setEnabled(false);
                this.panel.optionsButton.setEnabled(false);
            } else {
                this.panel.editButton.setEnabled(true);
                Filter currFilter = this.getFilterAtRow(this.panel.filtersTable.getSelectedRow());
                IFilter f = FilterMaster.getFilterInstance(currFilter.getClassName());
                this.panel.optionsButton.setEnabled(f != null && f.hasOptions());
            }
        });
        this.panel.filtersTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent me) {
                if (me.getClickCount() == 2 && me.getButton() == 1) {
                    FiltersCustomizerController.this.doEdit(((FiltersCustomizerController)FiltersCustomizerController.this).panel.filtersTable.rowAtPoint(me.getPoint()));
                }
            }
        });
        TableColumnSizer.autoSize(this.panel.filtersTable, 0, true);
        if (!this.isProjectSpecific) {
            this.panel.projectSpecificCB.setVisible(false);
        }
        this.panel.projectSpecificCB.addActionListener(e -> this.updateEnabledness());
        this.panel.cbRemoveTags.addActionListener(e -> this.editableFilters.setRemoveTags(this.panel.cbRemoveTags.isSelected()));
        this.panel.cbRemoveSpacesNonseg.addActionListener(e -> this.editableFilters.setRemoveSpacesNonseg(this.panel.cbRemoveSpacesNonseg.isSelected()));
        this.panel.cbPreserveSpaces.addActionListener(e -> this.editableFilters.setPreserveSpaces(this.panel.cbPreserveSpaces.isSelected()));
        this.panel.cbIgnoreFileContext.addActionListener(e -> this.editableFilters.setIgnoreFileContext(this.panel.cbIgnoreFileContext.isSelected()));
        this.panel.optionsButton.addActionListener(e -> {
            Map<String, String> newConfig;
            Filter currFilter = this.getFilterAtRow(this.panel.filtersTable.getSelectedRow());
            IFilter f = FilterMaster.getFilterInstance(currFilter.getClassName());
            if (f != null && (newConfig = f.changeOptions(SwingUtilities.windowForComponent(this.panel), FilterMaster.forFilter(currFilter.getOption()))) != null) {
                FilterMaster.setOptions(currFilter, newConfig);
            }
        });
        this.panel.editButton.addActionListener(e -> this.doEdit(this.panel.filtersTable.getSelectedRow()));
        if (Core.getProject().isProjectLoaded()) {
            this.inUseFilters = Core.getProject().getProjectFiles().stream().map(info -> info.filterFileFormatName).collect(Collectors.toSet());
        }
    }

    private void updateEnabledness() {
        boolean enabled = this.isEditable();
        this.panel.filtersTable.setEnabled(enabled);
        this.panel.filtersTable.setFocusable(enabled);
        this.panel.cbRemoveTags.setEnabled(enabled);
        this.panel.cbRemoveSpacesNonseg.setEnabled(enabled);
        this.panel.cbPreserveSpaces.setEnabled(enabled);
        this.panel.cbIgnoreFileContext.setEnabled(enabled);
        if (!enabled) {
            this.panel.filtersTable.getSelectionModel().clearSelection();
        }
    }

    private void doEdit(int row) {
        if (!this.isEditable()) {
            return;
        }
        Filter filter = this.getFilterAtRow(row);
        FilterEditor editor = new FilterEditor(SwingUtilities.windowForComponent(this.panel), filter);
        editor.setVisible(true);
        if (editor.result != null) {
            List<Filter> filters = this.editableFilters.getFilters();
            filters.set(filters.indexOf(filter), editor.result);
        }
    }

    private Filter getFilterAtRow(int row) {
        return ((FiltersTableModel)this.panel.filtersTable.getModel()).getFilterAtRow(this.panel.filtersTable.convertRowIndexToModel(row));
    }

    @Override
    protected void initFromPrefs() {
        this.editableFilters = this.isProjectSpecific && this.projectFilters != null ? FilterMaster.cloneConfig(this.projectFilters) : FilterMaster.cloneConfig(this.userFilters);
        this.panel.filtersTable.setModel(new FiltersTableModel(this.editableFilters));
        TableRowSorter<TableModel> sorter = new TableRowSorter<TableModel>(this.panel.filtersTable.getModel());
        this.panel.filtersTable.setRowSorter(sorter);
        ArrayList<RowSorter.SortKey> sortkeys = new ArrayList<RowSorter.SortKey>();
        sortkeys.add(new RowSorter.SortKey(1, SortOrder.DESCENDING));
        sortkeys.add(new RowSorter.SortKey(0, SortOrder.ASCENDING));
        sorter.setSortKeys(sortkeys);
        if (this.isProjectSpecific) {
            this.panel.projectSpecificCB.setSelected(this.projectFilters != null);
        }
        this.panel.cbRemoveTags.setSelected(this.editableFilters.isRemoveTags());
        this.panel.cbRemoveSpacesNonseg.setSelected(this.editableFilters.isRemoveSpacesNonseg());
        this.panel.cbPreserveSpaces.setSelected(this.editableFilters.isPreserveSpaces());
        this.panel.cbIgnoreFileContext.setSelected(this.editableFilters.isIgnoreFileContext());
        this.updateEnabledness();
    }

    @Override
    public void persist() {
        if (!this.isProjectSpecific) {
            Core.setFilterMaster(new FilterMaster(this.editableFilters));
            Preferences.setFilters(this.editableFilters);
        }
    }

    @Override
    public void restoreDefaults() {
        if (this.isEditable()) {
            this.editableFilters = FilterMaster.cloneConfig(this.defaultFilters);
            this.panel.filtersTable.setModel(new FiltersTableModel(this.editableFilters));
            this.panel.cbRemoveTags.setSelected(this.editableFilters.isRemoveTags());
            this.panel.cbRemoveSpacesNonseg.setSelected(this.editableFilters.isRemoveSpacesNonseg());
            this.panel.cbPreserveSpaces.setSelected(this.editableFilters.isPreserveSpaces());
            this.panel.cbIgnoreFileContext.setSelected(this.editableFilters.isIgnoreFileContext());
        }
    }

    private boolean isEditable() {
        return !this.isProjectSpecific || this.panel.projectSpecificCB.isSelected();
    }

    public Filters getResult() {
        if (this.isEditable()) {
            return this.editableFilters;
        }
        return null;
    }

    private class FilterFormatCellRenderer
    extends DefaultTableCellRenderer {
        private FilterFormatCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component component = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (value != null && FiltersCustomizerController.this.inUseFilters.contains(value.toString())) {
                component.setFont(component.getFont().deriveFont(1));
            }
            return component;
        }
    }
}

