/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.util.gui;

import com.vlsolutions.swing.docking.Dockable;
import com.vlsolutions.swing.docking.DockableState;
import com.vlsolutions.swing.docking.DockingDesktop;
import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.Timer;
import javax.swing.text.Caret;
import javax.swing.text.DefaultCaret;
import javax.swing.text.JTextComponent;
import javax.swing.undo.UndoManager;
import org.omegat.core.Core;
import org.omegat.gui.main.DockableScrollPane;
import org.omegat.util.Java8Compat;
import org.omegat.util.Platform;
import org.omegat.util.Preferences;
import org.omegat.util.gui.OSXIntegration;
import org.omegat.util.gui.ResourcesUtil;

public final class StaticUIUtils {
    private static final KeyStroke ESC_KEYSTROKE = KeyStroke.getKeyStroke(27, 0, false);

    private StaticUIUtils() {
    }

    public static void setEscapeClosable(JDialog dialog) {
        StaticUIUtils.setEscapeAction(dialog.getRootPane(), StaticUIUtils.makeCloseAction(dialog));
    }

    public static void setEscapeClosable(JFrame frame) {
        StaticUIUtils.setEscapeAction(frame.getRootPane(), StaticUIUtils.makeCloseAction(frame));
    }

    public static Action makeCloseAction(final Window window) {
        return new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StaticUIUtils.closeWindowByEvent(window);
            }
        };
    }

    public static void closeWindowByEvent(Window window) {
        window.dispatchEvent(new WindowEvent(window, 201));
    }

    public static void setEscapeAction(JDialog dialog, Action action) {
        StaticUIUtils.setEscapeAction(dialog.getRootPane(), action);
    }

    public static void setEscapeAction(JFrame frame, Action action) {
        StaticUIUtils.setEscapeAction(frame.getRootPane(), action);
    }

    public static void setEscapeAction(JRootPane pane, Action action) {
        pane.getInputMap(2).put(ESC_KEYSTROKE, "ESCAPE");
        pane.getActionMap().put("ESCAPE", action);
    }

    public static String truncateToFit(String text, JComponent comp, int margin) {
        int newWidth;
        int middle;
        if (text == null || text.isEmpty() || comp == null) {
            return text;
        }
        int targetWidth = comp.getWidth();
        if (targetWidth < 1) {
            return text;
        }
        Graphics graphics = comp.getGraphics();
        if (graphics == null) {
            return text;
        }
        FontMetrics metrics = graphics.getFontMetrics();
        int fullWidth = metrics.stringWidth(text);
        if (fullWidth + margin < targetWidth) {
            return text;
        }
        int truncateCharWidth = metrics.charWidth('\u2026');
        int chompStart = middle = text.offsetByCodePoints(0, text.codePointCount(0, text.length()) / 2);
        int chompEnd = middle;
        String chomp = null;
        while (chompStart != 0 && chompEnd != text.length() && (newWidth = fullWidth - metrics.stringWidth(chomp = text.substring(chompStart, chompEnd)) + truncateCharWidth + margin) > targetWidth) {
            chompStart = text.offsetByCodePoints(chompStart, -1);
            chompEnd = text.offsetByCodePoints(chompEnd, 1);
        }
        if (chomp != null) {
            text = text.substring(0, chompStart) + '\u2026' + text.substring(chompEnd, text.length());
        }
        return text;
    }

    public static void forwardMouseWheelEvent(Component target, MouseWheelEvent evt) {
        Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(new MouseWheelEvent(target, evt.getID(), evt.getWhen(), evt.getModifiersEx(), evt.getX(), evt.getY(), evt.getClickCount(), evt.isPopupTrigger(), evt.getScrollType(), evt.getScrollAmount(), evt.getWheelRotation()));
    }

    public static void fitInScreen(Component comp) {
        Rectangle maxBounds = GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds();
        Rectangle compBounds = comp.getBounds();
        Rectangle newBounds = new Rectangle(Math.max(compBounds.x, maxBounds.x), Math.max(compBounds.y, maxBounds.y), Math.min(compBounds.width, maxBounds.width - maxBounds.y), Math.min(compBounds.height, maxBounds.height - maxBounds.y));
        if (newBounds.x + newBounds.width > maxBounds.width) {
            newBounds.x = Math.max(maxBounds.x, maxBounds.width - newBounds.width);
        }
        if (newBounds.y + newBounds.height > maxBounds.height) {
            newBounds.y = Math.max(maxBounds.y, maxBounds.height - newBounds.height);
        }
        if (!newBounds.equals(compBounds)) {
            comp.setBounds(newBounds);
        }
    }

    public static void setCaretUpdateEnabled(JTextComponent comp, boolean updateEnabled) {
        Caret caret = comp.getCaret();
        if (caret instanceof DefaultCaret) {
            ((DefaultCaret)caret).setUpdatePolicy(updateEnabled ? 0 : 1);
        }
    }

    public static FocusListener makeCaretAlwaysVisible(final JTextComponent comp) {
        FocusAdapter listener = new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                Caret caret = comp.getCaret();
                caret.setVisible(true);
                caret.setSelectionVisible(true);
            }
        };
        comp.addFocusListener(listener);
        return listener;
    }

    public static int correctFrameWidth(int width) {
        if (Platform.isMacOSX() && System.getProperty("java.version").startsWith("1.8")) {
            int screenWidth = GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds().width;
            width = Math.min(width, screenWidth - 50);
        }
        return width;
    }

    public static void setHierarchyEnabled(Component parent, boolean isEnabled) {
        StaticUIUtils.visitHierarchy(parent, c -> c.setEnabled(isEnabled));
    }

    public static void visitHierarchy(Component parent, Consumer<Component> consumer) {
        StaticUIUtils.visitHierarchy(parent, c -> true, consumer);
    }

    public static void visitHierarchy(Component parent, Predicate<Component> filter, Consumer<Component> consumer) {
        if (filter.test(parent)) {
            consumer.accept(parent);
            if (parent instanceof JComponent) {
                for (Component child : ((JComponent)parent).getComponents()) {
                    StaticUIUtils.visitHierarchy(child, filter, consumer);
                }
            }
        }
    }

    public static List<Component> listHierarchy(Component parent) {
        ArrayList<Component> cs = new ArrayList<Component>();
        StaticUIUtils.visitHierarchy(parent, cs::add);
        return cs;
    }

    private static Optional<Rectangle> getStoredRectangle(String key) {
        try {
            int x = Integer.parseInt(Preferences.getPreference(key + "_x"));
            int y = Integer.parseInt(Preferences.getPreference(key + "_y"));
            int w = StaticUIUtils.correctFrameWidth(Integer.parseInt(Preferences.getPreference(key + "_width")));
            int h = Integer.parseInt(Preferences.getPreference(key + "_height"));
            return Optional.of(new Rectangle(x, y, w, h));
        }
        catch (NumberFormatException e) {
            return Optional.empty();
        }
    }

    public static void persistGeometry(Window window, String key) {
        StaticUIUtils.persistGeometry(window, key, null);
    }

    public static void persistGeometry(Window window, String key, Runnable extraProcessing) {
        StaticUIUtils.getStoredRectangle(key).ifPresent(window::setBounds);
        String xKey = key + "_x";
        String yKey = key + "_y";
        String widthKey = key + "_width";
        String heightKey = key + "_height";
        final Timer timer = new Timer(500, e -> {
            Rectangle bounds = window.getBounds();
            Preferences.setPreference(xKey, bounds.x);
            Preferences.setPreference(yKey, bounds.y);
            Preferences.setPreference(widthKey, bounds.width);
            Preferences.setPreference(heightKey, bounds.height);
            if (extraProcessing != null) {
                extraProcessing.run();
            }
        });
        timer.setRepeats(false);
        window.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentMoved(ComponentEvent e) {
                timer.restart();
            }

            @Override
            public void componentResized(ComponentEvent e) {
                timer.restart();
            }
        });
    }

    public static void setWindowIcon(Window window) {
        List<Image> icons = Platform.isMacOSX() ? Arrays.asList(OSXIntegration.APP_ICON_MAC) : Arrays.asList(ResourcesUtil.APP_ICON_16X16, ResourcesUtil.APP_ICON_32X32);
        window.setIconImages(icons);
    }

    public static Color getHighlightColor(Color base, int adjustment) {
        return new Color(StaticUIUtils.reboundClamp(0, 255, base.getRed() + adjustment), StaticUIUtils.reboundClamp(0, 255, base.getGreen() + adjustment), StaticUIUtils.reboundClamp(0, 255, base.getBlue() + adjustment), base.getAlpha());
    }

    public static Color getHighlightColor(Color base) {
        return StaticUIUtils.getHighlightColor(base, -10);
    }

    static int reboundClamp(int min, int max, int value) {
        if (value < min) {
            return StaticUIUtils.reboundClamp(min, max, min + (min - value));
        }
        if (value > max) {
            return StaticUIUtils.reboundClamp(min, max, max - (value - max));
        }
        return value;
    }

    public static String getKeyStrokeText(KeyStroke ks) {
        StringBuilder sb = new StringBuilder();
        String modifierText = KeyEvent.getModifiersExText(ks.getModifiers());
        sb.append(modifierText);
        String keyText = KeyEvent.getKeyText(ks.getKeyCode());
        if (!keyText.isEmpty() && !modifierText.contains(keyText)) {
            if (sb.length() > 0) {
                sb.append('+');
            }
            sb.append(keyText);
        }
        return sb.toString();
    }

    public static void makeUndoable(JTextComponent comp) {
        final UndoManager manager = new UndoManager();
        comp.getDocument().addUndoableEditListener(manager);
        KeyStroke undo = KeyStroke.getKeyStroke(90, Java8Compat.getMenuShortcutKeyMaskEx(), false);
        AbstractAction undoAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (manager.canUndo()) {
                    manager.undo();
                }
            }
        };
        comp.getInputMap().put(undo, "UNDO");
        comp.getActionMap().put("UNDO", undoAction);
        KeyStroke redo = KeyStroke.getKeyStroke(89, Java8Compat.getMenuShortcutKeyMaskEx(), false);
        AbstractAction redoAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (manager.canRedo()) {
                    manager.redo();
                }
            }
        };
        comp.getInputMap().put(redo, "REDO");
        comp.getActionMap().put("REDO", redoAction);
    }

    public static void requestVisible(DockableScrollPane scrollPane) {
        if (scrollPane.getDockKey().getLocation().equals((Object)DockableState.Location.HIDDEN)) {
            DockingDesktop desktop = Core.getMainWindow().getDesktop();
            Dockable dockable = desktop.getContext().getDockableByKey(scrollPane.getDockKey().getKey());
            desktop.setAutoHide(dockable, false);
        }
    }
}

