/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.machinetranslators;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.awt.Window;
import java.io.IOException;
import java.util.List;
import java.util.TreeMap;
import javax.swing.JCheckBox;
import org.omegat.core.machinetranslators.BaseCachedTranslate;
import org.omegat.core.machinetranslators.MachineTranslateError;
import org.omegat.gui.exttrans.MTConfigDialog;
import org.omegat.util.HttpConnectionUtils;
import org.omegat.util.Language;
import org.omegat.util.Log;
import org.omegat.util.OStrings;
import org.omegat.util.Preferences;

public class Google2Translate
extends BaseCachedTranslate {
    protected static final String PROPERTY_PREMIUM_KEY = "google.api.premium";
    protected static final String PROPERTY_API_KEY = "google.api.key";
    protected static final String GT_URL = "https://translation.googleapis.com/language/translate/v2";
    private static final int MAX_TEXT_LENGTH = 5000;

    @Override
    protected String getPreferenceName() {
        return "allow_google2_translate";
    }

    @Override
    public String getName() {
        return OStrings.getString("MT_ENGINE_GOOGLE2");
    }

    @Override
    protected String translate(Language sLang, Language tLang, String text) throws MachineTranslateError, IOException {
        Object trText = text.length() > 5000 ? text.substring(0, 4997) + "..." : text;
        String prev = this.getFromCache(sLang, tLang, (String)trText);
        if (prev != null) {
            return prev;
        }
        String targetLang = tLang.getLanguageCode();
        if (tLang.getLanguage().compareToIgnoreCase("zh-cn") == 0 || tLang.getLanguage().compareToIgnoreCase("zh-tw") == 0) {
            targetLang = tLang.getLanguage();
        } else if (tLang.getLanguage().compareToIgnoreCase("zh-hk") == 0) {
            targetLang = "ZH-TW";
        }
        String googleKey = this.getCredential(PROPERTY_API_KEY);
        if (googleKey == null || googleKey.isEmpty()) {
            throw new MachineTranslateError(OStrings.getString("GOOGLE_API_KEY_NOTFOUND"));
        }
        TreeMap<String, String> params = new TreeMap<String, String>();
        if (this.isPremium()) {
            params.put("model", "nmt");
        }
        params.put("key", googleKey);
        params.put("source", sLang.getLanguageCode());
        params.put("target", targetLang);
        params.put("q", (String)trText);
        params.put("format", "html");
        TreeMap<String, String> headers = new TreeMap<String, String>();
        headers.put("X-HTTP-Method-Override", "GET");
        String v = HttpConnectionUtils.post(GT_URL, params, headers);
        String tr = this.getJsonResults(v);
        if (tr == null) {
            return null;
        }
        tr = Google2Translate.unescapeHTML(tr);
        tr = this.cleanSpacesAroundTags(tr, (String)trText);
        this.putToCache(sLang, tLang, (String)trText, tr);
        return tr;
    }

    protected String getJsonResults(String json) throws MachineTranslateError {
        ObjectMapper mapper = new ObjectMapper();
        try {
            Response response = (Response)mapper.readValue(json, Response.class);
            List<Translation> translations = response.getData().getTranslations();
            if (translations.size() > 0) {
                return translations.get(0).getTranslatedText();
            }
        }
        catch (Exception e) {
            Log.logErrorRB(e, "MT_JSON_ERROR", new Object[0]);
            throw new MachineTranslateError(OStrings.getString("MT_JSON_ERROR"));
        }
        return null;
    }

    private boolean isPremium() {
        String value = System.getProperty(PROPERTY_PREMIUM_KEY, Preferences.getPreference(PROPERTY_PREMIUM_KEY));
        return Boolean.parseBoolean(value);
    }

    @Override
    public boolean isConfigurable() {
        return true;
    }

    @Override
    public void showConfigurationUI(Window parent) {
        final JCheckBox premiumCheckBox = new JCheckBox(OStrings.getString("MT_ENGINE_GOOGLE2_PREMIUM_LABEL"));
        premiumCheckBox.setSelected(this.isPremium());
        MTConfigDialog dialog = new MTConfigDialog(parent, this.getName()){

            @Override
            protected void onConfirm() {
                String key = this.panel.valueField1.getText().trim();
                boolean temporary = this.panel.temporaryCheckBox.isSelected();
                Google2Translate.this.setCredential(Google2Translate.PROPERTY_API_KEY, key, temporary);
                System.setProperty(Google2Translate.PROPERTY_PREMIUM_KEY, Boolean.toString(premiumCheckBox.isSelected()));
                Preferences.setPreference(Google2Translate.PROPERTY_PREMIUM_KEY, premiumCheckBox.isSelected());
            }
        };
        dialog.panel.valueLabel1.setText(OStrings.getString("MT_ENGINE_GOOGLE2_API_KEY_LABEL"));
        dialog.panel.valueField1.setText(this.getCredential(PROPERTY_API_KEY));
        dialog.panel.valueLabel2.setVisible(false);
        dialog.panel.valueField2.setVisible(false);
        dialog.panel.temporaryCheckBox.setSelected(this.isCredentialStoredTemporarily(PROPERTY_API_KEY));
        dialog.panel.itemsPanel.add(premiumCheckBox);
        dialog.show();
    }

    public static final class Translation {
        private String translatedText;
        private String detectedSourceLanguage;

        public String getTranslatedText() {
            return this.translatedText;
        }

        public void setTranslatedText(String translatedText) {
            this.translatedText = translatedText;
        }

        public String getDetectedSourceLanguage() {
            return this.detectedSourceLanguage;
        }

        public void setDetectedSourceLanguage(String detectedSourceLanguage) {
            this.detectedSourceLanguage = detectedSourceLanguage;
        }

        public String toString() {
            return "Translation{translatedText='" + this.translatedText + "', detectedSourceLanguage='" + this.detectedSourceLanguage + "'}";
        }
    }

    public static final class Data {
        private List<Translation> translations;

        public List<Translation> getTranslations() {
            return this.translations;
        }

        public void setTranslations(List<Translation> translations) {
            this.translations = translations;
        }

        public String toString() {
            return "Data{translations=" + this.translations + "}";
        }
    }

    public static final class Response {
        private Data data;

        public Data getData() {
            return this.data;
        }

        public void setData(Data data) {
            this.data = data;
        }

        public String toString() {
            return "Response{data=" + this.data + "}";
        }
    }
}

