/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.statistics;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SequenceWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.TimeZone;
import javax.xml.bind.JAXB;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.omegat.core.statistics.FileData;
import org.omegat.core.statistics.StatCount;
import org.omegat.core.statistics.StatProjectProperties;
import org.omegat.core.statistics.StatisticsInfo;
import org.omegat.util.OStrings;
import org.omegat.util.StaticUtils;
import org.omegat.util.gui.TextUtil;

@XmlRootElement(name="omegat-stats")
public class StatsResult {
    public static final String[] HT_HEADERS = new String[]{"", OStrings.getString("CT_STATS_Segments"), OStrings.getString("CT_STATS_Words"), OStrings.getString("CT_STATS_Characters_NOSP"), OStrings.getString("CT_STATS_Characters"), OStrings.getString("CT_STATS_Files")};
    private static final String[] HT_ROWS = new String[]{OStrings.getString("CT_STATS_Total"), OStrings.getString("CT_STATS_Remaining"), OStrings.getString("CT_STATS_Unique"), OStrings.getString("CT_STATS_Unique_Remaining")};
    private static final boolean[] HT_ALIGN = new boolean[]{false, true, true, true, true, true};
    public static final String[] FT_HEADERS = new String[]{OStrings.getString("CT_STATS_FILE_Name"), OStrings.getString("CT_STATS_FILE_Total_Segments"), OStrings.getString("CT_STATS_FILE_Remaining_Segments"), OStrings.getString("CT_STATS_FILE_Unique_Segments"), OStrings.getString("CT_STATS_FILE_Unique_Remaining_Segments"), OStrings.getString("CT_STATS_FILE_Total_Words"), OStrings.getString("CT_STATS_FILE_Remaining_Words"), OStrings.getString("CT_STATS_FILE_Unique_Words"), OStrings.getString("CT_STATS_FILE_Unique_Remaining_Words"), OStrings.getString("CT_STATS_FILE_Total_Characters_NOSP"), OStrings.getString("CT_STATS_FILE_Remaining_Characters_NOSP"), OStrings.getString("CT_STATS_FILE_Unique_Characters_NOSP"), OStrings.getString("CT_STATS_FILE_Unique_Remaining_Characters_NOSP"), OStrings.getString("CT_STATS_FILE_Total_Characters"), OStrings.getString("CT_STATS_FILE_Remaining_Characters"), OStrings.getString("CT_STATS_FILE_Unique_Characters"), OStrings.getString("CT_STATS_FILE_Unique_Remaining_Characters")};
    private static final boolean[] FT_ALIGN = new boolean[]{false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true};
    @JsonProperty(value="project")
    private StatProjectProperties props = new StatProjectProperties();
    private StatCount total;
    private StatCount remaining;
    private StatCount unique;
    @JsonProperty(value="unique-remaining")
    private StatCount remainingUnique;
    private Set<String> translated;
    @JsonProperty(value="files")
    private List<FileData> counts;
    @JsonProperty(value="date")
    private String date;

    public StatsResult() {
        this.total = new StatCount();
        this.remaining = new StatCount();
        this.unique = new StatCount();
        this.remainingUnique = new StatCount();
    }

    public StatsResult(StatCount total, StatCount remaining, StatCount unique, StatCount remainingUnique, Set<String> translated, List<FileData> counts) {
        this.total = total;
        this.remaining = remaining;
        this.unique = unique;
        this.remainingUnique = remainingUnique;
        this.translated = translated;
        this.counts = counts;
    }

    public void updateStatisticsInfo(StatisticsInfo hotStat) {
        hotStat.numberOfSegmentsTotal = this.total.segments;
        hotStat.numberOfTranslatedSegments = this.translated.size();
        hotStat.numberOfUniqueSegments = this.unique.segments;
        hotStat.uniqueCountsByFile.clear();
        for (FileData fd : this.counts) {
            hotStat.uniqueCountsByFile.put(fd.filename, fd.unique.segments);
        }
    }

    @XmlElement(name="date")
    public String getDate() {
        return this.date;
    }

    @XmlElement(name="project")
    public StatProjectProperties getProps() {
        return this.props;
    }

    @XmlElement(name="total")
    public StatCount getTotal() {
        return this.total;
    }

    @XmlElement(name="remaining")
    public StatCount getRemaining() {
        return this.remaining;
    }

    @XmlElement(name="unique")
    public StatCount getUnique() {
        return this.unique;
    }

    @XmlElement(name="unique-remaining")
    public StatCount getRemainingUnique() {
        return this.remainingUnique;
    }

    @XmlElement(name="files")
    public List<FileData> getCounts() {
        return this.counts;
    }

    @JsonIgnore
    public String getTextData() {
        return OStrings.getString("CT_STATS_Project_Statistics") + "\n\n" + TextUtil.showTextTable(HT_HEADERS, this.getHeaderTable(), HT_ALIGN) + "\n\n" + OStrings.getString("CT_STATS_FILE_Statistics") + "\n\n" + TextUtil.showTextTable(FT_HEADERS, this.getFilesTable(), FT_ALIGN);
    }

    @JsonIgnore
    public String getJsonData() throws IOException {
        this.setDate();
        StringWriter result = new StringWriter();
        ObjectMapper mapper = new ObjectMapper();
        SequenceWriter writer = mapper.writer().writeValues((Writer)result);
        writer.write((Object)this);
        writer.close();
        return result.toString();
    }

    @JsonIgnore
    public String getXmlData() {
        this.setDate();
        StringWriter result = new StringWriter();
        JAXB.marshal((Object)this, (Writer)result);
        return result.toString();
    }

    private void setDate() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd'T'HHmmss'Z'", Locale.ENGLISH);
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        this.date = dateFormat.format(new Date());
    }

    @JsonIgnore
    public String[][] getHeaderTable() {
        StatCount[] result = new StatCount[]{this.total, this.remaining, this.unique, this.remainingUnique};
        String[][] table = new String[result.length][6];
        for (int i = 0; i < result.length; ++i) {
            table[i][0] = HT_ROWS[i];
            table[i][1] = Integer.toString(result[i].segments);
            table[i][2] = Integer.toString(result[i].words);
            table[i][3] = Integer.toString(result[i].charsWithoutSpaces);
            table[i][4] = Integer.toString(result[i].charsWithSpaces);
            table[i][5] = Integer.toString(result[i].files);
        }
        return table;
    }

    @JsonIgnore
    public String[][] getFilesTable() {
        String[][] table = new String[this.counts.size()][17];
        int r = 0;
        for (FileData numbers : this.counts) {
            table[r][0] = StaticUtils.makeFilenameRelative(numbers.filename, this.props.getSourceRoot());
            table[r][1] = Integer.toString(numbers.total.segments);
            table[r][2] = Integer.toString(numbers.remaining.segments);
            table[r][3] = Integer.toString(numbers.unique.segments);
            table[r][4] = Integer.toString(numbers.remainingUnique.segments);
            table[r][5] = Integer.toString(numbers.total.words);
            table[r][6] = Integer.toString(numbers.remaining.words);
            table[r][7] = Integer.toString(numbers.unique.words);
            table[r][8] = Integer.toString(numbers.remainingUnique.words);
            table[r][9] = Integer.toString(numbers.total.charsWithoutSpaces);
            table[r][10] = Integer.toString(numbers.remaining.charsWithoutSpaces);
            table[r][11] = Integer.toString(numbers.unique.charsWithoutSpaces);
            table[r][12] = Integer.toString(numbers.remainingUnique.charsWithoutSpaces);
            table[r][13] = Integer.toString(numbers.total.charsWithSpaces);
            table[r][14] = Integer.toString(numbers.remaining.charsWithSpaces);
            table[r][15] = Integer.toString(numbers.unique.charsWithSpaces);
            table[r][16] = Integer.toString(numbers.remainingUnique.charsWithSpaces);
            ++r;
        }
        return table;
    }
}

