/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.glossary;

import java.util.Collections;
import java.util.List;
import org.omegat.core.Core;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.gui.common.EntryInfoSearchThread;
import org.omegat.gui.glossary.GlossaryEntry;
import org.omegat.gui.glossary.GlossaryManager;
import org.omegat.gui.glossary.GlossarySearcher;
import org.omegat.gui.glossary.GlossaryTextArea;
import org.omegat.tokenizer.ITokenizer;
import org.omegat.util.Language;
import org.omegat.util.Preferences;

public class FindGlossaryThread
extends EntryInfoSearchThread<List<GlossaryEntry>> {
    private final SourceTextEntry ste;
    private final GlossaryManager manager;

    public FindGlossaryThread(GlossaryTextArea pane, SourceTextEntry newEntry, GlossaryManager manager) {
        super(pane, newEntry);
        this.ste = newEntry;
        this.manager = manager;
    }

    @Override
    protected List<GlossaryEntry> search() {
        ITokenizer tok = Core.getProject().getSourceTokenizer();
        if (tok == null) {
            return Collections.emptyList();
        }
        List<GlossaryEntry> entries = this.manager.getGlossaryEntries(this.ste.getSrcText());
        if (entries == null) {
            return Collections.emptyList();
        }
        Language language = Core.getProject().getProjectProperties().getSourceLanguage();
        boolean merge = Preferences.isPreferenceDefault("glossary_merge_alternate_definitions", true);
        GlossarySearcher searcher = new GlossarySearcher(tok, language, merge){

            @Override
            protected void checkCancelled() {
                FindGlossaryThread.this.checkEntryChanged();
            }
        };
        return searcher.searchSourceMatches(this.ste, entries);
    }
}

