/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.filters3.xml.android;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.omegat.core.data.ProtectedPart;
import org.omegat.filters2.Instance;
import org.omegat.filters3.xml.XMLFilter;
import org.omegat.filters3.xml.android.AndroidDialect;
import org.omegat.util.OStrings;
import org.xml.sax.Attributes;

public class AndroidFilter
extends XMLFilter {
    static final String DO_NOT_TRANSLATE = "do not translate";
    static final String DONT_TRANSLATE = "don't translate";
    static final Set<String> NAMED_TAGS = new HashSet<String>(Arrays.asList("/resources/string", "/resources/color", "/resources/array", "/resources/string-array", "/resources/integer-array"));
    private String id;
    private String idPlurals = "";
    private String comment;
    private String idComment;

    public AndroidFilter() {
        super(new AndroidDialect());
    }

    @Override
    public String getFileFormatName() {
        return OStrings.getString("Android_FILTER_NAME");
    }

    @Override
    public Instance[] getDefaultInstances() {
        return new Instance[]{new Instance("*.xml")};
    }

    @Override
    public boolean isSourceEncodingVariable() {
        return false;
    }

    @Override
    public boolean isTargetEncodingVariable() {
        return false;
    }

    @Override
    public void tagStart(String path, Attributes atts) {
        if (atts != null) {
            if (NAMED_TAGS.contains(path)) {
                this.id = atts.getValue("name");
                this.idComment = this.comment;
            } else if ("/resources/plurals".equals(path)) {
                this.idPlurals = atts.getValue("name");
            } else if ("/resources/plurals/item".equals(path)) {
                this.id = this.idPlurals + "/" + atts.getValue("quantity");
                this.idComment = this.comment;
            }
        }
    }

    @Override
    public void tagEnd(String path) {
        this.comment = null;
        if ("/resources/string".equals(path)) {
            this.idComment = null;
        } else if ("/resources/plurals/item".equals(path)) {
            this.idComment = null;
        }
    }

    @Override
    public void comment(String comment) {
        this.comment = this.comment == null ? comment : this.comment + "\n" + comment;
    }

    @Override
    public String translate(String entry, List<ProtectedPart> protectedParts) {
        String translation;
        String e;
        String c;
        if (this.idComment != null && ((c = this.idComment.toLowerCase(Locale.ENGLISH)).contains(DO_NOT_TRANSLATE) || c.contains(DONT_TRANSLATE))) {
            return entry;
        }
        String r = e = entry.replace("\\'", "'");
        if (this.entryParseCallback != null) {
            this.entryParseCallback.addEntry(this.id, e, null, false, this.idComment, null, this, protectedParts);
        } else if (this.entryTranslateCallback != null && (translation = this.entryTranslateCallback.getTranslation(this.id, e, null)) != null) {
            r = translation;
        }
        return r.replace("'", "\\'");
    }
}

