/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.dialogs;

import java.awt.Window;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JDialog;
import javax.swing.KeyStroke;
import org.omegat.gui.dialogs.KeyStrokeEditorPanel;
import org.omegat.util.OStrings;
import org.omegat.util.gui.StaticUIUtils;

public class KeyStrokeEditorDialog {
    private KeyStroke keyStroke;
    private boolean userDidConfirm;

    public KeyStrokeEditorDialog(KeyStroke keyStroke) {
        this.keyStroke = keyStroke;
    }

    public boolean show(Window parent) {
        final JDialog dialog = new JDialog(parent);
        dialog.setDefaultCloseOperation(2);
        dialog.setModal(true);
        StaticUIUtils.setWindowIcon(dialog);
        final KeyStrokeEditorPanel panel = new KeyStrokeEditorPanel();
        dialog.getContentPane().add(panel);
        panel.shortcutLabel.setText(this.keyStrokeToString(this.keyStroke));
        dialog.setFocusTraversalKeysEnabled(false);
        dialog.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                KeyStrokeEditorDialog.this.keyStroke = KeyStroke.getKeyStrokeForEvent(e);
                panel.shortcutLabel.setText(KeyStrokeEditorDialog.this.keyStrokeToString(KeyStrokeEditorDialog.this.keyStroke));
                e.consume();
            }
        });
        panel.clearButton.addActionListener(e -> {
            this.keyStroke = null;
            panel.shortcutLabel.setText(this.keyStrokeToString(this.keyStroke));
        });
        panel.okButton.addActionListener(e -> {
            this.userDidConfirm = true;
            StaticUIUtils.closeWindowByEvent(dialog);
        });
        panel.cancelButton.addActionListener(e -> {
            this.keyStroke = null;
            this.userDidConfirm = false;
            StaticUIUtils.closeWindowByEvent(dialog);
        });
        dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                dialog.pack();
            }
        });
        dialog.pack();
        dialog.setLocationRelativeTo(parent);
        dialog.setVisible(true);
        return this.userDidConfirm;
    }

    String keyStrokeToString(KeyStroke ks) {
        if (ks == null) {
            return OStrings.getString("KEYSTROKE_EDITOR_NOT_SET");
        }
        return StaticUIUtils.getKeyStrokeText(ks);
    }

    public KeyStroke getResult() {
        return this.keyStroke;
    }
}

