/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.glossary;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.io.FilenameUtils;
import org.omegat.core.Core;
import org.omegat.core.data.ProtectedPart;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.core.glossaries.IGlossary;
import org.omegat.core.glossaries.IWritableGlossary;
import org.omegat.filters2.master.PluginUtils;
import org.omegat.gui.glossary.GlossaryEntry;
import org.omegat.gui.glossary.GlossaryReaderCSV;
import org.omegat.gui.glossary.GlossaryReaderTBX;
import org.omegat.gui.glossary.GlossaryReaderTSV;
import org.omegat.gui.glossary.GlossarySearcher;
import org.omegat.gui.glossary.GlossaryTextArea;
import org.omegat.tokenizer.ITokenizer;
import org.omegat.util.DirectoryMonitor;
import org.omegat.util.Language;
import org.omegat.util.Log;
import org.omegat.util.Preferences;
import org.omegat.util.Token;

public class GlossaryManager
implements DirectoryMonitor.Callback {
    protected DirectoryMonitor monitor;
    private final GlossaryTextArea pane;
    private final Map<String, List<GlossaryEntry>> glossaries = new TreeMap<String, List<GlossaryEntry>>();
    protected File priorityGlossary;
    protected IWritableGlossary priorityExternalGlossary;
    protected IGlossary[] externalGlossaries;

    public static boolean createNewWritableGlossaryFile(File file) throws IOException {
        String ext;
        if (file.exists()) {
            return false;
        }
        switch (ext = "." + FilenameUtils.getExtension((String)file.getPath()).toLowerCase(Locale.ENGLISH)) {
            case ".tab": 
            case ".tsv": 
            case ".txt": 
            case ".utf8": {
                return GlossaryReaderTSV.createEmpty(file);
            }
        }
        return false;
    }

    public GlossaryManager(GlossaryTextArea pane) {
        this.pane = pane;
        ArrayList<IGlossary> gl = new ArrayList<IGlossary>();
        for (Class<?> glc : PluginUtils.getGlossaryClasses()) {
            try {
                gl.add((IGlossary)glc.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
            }
            catch (Exception ex) {
                Log.log(ex);
            }
        }
        this.externalGlossaries = gl.toArray(new IGlossary[gl.size()]);
        Preferences.addPropertyChangeListener(e -> {
            if (Core.getProject().isProjectLoaded()) {
                switch (e.getPropertyName()) {
                    case "glossary_tbx_display_context": {
                        this.forceReloadTBX();
                        break;
                    }
                    case "glossary_not_exact_match": 
                    case "glossary_stemming": {
                        this.forceUpdateGlossary();
                    }
                }
            }
        });
    }

    public void addGlossaryProvider(IGlossary provider) {
        ArrayList<IGlossary> providers = new ArrayList<IGlossary>(Arrays.asList(this.externalGlossaries));
        providers.add(provider);
        this.externalGlossaries = providers.toArray(new IGlossary[providers.size()]);
    }

    public void start() {
        File dir = new File(Core.getProject().getProjectProperties().getGlossaryRoot());
        this.priorityGlossary = new File(Core.getProject().getProjectProperties().getWriteableGlossary());
        this.monitor = new DirectoryMonitor(dir, this);
        this.monitor.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        this.monitor.fin();
        GlossaryManager glossaryManager = this;
        synchronized (glossaryManager) {
            this.glossaries.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fileChanged(File file) {
        block12: {
            GlossaryManager glossaryManager = this;
            synchronized (glossaryManager) {
                this.glossaries.remove(file.getPath());
            }
            if (file.exists()) {
                try {
                    List<GlossaryEntry> entries = this.loadGlossaryFile(file);
                    if (entries != null) {
                        GlossaryManager glossaryManager2 = this;
                        synchronized (glossaryManager2) {
                            Log.logRB("CT_LOADING_GLOSSARY_DETAILS", entries.size(), file.getName());
                            this.glossaries.put(file.getPath(), entries);
                            break block12;
                        }
                    }
                    IGlossary externalGlossary = this.buildExternalGlossaryFromFile(file);
                    if (externalGlossary != null) {
                        this.addGlossaryProvider(externalGlossary);
                        if (this.priorityGlossary.equals(file)) {
                            this.priorityExternalGlossary = (IWritableGlossary)((Object)externalGlossary);
                        }
                    }
                }
                catch (Exception ex) {
                    Log.logRB("CT_ERROR_ACCESS_GLOSSARY_DIR", new Object[0]);
                    Log.log(ex);
                }
            }
        }
        this.pane.refresh();
    }

    public void forceReloadTBX() {
        Set<File> files = this.monitor.getExistFiles();
        for (File f : files) {
            if (!f.getName().toLowerCase(Locale.ENGLISH).endsWith(".tbx")) continue;
            this.fileChanged(f);
        }
    }

    public void forceUpdateGlossary() {
        this.pane.refresh();
    }

    private List<GlossaryEntry> loadGlossaryFile(File file) throws Exception {
        boolean isPriority = this.priorityGlossary.equals(file);
        String fnameLower = file.getName().toLowerCase(Locale.ENGLISH);
        if (fnameLower.endsWith(".tab")) {
            Log.logRB("CT_LOADING_GLOSSARY", file.getName());
            return GlossaryReaderTSV.read(file, isPriority);
        }
        if (fnameLower.endsWith(".utf8") || fnameLower.endsWith(".txt") || fnameLower.endsWith(".tsv")) {
            Log.logRB("CT_LOADING_GLOSSARY", file.getName());
            return GlossaryReaderTSV.read(file, isPriority);
        }
        if (fnameLower.endsWith(".csv")) {
            Log.logRB("CT_LOADING_GLOSSARY", file.getName());
            return GlossaryReaderCSV.read(file, isPriority);
        }
        if (fnameLower.endsWith(".tbx")) {
            Log.logRB("CT_LOADING_GLOSSARY", file.getName());
            return GlossaryReaderTBX.read(file, isPriority);
        }
        return null;
    }

    private IGlossary buildExternalGlossaryFromFile(File file) throws Exception {
        boolean isPriority = this.priorityGlossary.equals(file);
        String fname_lower = file.getName().toLowerCase();
        if (fname_lower.endsWith(".properties")) {
            Properties config = new Properties();
            config.load(new FileInputStream(file));
            Class<?> glosClass = PluginUtils.getPluginsClassLoader().loadClass(config.getProperty("class"));
            Constructor<?> cons = glosClass.getConstructor(Properties.class);
            return (IGlossary)cons.newInstance(config);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<GlossaryEntry> getGlossaryEntries(String src) {
        ArrayList<GlossaryEntry> result = new ArrayList<GlossaryEntry>();
        GlossaryManager glossaryManager = this;
        synchronized (glossaryManager) {
            for (List<GlossaryEntry> en : this.glossaries.values()) {
                result.addAll(en);
            }
        }
        this.addExternalGlossaryEntries(result, src);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<GlossaryEntry> getLocalEntries() {
        ArrayList<GlossaryEntry> result = new ArrayList<GlossaryEntry>();
        GlossaryManager glossaryManager = this;
        synchronized (glossaryManager) {
            for (List<GlossaryEntry> en : this.glossaries.values()) {
                result.addAll(en);
            }
        }
        return result;
    }

    private void addExternalGlossaryEntries(List<GlossaryEntry> result, String src) {
        Language source = Core.getProject().getProjectProperties().getSourceLanguage();
        Language target = Core.getProject().getProjectProperties().getTargetLanguage();
        for (IGlossary gl : this.externalGlossaries) {
            try {
                result.addAll(gl.search(source, target, src));
            }
            catch (Exception ex) {
                Log.log(ex);
            }
        }
    }

    public List<GlossaryEntry> searchSourceMatches(SourceTextEntry ste) {
        ITokenizer tok = Core.getProject().getSourceTokenizer();
        if (tok == null) {
            return Collections.emptyList();
        }
        List<GlossaryEntry> entries = this.getGlossaryEntries(ste.getSrcText());
        if (entries == null) {
            return Collections.emptyList();
        }
        GlossarySearcher searcher = this.buildSearcher(tok, Core.getProject().getProjectProperties().getSourceLanguage());
        return searcher.searchSourceMatches(ste, entries);
    }

    public List<Token[]> searchSourceMatchTokens(SourceTextEntry ste, GlossaryEntry entry) {
        ITokenizer tok = Core.getProject().getSourceTokenizer();
        if (tok == null) {
            return Collections.emptyList();
        }
        GlossarySearcher searcher = this.buildSearcher(tok, Core.getProject().getProjectProperties().getSourceLanguage());
        return searcher.searchSourceMatchTokens(ste, entry);
    }

    public List<String> searchTargetMatches(String trg, ProtectedPart[] protectedParts, GlossaryEntry entry) {
        ITokenizer tok = Core.getProject().getTargetTokenizer();
        if (tok == null) {
            return Collections.emptyList();
        }
        GlossarySearcher searcher = this.buildSearcher(tok, Core.getProject().getProjectProperties().getTargetLanguage());
        return searcher.searchTargetMatches(trg, protectedParts, entry);
    }

    private GlossarySearcher buildSearcher(ITokenizer tokenizer, Language language) {
        boolean merge = Preferences.isPreferenceDefault("glossary_merge_alternate_definitions", true);
        return new GlossarySearcher(tokenizer, language, merge);
    }
}

