/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.glossary;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.text.Highlighter;
import org.omegat.core.Core;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.gui.editor.UnderlineFactory;
import org.omegat.gui.editor.mark.IMarker;
import org.omegat.gui.editor.mark.Mark;
import org.omegat.gui.glossary.GlossaryEntry;
import org.omegat.gui.glossary.GlossaryRenderers;
import org.omegat.gui.glossary.IGlossaryRenderer;
import org.omegat.util.Token;
import org.omegat.util.gui.Styles;

public class TransTipsMarker
implements IMarker {
    protected static final Highlighter.HighlightPainter TRANSTIPS_UNDERLINER = new UnderlineFactory.SolidBoldUnderliner(Styles.EditorColor.COLOR_TRANSTIPS.getColor());

    @Override
    public List<Mark> getMarksForEntry(SourceTextEntry ste, String sourceText, String translationText, boolean isActive) {
        if (!isActive || sourceText == null) {
            return null;
        }
        if (!Core.getEditor().getSettings().isMarkGlossaryMatches()) {
            return null;
        }
        List<GlossaryEntry> glossaryEntries = Core.getGlossary().getDisplayedEntries();
        if (glossaryEntries == null || glossaryEntries.isEmpty()) {
            return null;
        }
        ArrayList<Mark> marks = new ArrayList<Mark>();
        IGlossaryRenderer renderer = GlossaryRenderers.getPreferredGlossaryRenderer();
        for (GlossaryEntry ent : glossaryEntries) {
            String tooltip = renderer.renderToHtml(ent);
            List<Token[]> tokens = Core.getGlossaryManager().searchSourceMatchTokens(ste, ent);
            marks.addAll(TransTipsMarker.getMarksForTokens(tokens, ste.getSrcText(), tooltip));
        }
        return marks;
    }

    private static List<Mark> getMarksForTokens(List<Token[]> tokens, String srcText, String tooltip) {
        if (tokens.isEmpty() || srcText.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Mark> result = new ArrayList<Mark>(tokens.size());
        tokens.sort(Comparator.comparing(toks -> toks[0].getOffset()));
        for (Token[] toks2 : tokens) {
            if (toks2.length > 1) {
                Arrays.sort(toks2, Comparator.comparingInt(Token::getOffset));
            }
            for (Token tok : toks2) {
                Mark newMark;
                Mark prev = result.isEmpty() ? null : (Mark)result.get(result.size() - 1);
                int currStart = tok.getOffset();
                int currEnd = currStart + tok.getLength();
                if (prev != null && TransTipsMarker.canCloseSpan(srcText, prev.endOffset, currStart)) {
                    newMark = new Mark(Mark.ENTRY_PART.SOURCE, prev.startOffset, currEnd);
                    result.set(result.size() - 1, newMark);
                } else {
                    newMark = new Mark(Mark.ENTRY_PART.SOURCE, currStart, currEnd);
                    result.add(newMark);
                }
                newMark.painter = TRANSTIPS_UNDERLINER;
                newMark.toolTipText = tooltip;
            }
        }
        return result;
    }

    private static boolean canCloseSpan(String text, int start, int end) {
        int cp;
        if (start < 0 || end > text.length()) {
            throw new IndexOutOfBoundsException();
        }
        for (int i = start; i < end; i += Character.charCount(cp)) {
            cp = text.codePointAt(i);
            int type = Character.getType(cp);
            if (Character.isWhitespace(cp) || type == 20 || type == 23) continue;
            return false;
        }
        return true;
    }
}

