/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.languagetools;

import java.awt.Component;
import java.awt.Dimension;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.text.AttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import org.omegat.core.Core;
import org.omegat.core.data.IProject;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.core.data.TMXEntry;
import org.omegat.gui.issues.IIssue;
import org.omegat.gui.issues.IIssueProvider;
import org.omegat.gui.issues.IssueDetailSplitPanel;
import org.omegat.gui.issues.SimpleColorIcon;
import org.omegat.languagetools.ILanguageToolBridge;
import org.omegat.languagetools.LanguageToolPrefs;
import org.omegat.languagetools.LanguageToolResult;
import org.omegat.languagetools.LanguageToolWrapper;
import org.omegat.util.OStrings;
import org.omegat.util.StringUtil;
import org.omegat.util.gui.Styles;

public class LanguageToolIssueProvider
implements IIssueProvider {
    @Override
    public List<IIssue> getIssues(SourceTextEntry sourceEntry, TMXEntry tmxEntry) {
        ILanguageToolBridge bridge = LanguageToolWrapper.getBridge();
        if (bridge != null) {
            return bridge.getCheckResults(sourceEntry.getSrcText(), tmxEntry.translation).stream().map(match -> new LanguageToolIssue(sourceEntry, tmxEntry.translation, (LanguageToolResult)match)).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    @Override
    public String getId() {
        return this.getClass().getCanonicalName();
    }

    @Override
    public String getName() {
        return OStrings.getString("ISSUES_LANGUAGETOOL_PROVIDER_NAME");
    }

    static class LanguageToolIssue
    implements IIssue {
        static final Icon ICON = new SimpleColorIcon(Styles.EditorColor.COLOR_LANGUAGE_TOOLS.getColor());
        static final AttributeSet ERROR_STYLE;
        private final SourceTextEntry ste;
        private final String targetText;
        private final LanguageToolResult result;

        LanguageToolIssue(SourceTextEntry ste, String targetText, LanguageToolResult result) {
            this.ste = ste;
            this.targetText = targetText;
            this.result = result;
        }

        @Override
        public Icon getIcon() {
            return ICON;
        }

        @Override
        public String getTypeName() {
            return OStrings.getString("ISSUES_LT_TYPE");
        }

        @Override
        public int getSegmentNumber() {
            return this.ste.entryNum();
        }

        @Override
        public String getDescription() {
            return "<html>" + this.result.message.replace("<suggestion>", "<i>").replace("</suggestion>", "</i>") + "</html>";
        }

        @Override
        public Component getDetailComponent() {
            IssueDetailSplitPanel panel = new IssueDetailSplitPanel();
            panel.firstTextPane.setText(this.ste.getSrcText());
            panel.lastTextPane.setText(this.targetText);
            StyledDocument doc = panel.lastTextPane.getStyledDocument();
            doc.setCharacterAttributes(this.result.start, this.result.end - this.result.start, ERROR_STYLE, false);
            panel.setMinimumSize(new Dimension(0, panel.firstTextPane.getFont().getSize() * 6));
            return panel;
        }

        @Override
        public boolean hasMenuComponents() {
            return true;
        }

        @Override
        public List<? extends JMenuItem> getMenuComponents() {
            JMenuItem item = new JMenuItem(StringUtil.format(OStrings.getString("ISSUES_LT_DISABLE_RULE"), this.result.ruleDescription));
            IProject project = Core.getProject();
            item.setEnabled(project.isProjectLoaded());
            if (project.isProjectLoaded()) {
                String lang = project.getProjectProperties().getTargetLanguage().getLanguageCode();
                item.addActionListener(e -> {
                    LanguageToolPrefs.disableRule(this.result.ruleId, lang);
                    LanguageToolPrefs.applyRules(LanguageToolWrapper.getBridge(), lang);
                });
            }
            return Arrays.asList(item);
        }

        static {
            SimpleAttributeSet attr = new SimpleAttributeSet();
            StyleConstants.setForeground(attr, Styles.EditorColor.COLOR_LANGUAGE_TOOLS.getColor());
            StyleConstants.setBold(attr, true);
            ERROR_STYLE = attr;
        }
    }
}

