/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.languagetools;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.commons.io.IOUtils;
import org.omegat.languagetools.BaseLanguageToolBridge;
import org.omegat.languagetools.LanguageToolResult;
import org.omegat.util.Language;
import org.omegat.util.Log;
import org.omegat.util.OStrings;

public class LanguageToolNetworkBridge
extends BaseLanguageToolBridge {
    private static final String CHECK_PATH = "/v2/check";
    private static final String LANGS_PATH = "/v2/languages";
    private static final String SERVER_CLASS_NAME = "org.languagetool.server.HTTPServer";
    private static final String API_VERSION = "1";
    private Process server;
    private int localPort;
    private String serverUrl;
    private Language sourceLang;
    private Language targetLang;
    private String disabledCategories;
    private String disabledRules;
    private String enabledRules;

    public LanguageToolNetworkBridge(Language sourceLang, Language targetLang, String url) throws Exception {
        if (!LanguageToolNetworkBridge.testServer(url)) {
            Log.logWarningRB("LT_BAD_URL", new Object[0]);
            throw new Exception();
        }
        this.serverUrl = url;
        this.init(sourceLang, targetLang);
    }

    public LanguageToolNetworkBridge(Language sourceLang, Language targetLang, String path, int port) throws Exception {
        this.localPort = port;
        File serverJar = new File(path);
        if (!serverJar.isFile()) {
            Log.logWarningRB("LT_BAD_LOCAL_PATH", new Object[0]);
            throw new Exception();
        }
        try {
            new ServerSocket(port).close();
        }
        catch (Exception e) {
            Log.logWarningRB("LT_BAD_SOCKET", new Object[0]);
            throw new Exception();
        }
        ProcessBuilder pb = new ProcessBuilder("java", "-cp", serverJar.getAbsolutePath(), SERVER_CLASS_NAME, "--port", Integer.toString(port));
        pb.redirectErrorStream(true);
        this.server = pb.start();
        new Thread(() -> {
            try (InputStream is = this.server.getInputStream();){
                int b;
                while ((b = is.read()) != -1) {
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }).start();
        int timeout = 10000;
        int timeWaiting = 0;
        int interval = 10;
        while (true) {
            Thread.sleep(interval);
            timeWaiting += interval;
            try {
                new Socket("localhost", port).close();
            }
            catch (Exception exception) {
                if (timeWaiting < timeout) continue;
                Log.logWarningRB("LT_SERVER_START_TIMEOUT", new Object[0]);
                this.server.destroy();
                throw new Exception();
            }
            break;
        }
        this.serverUrl = "http://localhost:" + port + CHECK_PATH;
        Log.log(OStrings.getString("LT_SERVER_STARTED"));
        try {
            this.init(sourceLang, targetLang);
        }
        catch (Exception ex) {
            this.stop();
            throw ex;
        }
    }

    private void init(Language sourceLang, Language targetLang) throws Exception {
        JsonNode serverLanguages = this.getSupportedLanguages();
        this.sourceLang = LanguageToolNetworkBridge.negotiateLanguage(serverLanguages, sourceLang);
        this.targetLang = LanguageToolNetworkBridge.negotiateLanguage(serverLanguages, targetLang);
        Log.log("Negotiated LanguageTool source language: " + this.sourceLang);
        Log.log("Negotiated LanguageTool target language: " + this.targetLang);
    }

    @Override
    public synchronized void stop() {
        if (this.server != null) {
            try {
                this.server.destroy();
                try {
                    while (true) {
                        new Socket("localhost", this.localPort).close();
                    }
                }
                catch (Exception e) {
                    Log.log(OStrings.getString("LT_SERVER_TERMINATED"));
                    this.server = null;
                }
            }
            catch (Exception ex) {
                Log.log(ex);
            }
        }
    }

    @Override
    public void applyRuleFilters(Set<String> disabledCategories, Set<String> disabledRules, Set<String> enabledRules) {
        this.disabledCategories = String.join((CharSequence)",", disabledCategories);
        this.disabledRules = String.join((CharSequence)",", disabledRules);
        this.enabledRules = String.join((CharSequence)",", enabledRules);
    }

    @Override
    protected List<LanguageToolResult> getCheckResultsImpl(String sourceText, String translationText) throws Exception {
        if (this.targetLang == null) {
            return Collections.emptyList();
        }
        URL url = new URL(this.serverUrl);
        URLConnection conn = url.openConnection();
        conn.setRequestProperty("User-Agent", OStrings.getNameAndVersion());
        conn.setDoOutput(true);
        try (OutputStreamWriter writer = new OutputStreamWriter(conn.getOutputStream(), StandardCharsets.UTF_8);){
            String srcLang = this.sourceLang == null ? null : this.sourceLang.toString();
            writer.write(LanguageToolNetworkBridge.buildPostData(srcLang, this.targetLang.toString(), sourceText, translationText, this.disabledCategories, this.disabledRules, this.enabledRules));
            writer.flush();
        }
        LanguageToolNetworkBridge.checkHttpError(conn);
        String json = "";
        try (InputStream in = conn.getInputStream();){
            json = IOUtils.toString((InputStream)in, (Charset)StandardCharsets.UTF_8);
        }
        ObjectMapper mapper = new ObjectMapper();
        JsonNode response = mapper.readTree(json);
        String apiVersion = response.get("software").get("apiVersion").asText();
        if (!API_VERSION.equals(apiVersion)) {
            Log.logWarningRB("LT_API_VERSION_MISMATCH", new Object[0]);
        }
        JsonNode matches = response.get("matches");
        return StreamSupport.stream(matches.spliterator(), true).map(match -> {
            String message = LanguageToolNetworkBridge.addSuggestionTags(match.get("message").asText());
            int start = match.get("offset").asInt();
            int end = start + match.get("length").asInt();
            JsonNode rule = match.get("rule");
            String ruleId = rule.get("id").asText();
            String ruleDescription = rule.get("description").asText();
            return new LanguageToolResult(message, start, end, ruleId, ruleDescription);
        }).collect(Collectors.toList());
    }

    protected JsonNode getSupportedLanguages() throws Exception {
        String langsUrl = this.serverUrl.replace(CHECK_PATH, LANGS_PATH);
        URL url = new URL(langsUrl);
        URLConnection conn = url.openConnection();
        conn.setRequestProperty("User-Agent", OStrings.getNameAndVersion());
        conn.setDoOutput(true);
        LanguageToolNetworkBridge.checkHttpError(conn);
        String json = "";
        try (InputStream in = conn.getInputStream();){
            json = IOUtils.toString((InputStream)in, (Charset)StandardCharsets.UTF_8);
        }
        ObjectMapper mapper = new ObjectMapper();
        return mapper.readTree(json);
    }

    static void checkHttpError(URLConnection conn) throws Exception {
        HttpURLConnection httpConn;
        if (conn instanceof HttpURLConnection && (httpConn = (HttpURLConnection)conn).getResponseCode() != 200) {
            InputStream err = httpConn.getErrorStream();
            try {
                String errMsg = IOUtils.toString((InputStream)err, (Charset)StandardCharsets.UTF_8);
                throw new Exception(errMsg);
            }
            catch (Throwable throwable) {
                if (err != null) {
                    try {
                        err.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
    }

    static String addSuggestionTags(String str) {
        return str.replaceAll("^([^:]+:\\s?)\"([^']+)\"", "$1<suggestion>$2</suggestion>");
    }

    static String buildPostData(String sourceLang, String targetLang, String sourceText, String targetText, String disabledCategories, String disabledRules, String enabledRules) throws UnsupportedEncodingException {
        String encoding = "UTF-8";
        StringBuilder result = new StringBuilder();
        result.append("text=").append(URLEncoder.encode(targetText, encoding)).append("&language=").append(URLEncoder.encode(targetLang, encoding));
        if (sourceText != null && sourceLang != null) {
            result.append("&srctext=").append(URLEncoder.encode(sourceText, encoding)).append("&motherTongue=").append(URLEncoder.encode(sourceLang, encoding));
        }
        if (disabledCategories != null) {
            result.append("&disabledCategories=").append(URLEncoder.encode(disabledCategories, encoding));
        }
        if (disabledRules != null) {
            result.append("&disabledRules=").append(URLEncoder.encode(disabledRules, encoding));
        }
        if (enabledRules != null) {
            result.append("&enabledRules=").append(URLEncoder.encode(enabledRules, encoding));
        }
        return result.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static boolean testServer(String testUrl) {
        if (testUrl.trim().toLowerCase(Locale.ENGLISH).startsWith("https://languagetool.org/api/v2/check")) {
            return false;
        }
        try {
            URL url = new URL(testUrl);
            URLConnection conn = url.openConnection();
            conn.setDoOutput(true);
            try (OutputStreamWriter writer = new OutputStreamWriter(conn.getOutputStream(), StandardCharsets.UTF_8);){
                writer.write(LanguageToolNetworkBridge.buildPostData(null, "en-US", null, "Test", "FOO", null, null));
                writer.flush();
            }
            LanguageToolNetworkBridge.checkHttpError(conn);
            try (InputStream in = conn.getInputStream();){
                String response = IOUtils.toString((InputStream)in, (Charset)StandardCharsets.UTF_8);
                if (response.contains("<?xml")) {
                    Log.logErrorRB("LT_WRONG_FORMAT_RESPONSE", new Object[0]);
                    boolean bl2 = false;
                    return bl2;
                }
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception e) {
            Log.log(e);
            return false;
        }
    }

    static Language negotiateLanguage(JsonNode serverLangs, Language desiredLang) {
        String omLocale = desiredLang.getLanguage();
        for (JsonNode lang : serverLangs) {
            if (!omLocale.equalsIgnoreCase(lang.get("longCode").asText())) continue;
            return desiredLang;
        }
        String omLang = desiredLang.getLanguageCode();
        for (JsonNode lang : serverLangs) {
            if (!omLang.equalsIgnoreCase(lang.get("longCode").asText())) continue;
            return new Language(desiredLang.getLanguageCode());
        }
        for (JsonNode lang : serverLangs) {
            if (!omLang.equalsIgnoreCase(lang.get("code").asText())) continue;
            return new Language(desiredLang.getLanguageCode());
        }
        return null;
    }
}

