/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.input.BOMInputStream;

public class MagicComment {
    private static final Pattern MAGIC_COMMENT_PATTERN = Pattern.compile("(?<key>[\\w-]+)\\s*:\\s*(?<value>[\\w-]+)(?:\\s*;)?");

    public static Map<String, String> parse(File file) throws IOException {
        String line;
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new BOMInputStream((InputStream)new FileInputStream(file)), StandardCharsets.US_ASCII));){
            line = reader.readLine();
        }
        if (line != null && line.startsWith("#")) {
            return MagicComment.parse(line);
        }
        return Collections.emptyMap();
    }

    public static Map<String, String> parse(String str) {
        if (str == null || str.length() < 11) {
            return Collections.emptyMap();
        }
        int startMarker = str.indexOf("-*- ");
        if (startMarker < 0) {
            return Collections.emptyMap();
        }
        int start = startMarker + 4;
        int end = str.indexOf(" -*-", start);
        if (end < 0) {
            return Collections.emptyMap();
        }
        HashMap<String, String> result = new HashMap<String, String>();
        Matcher m = MAGIC_COMMENT_PATTERN.matcher(str);
        int i = start;
        while (m.find(i) && i < end) {
            String key = m.group("key");
            String value = m.group("value");
            result.put(key, value);
            i = m.end();
        }
        return result;
    }
}

