/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.team2;

import gen.core.project.RepositoryDefinition;
import gen.core.project.RepositoryMapping;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.omegat.core.data.ProjectProperties;
import org.omegat.core.team2.IRemoteRepository2;
import org.omegat.core.team2.ProjectTeamSettings;
import org.omegat.core.team2.RemoteRepositoryFactory;
import org.omegat.util.FileUtil;
import org.omegat.util.Log;
import org.omegat.util.StringUtil;

public class RemoteRepositoryProvider {
    public static final String REPO_SUBDIR = ".repositories/";
    public static final String REPO_PREPARE_SUBDIR = ".repositories/prep/";
    public static final String REPO_GIT_SUBDIR = ".git/";
    public static final String REPO_SVN_SUBDIR = ".svn/";
    final File projectRoot;
    final ProjectTeamSettings teamSettings;
    final List<RepositoryDefinition> repositoriesDefinitions;
    final List<IRemoteRepository2> repositories = new ArrayList<IRemoteRepository2>();
    private String[] forceExcludes = new String[0];
    private List<Mapping> mappingsWithFileListSnapshot;

    public RemoteRepositoryProvider(File projectRoot, List<RepositoryDefinition> repositoriesDefinitions, ProjectProperties props) throws Exception {
        this(projectRoot, repositoriesDefinitions);
        this.setForceExcludesFromProjectProperties(props);
    }

    public RemoteRepositoryProvider(File projectRoot, List<RepositoryDefinition> repositoriesDefinitions) throws Exception {
        this.projectRoot = projectRoot;
        this.teamSettings = new ProjectTeamSettings(new File(projectRoot, REPO_SUBDIR));
        this.repositoriesDefinitions = repositoriesDefinitions;
        this.checkDefinitions();
        this.initializeRepositories();
    }

    public void setForceExcludesFromProjectProperties(ProjectProperties props) {
        this.forceExcludes = new String[]{"/.repositories/", "/.git/", "/.svn/", "/omegat.project", "/" + props.getProjectInternalRelative() + "project_save.tmx", "/" + props.getWritableGlossaryFile().getUnderRoot(), "/" + props.getTargetDir().getUnderRoot()};
    }

    public ProjectTeamSettings getTeamSettings() {
        return this.teamSettings;
    }

    protected void checkDefinitions() {
        TreeSet<String> dirs = new TreeSet<String>();
        for (RepositoryDefinition r : this.repositoriesDefinitions) {
            if (StringUtil.isEmpty(r.getUrl())) {
                throw new RuntimeException("There is no repository url");
            }
            if (!dirs.add(this.getRepositoryDir(r).getAbsolutePath())) {
                throw new RuntimeException("Duplicate repository URL");
            }
            for (RepositoryMapping m : r.getMapping()) {
                if (m.getLocal() != null && m.getRepository() != null) continue;
                throw new RuntimeException("Invalid mapping: local and/or remote is not set.");
            }
        }
    }

    protected void initializeRepositories() throws Exception {
        for (RepositoryDefinition r : this.repositoriesDefinitions) {
            IRemoteRepository2 repo = RemoteRepositoryFactory.create(r.getType());
            repo.init(r, this.getRepositoryDir(r), this.teamSettings);
            this.repositories.add(repo);
        }
    }

    protected List<Mapping> getMappings(String path, String ... forceExcludes) {
        ArrayList<Mapping> result = new ArrayList<Mapping>();
        for (int i = 0; i < this.repositoriesDefinitions.size(); ++i) {
            RepositoryDefinition rd = this.repositoriesDefinitions.get(i);
            for (RepositoryMapping repoMapping : rd.getMapping()) {
                Mapping m = new Mapping(path, this.repositories.get(i), rd, repoMapping, forceExcludes);
                if (!m.matches()) continue;
                result.add(m);
            }
        }
        return result;
    }

    protected Mapping oneMapping(String path) {
        List<Mapping> mappings = this.getMappings(path, new String[0]);
        if (mappings.size() > 1) {
            throw new RuntimeException("Multiple mappings for file '" + path + "'");
        }
        if (mappings.isEmpty()) {
            throw new RuntimeException("There is no mapping for file '" + path + "'");
        }
        return mappings.get(0);
    }

    public boolean isUnderMapping(String path) {
        return !this.getMappings(path, new String[0]).isEmpty();
    }

    public void cleanPrepared() throws IOException {
        FileUtils.deleteDirectory((File)new File(this.projectRoot, REPO_PREPARE_SUBDIR));
    }

    public File toPrepared(File inFile) throws IOException {
        File dir = new File(this.projectRoot, REPO_PREPARE_SUBDIR);
        boolean ignored = dir.mkdirs();
        File out = File.createTempFile("prepared", "", dir);
        FileUtils.copyFile((File)inFile, (File)out);
        return out;
    }

    public void switchAllToLatest() throws Exception {
        ArrayList<Exception> errors = new ArrayList<Exception>();
        for (IRemoteRepository2 r : this.repositories) {
            try {
                r.switchToVersion(null);
            }
            catch (IRemoteRepository2.NetworkException e) {
                throw e;
            }
            catch (Exception e) {
                errors.add(e);
                Log.logErrorRB("TEAM_UPDATE_REPO_ERROR", e.getMessage());
            }
        }
        if (!errors.isEmpty()) {
            throw (Exception)errors.get(0);
        }
    }

    public File switchToVersion(String filePath, String version) throws Exception {
        return this.oneMapping(filePath).switchToVersion(version);
    }

    public String commitFileAfterVersion(String path, String commentText, String ... onVersions) throws Exception {
        return this.oneMapping((String)path).repo.commit(onVersions, commentText);
    }

    public void commitFiles(String path, String commentText) throws Exception {
        TreeMap<String, IRemoteRepository2> repos = new TreeMap<String, IRemoteRepository2>();
        for (Mapping m : this.getMappings(path, new String[0])) {
            repos.put(m.repoDefinition.getUrl(), m.repo);
        }
        for (IRemoteRepository2 repo : repos.values()) {
            repo.commit(null, commentText);
        }
    }

    public void copyFilesFromReposToProject(String localPath) throws IOException {
        this.copyFilesFromReposToProject(localPath, "", true);
    }

    public void copyFilesFromReposToProject(String localPath, String postfix, boolean propagateDelete) throws IOException {
        String[] myForceExcludes = "".equals(localPath) ? this.forceExcludes : new String[]{};
        for (Mapping m : this.getMappings(localPath, myForceExcludes)) {
            m.copyFromRepoToProject(postfix);
            if (!propagateDelete || !"".equals(localPath)) continue;
            m.propagateDeletes();
        }
    }

    public void copyFilesFromProjectToRepos(String localPath, String eolConversionCharset) throws Exception {
        for (Mapping m : this.getMappings(localPath, new String[0])) {
            m.copyFromProjectToRepo(eolConversionCharset);
        }
    }

    public String getVersion(String file) throws Exception {
        return this.oneMapping(file).getVersion();
    }

    protected void copyFile(File from, File to, String eolConversionCharset) throws IOException {
        if (eolConversionCharset != null) {
            FileUtil.copyFileWithEolConversion(from, to, Charset.forName(eolConversionCharset));
        } else {
            FileUtils.copyFile((File)from, (File)to);
        }
    }

    protected void addForCommit(IRemoteRepository2 repo, String path) throws Exception {
        repo.addForCommit(path);
    }

    protected File getRepositoryDir(RepositoryDefinition repo) {
        String path = repo.getUrl().replaceAll("[^A-Za-z0-9.]", "_").replaceAll("__+", "_");
        return new File(new File(this.projectRoot, REPO_SUBDIR), path);
    }

    static String withLeadingSlash(String s) {
        return s.startsWith("/") ? s : "/" + s;
    }

    static String withTrailingSlash(String s) {
        return s.endsWith("/") ? s : s + "/";
    }

    static String withoutLeadingSlash(String s) {
        return s.startsWith("/") ? s.substring(1) : s;
    }

    static String withoutTrailingSlash(String s) {
        return s.endsWith("/") ? s.substring(0, s.length() - 1) : s;
    }

    static String withSlashes(String s) {
        return RemoteRepositoryProvider.withTrailingSlash(RemoteRepositoryProvider.withLeadingSlash(s));
    }

    static String withoutSlashes(String s) {
        return RemoteRepositoryProvider.withoutTrailingSlash(RemoteRepositoryProvider.withoutLeadingSlash(s));
    }

    static File relativeRemoteToAbsoluteLocal(String relativeFile, File projectRoot, String repoPath, String localPath) {
        repoPath = RemoteRepositoryProvider.withSlashes(repoPath);
        localPath = RemoteRepositoryProvider.withSlashes(localPath);
        Path p = new File(repoPath).toPath();
        Path rp = new File(RemoteRepositoryProvider.withLeadingSlash(relativeFile)).toPath();
        Path newRelativeFile = p.relativize(rp);
        File root = new File(projectRoot, RemoteRepositoryProvider.withoutLeadingSlash(localPath));
        return new File(root, RemoteRepositoryProvider.withoutLeadingSlash(newRelativeFile.toString()));
    }

    class Mapping {
        final String filterPrefix;
        final IRemoteRepository2 repo;
        final RepositoryDefinition repoDefinition;
        final RepositoryMapping repoMapping;
        final List<String> forceExcludes;

        Mapping(String path, IRemoteRepository2 repo, RepositoryDefinition repoDefinition, RepositoryMapping repoMapping, String ... forceExcludes) {
            this.repo = repo;
            this.repoDefinition = repoDefinition;
            this.repoMapping = repoMapping;
            this.forceExcludes = new ArrayList<String>();
            path = RemoteRepositoryProvider.withSlashes(path);
            String local = RemoteRepositoryProvider.withSlashes(repoMapping.getLocal());
            if (path.equals("/")) {
                this.filterPrefix = "/";
                this.forceExcludes.addAll(Arrays.asList(forceExcludes));
            } else if (local.equals(path)) {
                this.filterPrefix = "/";
                this.forceExcludes.addAll(this.getTruncatedExclusions(local, forceExcludes));
            } else if (local.startsWith(path)) {
                this.filterPrefix = "/";
                this.forceExcludes.addAll(this.getTruncatedExclusions(local, forceExcludes));
            } else if (path.startsWith(local)) {
                this.filterPrefix = RemoteRepositoryProvider.withSlashes(path.substring(local.length()));
                this.forceExcludes.addAll(Arrays.asList(forceExcludes));
            } else if (local.equals("/")) {
                this.filterPrefix = path;
                this.forceExcludes.addAll(Arrays.asList(forceExcludes));
            } else {
                this.filterPrefix = null;
            }
        }

        List<String> getTruncatedExclusions(String prefix, String ... excludes) {
            String normalizedPrefix = RemoteRepositoryProvider.withSlashes(prefix);
            return Stream.of(excludes).map(RemoteRepositoryProvider::withLeadingSlash).filter(e -> e.startsWith(normalizedPrefix)).map(e -> RemoteRepositoryProvider.withLeadingSlash(e.substring(normalizedPrefix.length()))).collect(Collectors.toList());
        }

        public boolean matches() {
            return this.filterPrefix != null;
        }

        public void copyFromRepoToProject(String postfix) throws IOException {
            if (!this.matches()) {
                throw new RuntimeException("Path doesn't match with mapping");
            }
            File from = new File(RemoteRepositoryProvider.this.getRepositoryDir(this.repoDefinition), RemoteRepositoryProvider.withoutLeadingSlash(this.repoMapping.getRepository()));
            File to = new File(RemoteRepositoryProvider.this.projectRoot, RemoteRepositoryProvider.withoutLeadingSlash(this.repoMapping.getLocal()));
            if (from.isDirectory()) {
                ArrayList<String> excludes = new ArrayList<String>(this.repoMapping.getExcludes());
                excludes.addAll(this.forceExcludes);
                this.copy(from, to, this.filterPrefix, postfix, this.repoMapping.getIncludes(), excludes, null);
            } else {
                if (!from.exists()) {
                    throw new RuntimeException("Location '" + RemoteRepositoryProvider.withoutLeadingSlash(this.repoMapping.getRepository()) + "' does not exist in repository " + this.repoDefinition.getUrl());
                }
                if (!this.filterPrefix.equals("/")) {
                    throw new RuntimeException("Filter prefix should have been / for file mapping, but was " + this.filterPrefix);
                }
                RemoteRepositoryProvider.this.copyFile(from, to, null);
            }
        }

        public void copyFromProjectToRepo(String eolConversionCharset) throws Exception {
            if (!this.matches()) {
                throw new RuntimeException("Path doesn't match with mapping");
            }
            File from = new File(RemoteRepositoryProvider.this.projectRoot, RemoteRepositoryProvider.withoutLeadingSlash(this.repoMapping.getLocal()));
            File to = new File(RemoteRepositoryProvider.this.getRepositoryDir(this.repoDefinition), RemoteRepositoryProvider.withoutLeadingSlash(this.repoMapping.getRepository()));
            if (from.isDirectory()) {
                List<String> files = this.copy(from, to, this.filterPrefix, this.repoMapping.getIncludes(), this.repoMapping.getExcludes(), eolConversionCharset);
                String repoSubdir = RemoteRepositoryProvider.withoutLeadingSlash(this.repoMapping.getRepository());
                if (!"".equals(repoSubdir)) {
                    repoSubdir = RemoteRepositoryProvider.withTrailingSlash(repoSubdir);
                }
                for (String f : files) {
                    RemoteRepositoryProvider.this.addForCommit(this.repo, repoSubdir + RemoteRepositoryProvider.withoutSlashes(f));
                }
            } else {
                if (!this.filterPrefix.equals("/")) {
                    throw new RuntimeException("Filter prefix should have been '/' for file mapping, but was '" + this.filterPrefix + "'");
                }
                RemoteRepositoryProvider.this.copyFile(from, to, eolConversionCharset);
                RemoteRepositoryProvider.this.addForCommit(this.repo, RemoteRepositoryProvider.withoutSlashes(this.repoMapping.getRepository()));
            }
        }

        public File switchToVersion(String version) throws Exception {
            this.repo.switchToVersion(version);
            File to = new File(RemoteRepositoryProvider.this.getRepositoryDir(this.repoDefinition), this.repoMapping.getRepository());
            return new File(to, this.filterPrefix);
        }

        public String getVersion() throws Exception {
            return this.repo.getFileVersion(new File(this.repoMapping.getRepository(), this.filterPrefix).getPath());
        }

        protected List<String> copy(File from, File to, String prefix, List<String> includes, List<String> excludes, String eolConversionCharset) throws IOException {
            return this.copy(from, to, prefix, "", includes, excludes, eolConversionCharset);
        }

        protected List<String> copy(File from, File to, String prefix, String postfix, List<String> includes, List<String> excludes, String eolConversionCharset) throws IOException {
            prefix = RemoteRepositoryProvider.withSlashes(prefix);
            List<String> relativeFiles = FileUtil.buildRelativeFilesList(from, includes, excludes);
            ArrayList<String> copied = new ArrayList<String>();
            for (String rf : relativeFiles) {
                String srf = RemoteRepositoryProvider.withSlashes(rf);
                if (srf.startsWith("/.repositories/") || !prefix.equals("/") && !srf.startsWith(prefix)) continue;
                if (postfix.isEmpty()) {
                    RemoteRepositoryProvider.this.copyFile(new File(from, rf), new File(to, srf), eolConversionCharset);
                } else {
                    RemoteRepositoryProvider.this.copyFile(new File(from, rf), new File(to, rf + postfix), eolConversionCharset);
                }
                copied.add(rf);
            }
            return copied;
        }

        public void propagateDeletes() {
            try {
                String[] toDeleteFiles;
                for (String relativeFile : toDeleteFiles = this.repo.getRecentlyDeletedFiles()) {
                    if (!FileUtil.checkFileInclude(relativeFile, FileUtil.compileFileMasks(this.repoMapping.getIncludes()), FileUtil.compileFileMasks(this.repoMapping.getExcludes()))) continue;
                    File fileToDelete = RemoteRepositoryProvider.relativeRemoteToAbsoluteLocal(relativeFile, RemoteRepositoryProvider.this.projectRoot, this.repoMapping.getRepository(), this.repoMapping.getLocal());
                    this.deleteFile(fileToDelete);
                }
            }
            catch (Exception e) {
                Log.log(e);
            }
        }

        private void deleteFile(File f) {
            if (!f.exists()) {
                return;
            }
            try {
                if (f.isFile()) {
                    boolean bl = f.delete();
                } else {
                    FileUtils.deleteDirectory((File)f);
                }
            }
            catch (Exception e) {
                Log.logInfoRB("LOG_ERROR_DELETE_FILE", f.toString());
            }
        }
    }
}

