/*
 * Decompiled with CFR 0.152.
 */
package net.briac.omegat.plugin.omt;

import gen.core.project.Masks;
import gen.core.project.Omegat;
import gen.core.project.Project;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import org.apache.commons.lang.StringUtils;
import org.omegat.core.data.ProjectProperties;

public class ProjectFileStorage {
    private static final JAXBContext CONTEXT;
    private static final String DEFAULT_FOLDER_MARKER = "__DEFAULT__";

    public static void writeProjectFile(ProjectProperties props, File outFile) throws Exception {
        String root = outFile.getAbsoluteFile().getParent();
        Omegat om = new Omegat();
        om.setProject(new Project());
        om.getProject().setVersion("1.0");
        om.getProject().setSourceDir(ProjectFileStorage.getPathForStoring(root, props.getSourceRoot(), "source"));
        om.getProject().setSourceDirExcludes(new Masks());
        om.getProject().getSourceDirExcludes().getMask().addAll(props.getSourceRootExcludes());
        om.getProject().setTargetDir(ProjectFileStorage.getPathForStoring(root, props.getTargetRoot(), "target"));
        om.getProject().setTmDir(ProjectFileStorage.getPathForStoring(root, props.getTMRoot(), "tm"));
        String glossaryDir = ProjectFileStorage.getPathForStoring(root, props.getGlossaryRoot(), "glossary");
        om.getProject().setGlossaryDir(glossaryDir);
        String glossaryFile = ProjectFileStorage.getPathForStoring(props.getGlossaryRoot(), props.getWriteableGlossary(), null);
        if (glossaryDir.equalsIgnoreCase(DEFAULT_FOLDER_MARKER) && new File(glossaryFile).getName().equals("glossary.txt")) {
            glossaryFile = DEFAULT_FOLDER_MARKER;
        }
        om.getProject().setGlossaryFile(glossaryFile);
        om.getProject().setDictionaryDir(ProjectFileStorage.getPathForStoring(root, props.getDictRoot(), "dictionary"));
        om.getProject().setSourceLang(props.getSourceLanguage().toString());
        om.getProject().setTargetLang(props.getTargetLanguage().toString());
        om.getProject().setSourceTok(props.getSourceTokenizer().getCanonicalName());
        om.getProject().setTargetTok(props.getTargetTokenizer().getCanonicalName());
        om.getProject().setSentenceSeg(Boolean.valueOf(props.isSentenceSegmentingEnabled()));
        om.getProject().setSupportDefaultTranslations(Boolean.valueOf(props.isSupportDefaultTranslations()));
        om.getProject().setRemoveTags(Boolean.valueOf(props.isRemoveTags()));
        om.getProject().setExternalCommand(props.getExternalCommand());
        if (props.getRepositories() != null && !props.getRepositories().isEmpty()) {
            om.getProject().setRepositories(new Project.Repositories());
            om.getProject().getRepositories().getRepository().addAll(props.getRepositories());
        }
        Marshaller m = CONTEXT.createMarshaller();
        m.setProperty("jaxb.formatted.output", (Object)true);
        m.marshal((Object)om, outFile);
    }

    private static String getPathForStoring(String root, String absolutePath, String defaultName) throws IOException {
        if (defaultName != null && new File(absolutePath).getCanonicalPath().equals(new File(root, defaultName).getCanonicalPath())) {
            return DEFAULT_FOLDER_MARKER;
        }
        String result = absolutePath;
        try {
            Path absPath = Paths.get(absolutePath, new String[0]).normalize();
            String rel = Paths.get(root, new String[0]).relativize(absPath).toString();
            result = StringUtils.countMatches((String)rel, (String)(".." + File.separatorChar)) <= 5 ? rel : absPath.toString();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return ProjectFileStorage.normalizeSlashes(result);
    }

    static String normalizeSlashes(String path) {
        return ProjectFileStorage.withoutTrailingSlash(path.replace('\\', '/'));
    }

    static String withoutTrailingSlash(String path) {
        while (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        return path;
    }

    static {
        try {
            CONTEXT = JAXBContext.newInstance((Class[])new Class[]{Omegat.class});
        }
        catch (Exception ex) {
            throw new ExceptionInInitializerError(ex);
        }
    }
}

