/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.segment.srx.legacy;

import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ReaderMatcher
implements MatchResult {
    private Matcher matcher;
    private CharSequence text;
    private int oldLength;

    public ReaderMatcher(Pattern pattern, CharSequence text) {
        this.text = text;
        this.oldLength = text.length();
        this.matcher = pattern.matcher(text);
    }

    public ReaderMatcher appendReplacement(StringBuffer sb, String replacement) {
        this.matcher.appendReplacement(sb, replacement);
        return this;
    }

    public StringBuffer appendTail(StringBuffer sb) {
        return this.matcher.appendTail(sb);
    }

    public int end() {
        return this.matcher.end();
    }

    public int end(int group) {
        return this.matcher.end(group);
    }

    public boolean find() {
        boolean result = false;
        int end = this.getEnd();
        try {
            result = this.matcher.find();
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        if (this.lengthChanged()) {
            int regionStart = Math.max(end, this.matcher.regionStart());
            int regionEnd = Math.min(this.text.length(), this.matcher.regionEnd());
            this.matcher.reset(this.text);
            this.matcher.region(regionStart, regionEnd);
            result = this.matcher.find();
        }
        return result;
    }

    public boolean find(int start) {
        boolean result = false;
        try {
            result = this.matcher.find(start);
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        if (this.lengthChanged()) {
            int regionStart = this.matcher.regionStart();
            int regionEnd = Math.min(this.text.length(), this.matcher.regionEnd());
            this.matcher.reset(this.text);
            this.matcher.region(regionStart, regionEnd);
            result = this.matcher.find(start);
        }
        return result;
    }

    public String group() {
        return this.matcher.group();
    }

    public String group(int group) {
        return this.matcher.group(group);
    }

    public int groupCount() {
        return this.matcher.groupCount();
    }

    public boolean hasAnchoringBounds() {
        return this.matcher.hasAnchoringBounds();
    }

    public boolean hasTransparentBounds() {
        return this.matcher.hasTransparentBounds();
    }

    public boolean hitEnd() {
        return this.matcher.hitEnd();
    }

    public boolean lookingAt() {
        boolean result = false;
        try {
            result = this.matcher.lookingAt();
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        if (this.lengthChanged()) {
            int regionStart = this.matcher.regionStart();
            int regionEnd = Math.min(this.text.length(), this.matcher.regionEnd());
            this.matcher.reset(this.text);
            this.matcher.region(regionStart, regionEnd);
            result = this.matcher.lookingAt();
        }
        return result;
    }

    public boolean matches() {
        boolean result = false;
        try {
            result = this.matcher.matches();
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        if (this.lengthChanged()) {
            int regionStart = this.matcher.regionStart();
            int regionEnd = Math.min(this.text.length(), this.matcher.regionEnd());
            this.matcher.reset(this.text);
            this.matcher.region(regionStart, regionEnd);
            result = this.matcher.matches();
        }
        return result;
    }

    public Pattern pattern() {
        return this.matcher.pattern();
    }

    public ReaderMatcher region(int start, int end) {
        this.matcher.region(start, end);
        return this;
    }

    public int regionEnd() {
        return this.matcher.regionEnd();
    }

    public int regionStart() {
        return this.matcher.regionStart();
    }

    public String replaceAll(String replacement) {
        String result = null;
        try {
            result = this.matcher.replaceAll(replacement);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        if (this.lengthChanged()) {
            this.matcher.reset(this.text);
            result = this.matcher.replaceAll(replacement);
        }
        return result;
    }

    public String replaceFirst(String replacement) {
        String result = null;
        try {
            result = this.matcher.replaceFirst(replacement);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        if (this.lengthChanged()) {
            this.matcher.reset(this.text);
            result = this.matcher.replaceFirst(replacement);
        }
        return result;
    }

    public boolean requireEnd() {
        return this.matcher.requireEnd();
    }

    public ReaderMatcher reset() {
        this.matcher.reset();
        return this;
    }

    public ReaderMatcher reset(CharSequence input) {
        this.matcher.reset(input);
        return this;
    }

    public int start() {
        return this.matcher.start();
    }

    public int start(int group) {
        return this.matcher.start(group);
    }

    public MatchResult toMatchResult() {
        return this.matcher.toMatchResult();
    }

    public String toString() {
        return "ReaderMatcher: " + this.matcher.toString();
    }

    public ReaderMatcher useAnchoringBounds(boolean b) {
        this.matcher.useAnchoringBounds(b);
        return this;
    }

    public ReaderMatcher usePattern(Pattern newPattern) {
        this.matcher.usePattern(newPattern);
        return this;
    }

    public ReaderMatcher useTransparentBounds(boolean b) {
        this.matcher.useTransparentBounds(b);
        return this;
    }

    private int getEnd() {
        try {
            return this.matcher.end();
        }
        catch (IllegalStateException e) {
            return 0;
        }
    }

    private boolean lengthChanged() {
        if (this.text.length() < this.oldLength) {
            this.oldLength = this.text.length();
            return true;
        }
        return false;
    }
}

