/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.en;

import java.util.ResourceBundle;
import java.util.regex.Pattern;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.Language;
import org.languagetool.rules.GenericUnpairedBracketsRule;

public class EnglishUnpairedBracketsRule
extends GenericUnpairedBracketsRule {
    private static final String[] EN_START_SYMBOLS = new String[]{"[", "(", "{", "\u201c", "\"", "'"};
    private static final String[] EN_END_SYMBOLS = new String[]{"]", ")", "}", "\u201d", "\"", "'"};
    private static final Pattern NUMBER = Pattern.compile("\\d+");

    public EnglishUnpairedBracketsRule(ResourceBundle messages, Language language) {
        super(messages, language);
        this.startSymbols = EN_START_SYMBOLS;
        this.endSymbols = EN_END_SYMBOLS;
        this.uniqueMapInit();
    }

    public String getId() {
        return "EN_UNPAIRED_BRACKETS";
    }

    protected boolean isNoException(String tokenStr, AnalyzedTokenReadings[] tokens, int i, int j, boolean precSpace, boolean follSpace) {
        boolean superException;
        if (i <= 1) {
            return true;
        }
        boolean bl = superException = !super.isNoException(tokenStr, tokens, i, j, precSpace, follSpace);
        if (superException) {
            return false;
        }
        if (!precSpace && follSpace) {
            AnalyzedTokenReadings prevToken = tokens[i - 1];
            if ("\"".equals(tokenStr) && NUMBER.matcher(prevToken.getToken()).matches()) {
                return false;
            }
            if ("'".equals(tokenStr) && tokens[i].hasPosTag("POS")) {
                return false;
            }
            if ("'".equals(tokenStr) && prevToken.hasPosTag("VBG") && prevToken.getToken().endsWith("in")) {
                return false;
            }
        }
        return !precSpace || follSpace || !"'".equals(tokenStr) || i + 1 >= tokens.length || !"em".equals(tokens[i + 1].getToken());
    }
}

