/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.synthesis.en;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import morfologik.stemming.Dictionary;
import morfologik.stemming.DictionaryLookup;
import morfologik.stemming.WordData;
import org.languagetool.AnalyzedToken;
import org.languagetool.JLanguageTool;
import org.languagetool.rules.en.AvsAnRule;
import org.languagetool.synthesis.BaseSynthesizer;

public class EnglishSynthesizer
extends BaseSynthesizer {
    private static final String RESOURCE_FILENAME = "/en/english_synth.dict";
    private static final String TAGS_FILE_NAME = "/en/english_tags.txt";
    private static final String ADD_DETERMINER = "+DT";
    private static final String ADD_IND_DETERMINER = "+INDT";

    public EnglishSynthesizer() {
        super(RESOURCE_FILENAME, TAGS_FILE_NAME);
    }

    public String[] synthesize(AnalyzedToken token, String posTag) throws IOException {
        if (ADD_DETERMINER.equals(posTag)) {
            AvsAnRule rule = new AvsAnRule(null);
            return new String[]{rule.suggestAorAn(token.getToken()), "the " + token.getToken()};
        }
        if (ADD_IND_DETERMINER.equals(posTag)) {
            AvsAnRule rule = new AvsAnRule(null);
            return new String[]{rule.suggestAorAn(token.getToken())};
        }
        if (this.synthesizer == null) {
            URL url = JLanguageTool.getDataBroker().getFromResourceDirAsUrl(RESOURCE_FILENAME);
            this.synthesizer = new DictionaryLookup(Dictionary.read((URL)url));
        }
        List wordData = this.synthesizer.lookup((CharSequence)(token.getLemma() + "|" + posTag));
        ArrayList<String> wordForms = new ArrayList<String>();
        for (WordData wd : wordData) {
            wordForms.add(wd.getStem().toString());
        }
        return wordForms.toArray(new String[wordForms.size()]);
    }
}

