/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.tagging.uk;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import org.languagetool.AnalyzedToken;
import org.languagetool.tagging.BaseTagger;
import org.languagetool.tagging.uk.IPOSTag;

public class UkrainianTagger
extends BaseTagger {
    private static final Pattern NUMBER = Pattern.compile("[+-]?[0-9]+(,[0-9]+)?");

    public final String getFileName() {
        return "/uk/ukrainian.dict";
    }

    public UkrainianTagger() {
        this.setLocale(new Locale("uk", "UA"));
    }

    public List<AnalyzedToken> additionalTags(String word) {
        if (NUMBER.matcher(word).matches()) {
            ArrayList<AnalyzedToken> additionalTaggedTokens = new ArrayList<AnalyzedToken>();
            additionalTaggedTokens.add(new AnalyzedToken(word, IPOSTag.numr.toString(), word));
            return additionalTaggedTokens;
        }
        return null;
    }
}

