/*
 * Decompiled with CFR 0.152.
 */
package net.moraleboost.tinysegmenter;

import java.io.StringReader;
import net.moraleboost.io.BasicCodePointReader;
import net.moraleboost.tinysegmenter.TinySegmenter;
import org.junit.Assert;
import org.junit.Test;

public class TinySegmenterTest {
    @Test
    public void testTokenize() throws Exception {
        TinySegmenter.Token token;
        String str = "\u672c\u65e5\u306f\u6674\u5929\u306a\u308a\u3002";
        StringReader reader = new StringReader(str);
        BasicCodePointReader cpreader = new BasicCodePointReader(reader);
        TinySegmenter segmenter = new TinySegmenter(cpreader);
        String[] terms = new String[]{"\u672c\u65e5", "\u306f", "\u6674\u5929", "\u306a\u308a", "\u3002"};
        int[][] nArrayArray = new int[5][];
        int[] nArray = new int[2];
        nArray[1] = 2;
        nArrayArray[0] = nArray;
        nArrayArray[1] = new int[]{2, 3};
        nArrayArray[2] = new int[]{3, 5};
        nArrayArray[3] = new int[]{5, 7};
        nArrayArray[4] = new int[]{7, 8};
        int[][] offsets = nArrayArray;
        int i = 0;
        while ((token = segmenter.next()) != null) {
            Assert.assertEquals((Object)terms[i], (Object)token.str);
            Assert.assertEquals((long)offsets[i][0], (long)token.start);
            Assert.assertEquals((long)offsets[i][1], (long)token.end);
            ++i;
        }
        Assert.assertEquals((long)terms.length, (long)i);
    }

    @Test
    public void testMinimalBufferSize() throws Exception {
        TinySegmenter.Token token2;
        TinySegmenter.Token token;
        String str = "\u30e1\u30ed\u30b9\u306f\u6fc0\u6012\u3057\u305f\u3002\u5fc5\u305a\u3001\u304b\u306e\u90aa\u667a\u66b4\u8650\u306e\u738b\u3092\u9664\u304b\u306a\u3051\u308c\u3070\u306a\u3089\u306c\u3068\u6c7a\u610f\u3057\u305f\u3002\u30e1\u30ed\u30b9\u306b\u306f\u653f\u6cbb\u304c\u308f\u304b\u3089\u306c\u3002\u30e1\u30ed\u30b9\u306f\u3001\u6751\u306e\u7267\u4eba\u3067\u3042\u308b\u3002\u7b1b\u3092\u5439\u304d\u3001\u7f8a\u3068\u904a\u3093\u3067\u66ae\u3057\u3066\u6765\u305f\u3002\u3051\u308c\u3069\u3082\u90aa\u60aa\u306b\u5bfe\u3057\u3066\u306f\u3001\u4eba\u4e00\u500d\u306b\u654f\u611f\u3067\u3042\u3063\u305f\u3002";
        StringReader reader = new StringReader(str);
        StringReader reader2 = new StringReader(str);
        BasicCodePointReader cpreader = new BasicCodePointReader(reader);
        BasicCodePointReader cpreader2 = new BasicCodePointReader(reader2);
        TinySegmenter segmenter = new TinySegmenter(cpreader, 7, 255);
        TinySegmenter segmenter2 = new TinySegmenter(cpreader2, 1024, 255);
        do {
            token = segmenter.next();
            token2 = segmenter2.next();
            Assert.assertEquals((Object)token2, (Object)token);
        } while (token != null && token2 != null);
        Assert.assertNull((Object)token);
        Assert.assertNull((Object)token2);
    }

    @Test
    public void testEmptyStream() throws Exception {
        String str = "";
        StringReader reader = new StringReader(str);
        BasicCodePointReader cpreader = new BasicCodePointReader(reader);
        TinySegmenter segmenter = new TinySegmenter(cpreader);
        Assert.assertNull((Object)segmenter.next());
    }

    @Test
    public void testMaxTokenSize() throws Exception {
        TinySegmenter.Token token;
        String str = "\u4e00\u65e5\u4f5c\u3055\u3056\u308c\u3070\u3001\u4e00\u65e5\u98df\u308f\u305a\u3002";
        StringReader reader = new StringReader(str);
        BasicCodePointReader cpreader = new BasicCodePointReader(reader);
        TinySegmenter segmenter = new TinySegmenter(cpreader, 1024, 2);
        String[] terms = new String[]{"\u4e00\u65e5", "\u4f5c", "\u3055\u3056", "\u308c", "\u3070", "\u3001", "\u4e00", "\u65e5", "\u98df\u308f", "\u305a", "\u3002"};
        int[][] nArrayArray = new int[11][];
        int[] nArray = new int[2];
        nArray[1] = 2;
        nArrayArray[0] = nArray;
        nArrayArray[1] = new int[]{2, 3};
        nArrayArray[2] = new int[]{3, 5};
        nArrayArray[3] = new int[]{5, 6};
        nArrayArray[4] = new int[]{6, 7};
        nArrayArray[5] = new int[]{7, 8};
        nArrayArray[6] = new int[]{8, 9};
        nArrayArray[7] = new int[]{9, 10};
        nArrayArray[8] = new int[]{10, 12};
        nArrayArray[9] = new int[]{12, 13};
        nArrayArray[10] = new int[]{13, 14};
        int[][] offsets = nArrayArray;
        int i = 0;
        while ((token = segmenter.next()) != null) {
            Assert.assertEquals((Object)terms[i], (Object)token.str);
            Assert.assertEquals((long)offsets[i][0], (long)token.start);
            Assert.assertEquals((long)offsets[i][1], (long)token.end);
            ++i;
        }
        Assert.assertEquals((long)terms.length, (long)i);
    }
}

