/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.universalchardet;

import java.io.IOException;
import java.io.InputStream;
import org.junit.Assert;
import org.junit.Test;
import org.mozilla.universalchardet.UniversalDetector;

public class UniversalDetectorTest {
    @Test
    public void test() throws IOException {
        Assert.assertEquals((Object)"UTF-8", (Object)UniversalDetectorTest.detectEncoding("utf8.txt"));
        Assert.assertEquals((Object)"UTF-8", (Object)UniversalDetectorTest.detectEncoding("utf8n.txt"));
        Assert.assertEquals((Object)"UTF-16LE", (Object)UniversalDetectorTest.detectEncoding("utf16le.txt"));
        Assert.assertEquals((Object)"SHIFT_JIS", (Object)UniversalDetectorTest.detectEncoding("shiftjis.txt"));
        Assert.assertEquals((Object)"ISO-2022-JP", (Object)UniversalDetectorTest.detectEncoding("iso2022jp.txt"));
        Assert.assertEquals((Object)"EUC-JP", (Object)UniversalDetectorTest.detectEncoding("euc.txt"));
        Assert.assertEquals((Object)"BIG5", (Object)UniversalDetectorTest.detectEncoding("big5.txt"));
        Assert.assertEquals((Object)"EUC-TW", (Object)UniversalDetectorTest.detectEncoding("euctw.txt"));
        Assert.assertEquals((Object)"EUC-KR", (Object)UniversalDetectorTest.detectEncoding("euckr.txt"));
        Assert.assertEquals((Object)"GB18030", (Object)UniversalDetectorTest.detectEncoding("gb18030.txt"));
        Assert.assertEquals((Object)"WINDOWS-1255", (Object)UniversalDetectorTest.detectEncoding("windows1255.txt"));
        Assert.assertEquals((Object)"UTF-8", (Object)UniversalDetectorTest.detectEncoding("utf8n-emoji.txt"));
    }

    private static String detectEncoding(String file) throws IOException {
        int nread;
        UniversalDetector detector = new UniversalDetector(null);
        byte[] buf = new byte[4096];
        InputStream is = UniversalDetectorTest.class.getResourceAsStream("/resources/" + file);
        while ((nread = is.read(buf)) > 0 && !detector.isDone()) {
            detector.handleData(buf, 0, nread);
        }
        detector.dataEnd();
        is.close();
        return detector.getDetectedCharset();
    }
}

