/*
 * Decompiled with CFR 0.152.
 */
package org.dict.zip;

import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.util.zip.CRC32;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import org.dict.zip.DictZipHeader;

public class DictZipInputStream
extends InflaterInputStream {
    protected CRC32 crc = new CRC32();
    protected boolean eos;

    public DictZipInputStream(InputStream inputStream) throws IOException {
        this(inputStream, 512);
    }

    public DictZipInputStream(InputStream inputStream, int n) throws IOException {
        super(inputStream, new Inflater(true), n);
    }

    @Override
    public void close() throws IOException {
        this.inf.end();
        this.in.close();
        this.eos = true;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.eos) {
            return -1;
        }
        if ((n2 = super.read(byArray, n, n2)) == -1) {
            this.eos = true;
        } else {
            this.crc.update(byArray, n, n2);
        }
        return n2;
    }

    public final void readFully(byte[] byArray) throws IOException {
        this.readFully(byArray, 0, byArray.length);
    }

    public final void readFully(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        for (int i = 0; i < n2; i += n3) {
            n3 = this.read(byArray, n + i, n2 - i);
            if (n3 >= 0) continue;
            throw new EOFException();
        }
    }

    public DictZipHeader readHeader() throws IOException {
        DictZipHeader dictZipHeader = new DictZipHeader();
        DictZipHeader.readHeader(dictZipHeader, this.in, this.crc);
        this.crc.reset();
        return dictZipHeader;
    }

    private void readTrailer() throws IOException {
        InputStream inputStream = this.in;
        int n = this.inf.getRemaining();
        if (n > 0) {
            inputStream = new SequenceInputStream(new ByteArrayInputStream(this.buf, this.len - n, n), inputStream);
        }
        long l = this.crc.getValue();
        long l2 = this.readUInt(inputStream);
        if (l2 != l) {
            throw new IOException("Incorrect CRC");
        }
        long l3 = this.inf.getTotalOut();
        long l4 = this.readUInt(inputStream);
        if (l4 != l3) {
            throw new IOException("False number of uncompressed bytes");
        }
    }

    private long readUInt(InputStream inputStream) throws IOException {
        return DictZipHeader.readUInt(inputStream);
    }
}

