/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analysis;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Map;
import net.java.sen.filter.stream.CompositeTokenFilter;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.gosen.GosenTokenizer;
import org.apache.lucene.util.IOUtils;
import org.apache.solr.analysis.BaseTokenizerFactory;
import org.apache.solr.common.ResourceLoader;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.solr.util.plugin.ResourceLoaderAware;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GosenTokenizerFactory
extends BaseTokenizerFactory
implements ResourceLoaderAware {
    private CompositeTokenFilter compositeTokenFilter;
    private String dictionaryDir;

    public void init(Map<String, String> args) {
        super.init(args);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void inform(ResourceLoader loader) {
        String dirVal;
        String compositePosFile = (String)this.args.get("compositePOS");
        if (compositePosFile != null) {
            this.compositeTokenFilter = new CompositeTokenFilter();
            InputStreamReader isr = null;
            BufferedReader reader = null;
            try {
                isr = new InputStreamReader(loader.openResource(compositePosFile), "UTF-8");
                reader = new BufferedReader(isr);
                this.compositeTokenFilter.readRules(reader);
            }
            catch (IOException e) {
                try {
                    throw new RuntimeException(e);
                }
                catch (Throwable throwable) {
                    try {
                        IOUtils.close((Closeable[])new Closeable[]{reader, isr});
                        throw throwable;
                    }
                    catch (IOException e2) {
                        throw new RuntimeException(e2);
                    }
                }
            }
            try {
                IOUtils.close((Closeable[])new Closeable[]{reader, isr});
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if ((dirVal = (String)this.args.get("dictionaryDir")) == null) return;
        SolrResourceLoader solrLoader = (SolrResourceLoader)SolrResourceLoader.class.cast(loader);
        File d0 = new File(dirVal);
        File d = d0;
        if (!d.isAbsolute()) {
            d = new File(solrLoader.getConfigDir() + dirVal);
        }
        if (d.isDirectory() && d.canRead()) {
            this.dictionaryDir = d.getAbsolutePath();
            return;
        }
        if (d != d0 && d0.isDirectory() && d0.canRead()) {
            this.dictionaryDir = d0.getAbsolutePath();
            return;
        }
        this.dictionaryDir = dirVal;
    }

    public Tokenizer create(Reader reader) {
        return new GosenTokenizer(reader, this.compositeTokenFilter, this.dictionaryDir);
    }
}

