/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Scanner;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.JLanguageTool;
import org.languagetool.rules.Category;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.tools.StringTools;

public abstract class AbstractSimpleReplaceRule
extends Rule {
    private static final String FILE_ENCODING = "utf-8";
    private final Map<String, String> wrongWords;

    public abstract String getFileName();

    public String getEncoding() {
        return FILE_ENCODING;
    }

    public boolean isCaseSensitive() {
        return true;
    }

    public Locale getLocale() {
        return Locale.getDefault();
    }

    public AbstractSimpleReplaceRule(ResourceBundle messages) throws IOException {
        if (messages != null) {
            super.setCategory(new Category(messages.getString("category_misc")));
        }
        this.wrongWords = this.loadWords(JLanguageTool.getDataBroker().getFromRulesDirAsStream(this.getFileName()));
    }

    @Override
    public String getId() {
        return "SIMPLE_REPLACE";
    }

    @Override
    public String getDescription() {
        return "Checks for wrong words/phrases";
    }

    public String getSuggestion() {
        return " is not valid, use ";
    }

    public String getShort() {
        return "Wrong word";
    }

    @Override
    public final RuleMatch[] match(AnalyzedSentence text) {
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        AnalyzedTokenReadings[] tokens = text.getTokensWithoutWhitespace();
        for (int i = 1; i < tokens.length; ++i) {
            String replacement;
            String token;
            String origToken = token = tokens[i].getToken();
            String string = replacement = this.isCaseSensitive() ? this.wrongWords.get(token) : this.wrongWords.get(token.toLowerCase(this.getLocale()));
            if (replacement == null) continue;
            String msg = token + this.getSuggestion() + replacement;
            int pos = tokens[i].getStartPos();
            RuleMatch potentialRuleMatch = new RuleMatch(this, pos, pos + origToken.length(), msg, this.getShort());
            if (!this.isCaseSensitive() && StringTools.startsWithUppercase(token)) {
                potentialRuleMatch.setSuggestedReplacement(StringTools.uppercaseFirstChar(replacement));
            } else {
                potentialRuleMatch.setSuggestedReplacement(replacement);
            }
            ruleMatches.add(potentialRuleMatch);
        }
        return this.toRuleMatchArray(ruleMatches);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, String> loadWords(InputStream stream) throws IOException {
        HashMap<String, String> map = new HashMap<String, String>();
        Scanner scanner = new Scanner(stream, this.getEncoding());
        try {
            while (scanner.hasNextLine()) {
                String line = scanner.nextLine();
                if (line.length() < 1 || line.charAt(0) == '#') continue;
                String[] parts = line.split("=");
                if (parts.length != 2) {
                    throw new IOException("Format error in file " + JLanguageTool.getDataBroker().getFromRulesDirAsUrl(this.getFileName()) + ", line: " + line);
                }
                map.put(parts[0], parts[1]);
            }
        }
        finally {
            scanner.close();
        }
        return map;
    }

    @Override
    public void reset() {
    }
}

