/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.dictionaries;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.io.IOUtils;
import org.omegat.core.Core;
import org.omegat.core.dictionaries.DictionaryEntry;
import org.omegat.core.dictionaries.IDictionary;
import org.omegat.core.dictionaries.IDictionaryFactory;
import org.omegat.core.dictionaries.LingvoDSL;
import org.omegat.core.dictionaries.StarDict;
import org.omegat.gui.dictionaries.IDictionaries;
import org.omegat.util.DirectoryMonitor;
import org.omegat.util.FileUtil;
import org.omegat.util.Log;

public class DictionariesManager
implements DirectoryMonitor.Callback {
    public static final String IGNORE_FILE = "ignore.txt";
    public static final String DICTIONARY_SUBDIR = "dictionary";
    private final IDictionaries pane;
    protected DirectoryMonitor monitor;
    protected final List<IDictionaryFactory> factories = new ArrayList<IDictionaryFactory>();
    protected final Map<String, IDictionary> dictionaries = new TreeMap<String, IDictionary>();
    protected final Set<String> ignoreWords = new TreeSet<String>();

    public DictionariesManager(IDictionaries pane) {
        this.pane = pane;
        this.factories.add(new LingvoDSL());
        this.factories.add(new StarDict());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDictionaryFactory(IDictionaryFactory dict) {
        List<IDictionaryFactory> list = this.factories;
        synchronized (list) {
            this.factories.add(dict);
        }
        if (this.monitor != null) {
            this.monitor.fin();
            this.start(this.monitor.getDir());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDictionaryFactory(IDictionaryFactory factory) {
        List<IDictionaryFactory> list = this.factories;
        synchronized (list) {
            this.factories.remove(factory);
        }
    }

    public void start(File dictDir) {
        this.monitor = new DirectoryMonitor(dictDir, this);
        this.monitor.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        this.monitor.fin();
        DictionariesManager dictionariesManager = this;
        synchronized (dictionariesManager) {
            this.dictionaries.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fileChanged(File file) {
        Map<String, IDictionary> map = this.dictionaries;
        synchronized (map) {
            this.dictionaries.remove(file.getPath());
        }
        if (!file.exists()) {
            return;
        }
        try {
            long st = System.currentTimeMillis();
            if (file.getName().equals(IGNORE_FILE)) {
                this.loadIgnoreWords(file);
            } else if (this.loadDictionary(file)) {
                long en = System.currentTimeMillis();
                Log.log("Loaded dictionary from '" + file.getPath() + "': " + (en - st) + "ms");
            }
        }
        catch (Exception ex) {
            Log.log("Error load dictionary from '" + file.getPath() + "': " + ex.getMessage());
        }
        this.pane.refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean loadDictionary(File file) throws Exception {
        ArrayList<IDictionaryFactory> currFactories;
        if (!file.isFile()) {
            return false;
        }
        List<IDictionaryFactory> list = this.factories;
        synchronized (list) {
            currFactories = new ArrayList<IDictionaryFactory>(this.factories);
        }
        for (IDictionaryFactory factory : currFactories) {
            if (!factory.isSupportedFile(file)) continue;
            DictionariesManager dictionariesManager = this;
            synchronized (dictionariesManager) {
                this.dictionaries.put(file.getPath(), factory.loadDict(file));
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadIgnoreWords(File f) throws IOException {
        FileInputStream fis = null;
        InputStreamReader isr = null;
        BufferedReader rd = null;
        try {
            fis = new FileInputStream(f);
            isr = new InputStreamReader((InputStream)fis, "UTF-8");
            rd = new BufferedReader(isr);
            Set<String> set = this.ignoreWords;
            synchronized (set) {
                String line;
                this.ignoreWords.clear();
                while ((line = rd.readLine()) != null) {
                    this.ignoreWords.add(line.trim());
                }
            }
            rd.close();
            isr.close();
            fis.close();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(rd);
            IOUtils.closeQuietly(isr);
            IOUtils.closeQuietly(fis);
            throw throwable;
        }
        IOUtils.closeQuietly(rd);
        IOUtils.closeQuietly(isr);
        IOUtils.closeQuietly(fis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addIgnoreWord(String word) {
        List<String> words = Collections.emptyList();
        Set<String> set = this.ignoreWords;
        synchronized (set) {
            this.ignoreWords.add(word);
            words = new ArrayList<String>(this.ignoreWords);
        }
        this.saveIgnoreWords(words);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void saveIgnoreWords(Collection<String> words) {
        if (this.monitor == null) {
            Log.log("Could not save ignore words because no dictionary dir has been set.");
            return;
        }
        File outFile = new File(this.monitor.getDir(), IGNORE_FILE);
        File outFileTmp = new File(this.monitor.getDir(), "ignore.txt.new");
        FileOutputStream fos = null;
        OutputStreamWriter osw = null;
        BufferedWriter wr = null;
        try {
            fos = new FileOutputStream(outFileTmp);
            osw = new OutputStreamWriter((OutputStream)fos, "UTF-8");
            wr = new BufferedWriter(osw);
            for (String w : words) {
                wr.write(w + System.getProperty("line.separator"));
            }
            outFile.delete();
            FileUtil.rename(outFileTmp, outFile);
            wr.close();
            osw.close();
            fos.close();
        }
        catch (Exception ex) {
            try {
                Log.log("Error saving ignore words: " + ex.getMessage());
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(wr);
                IOUtils.closeQuietly(osw);
                IOUtils.closeQuietly(fos);
                throw throwable;
            }
            IOUtils.closeQuietly(wr);
            IOUtils.closeQuietly(osw);
            IOUtils.closeQuietly(fos);
        }
        IOUtils.closeQuietly(wr);
        IOUtils.closeQuietly(osw);
        IOUtils.closeQuietly(fos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isIgnoreWord(String word) {
        Set<String> set = this.ignoreWords;
        synchronized (set) {
            return this.ignoreWords.contains(word);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DictionaryEntry> findWords(Collection<String> words) {
        ArrayList<IDictionary> dicts;
        DictionariesManager dictionariesManager = this;
        synchronized (dictionariesManager) {
            dicts = new ArrayList<IDictionary>(this.dictionaries.values());
        }
        ArrayList<DictionaryEntry> result = new ArrayList<DictionaryEntry>();
        for (String word : words) {
            for (IDictionary di : dicts) {
                if (this.isIgnoreWord(word)) continue;
                try {
                    List<DictionaryEntry> entries = di.readArticles(word);
                    if (entries.isEmpty()) {
                        Locale loc = Core.getProject().getProjectProperties().getSourceLanguage().getLocale();
                        String lowerCaseWord = word.toLowerCase(loc);
                        if (this.isIgnoreWord(lowerCaseWord)) continue;
                        entries = di.readArticles(lowerCaseWord);
                    }
                    result.addAll(entries);
                }
                catch (Exception ex) {
                    Log.log(ex);
                }
            }
        }
        return result;
    }
}

