/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.team;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Properties;

public interface IRemoteRepository {
    public boolean isFilesLockingAllowed();

    public void setCredentials(Credentials var1);

    public void setReadOnly(boolean var1);

    public boolean isChanged(File var1) throws Exception;

    public boolean isUnderVersionControl(File var1) throws Exception;

    public void updateFullProject() throws NetworkException, Exception;

    public void checkoutFullProject(String var1) throws Exception;

    public String getBaseRevisionId(File var1) throws Exception;

    public void restoreBase(File[] var1) throws Exception;

    public void download(File[] var1) throws NetworkException, Exception;

    public void reset() throws Exception;

    public void upload(File var1, String var2) throws NetworkException, Exception;

    public static class Credentials
    implements Cloneable {
        public String username = null;
        public char[] password = null;
        public boolean saveAsPlainText = false;
        public boolean readOnly = false;
        public String fingerprint = null;
        private static final String PKEY_USERNAME = "username";
        private static final String PKEY_PASSWORD = "password";
        private static final String PKEY_FINGERPRINT = "RSAkeyfingerprint";

        public void clear() {
            this.username = null;
            if (this.password != null) {
                Arrays.fill(this.password, '0');
            }
            this.password = null;
            this.fingerprint = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static Credentials fromFile(File file) throws FileNotFoundException, IOException {
            Credentials result = new Credentials();
            if (!file.canRead()) {
                throw new IOException("Insufficient permissions to read file: " + file);
            }
            Properties p = new Properties();
            FileInputStream stream = new FileInputStream(file);
            try {
                p.load(stream);
            }
            finally {
                ((InputStream)stream).close();
            }
            result.username = p.getProperty(PKEY_USERNAME);
            result.password = p.getProperty(PKEY_PASSWORD).toCharArray();
            result.fingerprint = p.getProperty(PKEY_FINGERPRINT);
            result.saveAsPlainText = true;
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void saveToPlainTextFile(File file) throws FileNotFoundException, IOException {
            Properties p = new Properties();
            p.setProperty(PKEY_USERNAME, this.username);
            p.setProperty(PKEY_PASSWORD, String.valueOf(this.password));
            if (this.fingerprint != null) {
                p.setProperty(PKEY_FINGERPRINT, this.fingerprint);
            }
            if (!file.exists()) {
                file.createNewFile();
            }
            FileOutputStream stream = new FileOutputStream(file);
            try {
                p.store(stream, "Remote access credentials for OmegaT project");
            }
            finally {
                ((OutputStream)stream).close();
            }
        }

        public Credentials clone() {
            Credentials clone = new Credentials();
            clone.username = this.username;
            if (this.password != null) {
                clone.password = Arrays.copyOf(this.password, this.password.length);
            }
            clone.fingerprint = this.fingerprint;
            clone.saveAsPlainText = this.saveAsPlainText;
            clone.readOnly = this.readOnly;
            return clone;
        }
    }

    public static class NetworkException
    extends Exception {
        public NetworkException(Throwable ex) {
            super(ex);
        }
    }

    public static class BadRepositoryException
    extends Exception {
        public BadRepositoryException(String message) {
            super(message);
        }
    }

    public static class AuthenticationException
    extends Exception {
        public AuthenticationException(Exception ex) {
            super(ex);
        }
    }
}

