/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.filters3;

import java.util.ArrayList;
import java.util.List;
import org.omegat.core.Core;
import org.omegat.core.data.ProtectedPart;
import org.omegat.filters2.TranslationException;
import org.omegat.filters3.AggregatedTag;
import org.omegat.filters3.Attributes;
import org.omegat.filters3.Element;
import org.omegat.filters3.Tag;
import org.omegat.filters3.Text;
import org.omegat.filters3.xml.Handler;
import org.omegat.filters3.xml.XMLContentBasedTag;
import org.omegat.filters3.xml.XMLDialect;
import org.omegat.filters3.xml.XMLText;
import org.omegat.util.StringUtil;
import org.omegat.util.TagUtil;

public class Entry {
    final XMLDialect xmlDialect;
    final Handler handler;
    private boolean tagsAggregationEnabled = false;
    private boolean tagsDetected = false;
    private int firstGood;
    private int lastGood;
    private Text textInstance = null;
    Entry translatedEntry = null;
    private List<Element> elements = new ArrayList<Element>();

    public Entry(XMLDialect xmlDialect, Handler handler) {
        this.xmlDialect = xmlDialect;
        this.handler = handler;
    }

    public void clear() {
        this.tagsDetected = false;
        this.elements.clear();
        this.translatedEntry = null;
        this.textInstance = null;
    }

    private int getFirstGood() {
        this.detectAndEnumerateTags();
        return this.firstGood;
    }

    private int getLastGood() {
        this.detectAndEnumerateTags();
        return this.lastGood;
    }

    private Text getTextInstance() {
        this.detectAndEnumerateTags();
        return this.textInstance;
    }

    private void detectAndEnumerateTags() {
        if (!this.tagsDetected) {
            if (this.tagsAggregationEnabled) {
                this.aggregateTags();
            }
            this.detectTags();
            this.tagsDetected = true;
            this.enumerateTags(this.getFirstGood(), this.getLastGood());
        }
    }

    public void resetTagDetected() {
        this.tagsDetected = false;
    }

    private void aggregateTags() {
        ArrayList<Element> newElements = new ArrayList<Element>();
        AggregatedTag aggregated = null;
        for (Element elem : this.elements) {
            if (elem instanceof Tag) {
                if (aggregated == null) {
                    aggregated = new AggregatedTag("tag", null, Tag.Type.ALONE, new Attributes());
                }
                aggregated.add((Tag)elem);
                continue;
            }
            if (aggregated != null) {
                newElements.add(aggregated);
                aggregated = null;
            }
            newElements.add(elem);
        }
        if (aggregated != null) {
            newElements.add(aggregated);
            aggregated = null;
        }
        this.elements.clear();
        for (Element elem : newElements) {
            this.elements.add(elem);
        }
        newElements.clear();
    }

    private void detectTags() {
        boolean removeSpacesAround;
        boolean removeTags;
        Tag cand;
        Element candElement;
        int i;
        Tag good;
        Element goodElem;
        Element elem;
        int i2;
        Element elem2;
        int i3;
        int textStart = -1;
        for (i3 = 0; i3 < this.size(); ++i3) {
            elem2 = this.get(i3);
            if (elem2 instanceof Text && ((Text)elem2).isMeaningful()) {
                textStart = i3;
                break;
            }
            if (!(elem2 instanceof XMLContentBasedTag)) continue;
            textStart = i3;
        }
        for (i3 = 0; i3 < this.size(); ++i3) {
            elem2 = this.get(i3);
            if (!(elem2 instanceof Text) || !((Text)elem2).isMeaningful()) continue;
            this.textInstance = (Text)elem2;
            break;
        }
        if (textStart < 0) {
            this.firstGood = -1;
            this.lastGood = -2;
            this.textInstance = null;
            return;
        }
        int textEnd = textStart;
        for (i2 = this.size() - 1; i2 >= 0; --i2) {
            elem = this.get(i2);
            if (!(elem instanceof Text) || !((Text)elem).isMeaningful()) continue;
            textEnd = i2;
            break;
        }
        for (i2 = textStart; i2 <= textEnd; ++i2) {
            String id2;
            XMLContentBasedTag tag2;
            int j;
            String id;
            XMLContentBasedTag tag;
            elem = this.get(i2);
            if (!(elem instanceof XMLContentBasedTag) || !(tag = (XMLContentBasedTag)elem).getTag().equals("bpt") && !tag.getTag().equals("ept") || (id = StringUtil.nvl(tag.getAttribute("rid"), tag.getAttribute("id"), tag.getAttribute("i"))) == null) continue;
            for (j = textStart - 1; j >= 0; --j) {
                if (!(this.get(j) instanceof XMLContentBasedTag) || !(tag2 = (XMLContentBasedTag)this.get(j)).getTag().equals("bpt") && !tag2.getTag().equals("ept") || !id.equals(id2 = StringUtil.nvl(tag2.getAttribute("rid"), tag2.getAttribute("id"), tag2.getAttribute("i")))) continue;
                textStart = j;
            }
            for (j = textEnd + 1; j < this.size(); ++j) {
                if (!(this.get(j) instanceof XMLContentBasedTag) || !(tag2 = (XMLContentBasedTag)this.get(j)).getTag().equals("bpt") && !tag2.getTag().equals("ept") || !id.equals(id2 = StringUtil.nvl(tag2.getAttribute("rid"), tag2.getAttribute("id"), tag2.getAttribute("i")))) continue;
                textEnd = j;
            }
        }
        boolean found = false;
        this.firstGood = 0;
        while (this.firstGood < textStart) {
            goodElem = this.get(this.firstGood);
            if (goodElem instanceof Tag && Tag.Type.BEGIN == (good = (Tag)goodElem).getType()) {
                int recursion = 1;
                for (i = this.firstGood + 1; i < textEnd; ++i) {
                    candElement = this.get(i);
                    if (!(candElement instanceof Tag) || !(cand = (Tag)candElement).getTag().equals(good.getTag())) continue;
                    if (Tag.Type.BEGIN == cand.getType()) {
                        ++recursion;
                        continue;
                    }
                    if (Tag.Type.END != cand.getType() || --recursion != 0) continue;
                    if (i <= textStart) break;
                    found = true;
                    break;
                }
                if (found) break;
            }
            ++this.firstGood;
        }
        if (!found) {
            this.firstGood = textStart;
        }
        found = false;
        this.lastGood = this.size() - 1;
        while (this.lastGood > textEnd) {
            goodElem = this.get(this.lastGood);
            if (goodElem instanceof Tag && Tag.Type.END == (good = (Tag)goodElem).getType()) {
                int recursion = 1;
                for (i = this.lastGood - 1; i > textStart; --i) {
                    candElement = this.get(i);
                    if (!(candElement instanceof Tag) || !(cand = (Tag)candElement).getTag().equals(good.getTag())) continue;
                    if (Tag.Type.END == cand.getType()) {
                        ++recursion;
                        continue;
                    }
                    if (Tag.Type.BEGIN != cand.getType() || --recursion != 0) continue;
                    if (i >= textEnd) break;
                    found = true;
                    break;
                }
                if (found) break;
            }
            --this.lastGood;
        }
        if (!found) {
            this.lastGood = textEnd;
        }
        if (!(removeTags = this.handler.getContext().isRemoveAllTags() ? true : Core.getFilterMaster().getConfig().isRemoveTags())) {
            int i4;
            for (i4 = this.firstGood - 1; i4 >= 0; --i4) {
                Element elem3 = this.get(i4);
                if (!(elem3 instanceof Tag)) continue;
                if (this.handler.isParagraphTag((Tag)elem3)) break;
                this.firstGood = i4;
            }
            for (i4 = this.lastGood + 1; i4 < this.size(); ++i4) {
                Element elem4 = this.get(i4);
                if (!(elem4 instanceof Tag)) continue;
                if (this.handler.isParagraphTag((Tag)elem4)) break;
                this.lastGood = i4;
            }
        }
        if (!(removeSpacesAround = Core.getFilterMaster().getConfig().isRemoveSpacesNonseg())) {
            Element elem5;
            Element elem6;
            int i5;
            for (i5 = this.firstGood - 1; !(i5 < 0 || (elem6 = this.get(i5)) instanceof Tag && this.handler.isParagraphTag((Tag)elem6)); --i5) {
                if (!(elem6 instanceof Text) || ((Text)elem6).isMeaningful()) continue;
                this.firstGood = i5;
            }
            for (i5 = this.lastGood + 1; !(i5 >= this.size() || (elem5 = this.get(i5)) instanceof Tag && this.handler.isParagraphTag((Tag)elem5)); ++i5) {
                if (!(elem5 instanceof Text) || ((Text)elem5).isMeaningful()) continue;
                this.lastGood = i5;
            }
        }
    }

    private void enumerateTags(int firstGood, int lastGood) {
        int n = 0;
        for (int i = firstGood; i <= lastGood; ++i) {
            Element elem = this.get(i);
            if (!(elem instanceof Tag)) continue;
            Tag tag = (Tag)elem;
            if (Tag.Type.ALONE == tag.getType() || Tag.Type.BEGIN == tag.getType()) {
                tag.setIndex(n);
                ++n;
                continue;
            }
            if (Tag.Type.END != tag.getType()) continue;
            tag.setIndex(-1);
            int recursion = 1;
            for (int j = i - 1; j >= firstGood; --j) {
                Tag other;
                Element otherElem = this.get(j);
                if (!(otherElem instanceof Tag) || !(other = (Tag)otherElem).getTag().equals(tag.getTag())) continue;
                if (Tag.Type.END == other.getType()) {
                    ++recursion;
                    continue;
                }
                if (Tag.Type.BEGIN != other.getType() || --recursion != 0) continue;
                tag.setIndex(other.getIndex());
                break;
            }
            if (tag.getIndex() >= 0) continue;
            tag.setIndex(n);
            ++n;
        }
    }

    public String sourceToShortcut(boolean tagsAggregation, XMLDialect xmlDialect, List<ProtectedPart> protectedParts) {
        if (tagsAggregation != this.tagsAggregationEnabled) {
            this.tagsAggregationEnabled = tagsAggregation;
            this.tagsDetected = false;
        }
        if (this.getFirstGood() <= this.getLastGood()) {
            return xmlDialect.constructShortcuts(this.elements.subList(this.getFirstGood(), this.getLastGood() + 1), protectedParts);
        }
        return "";
    }

    private String sourceToShortcut(XMLDialect xmlDialect, List<ProtectedPart> protectedParts) {
        return this.sourceToShortcut(this.tagsAggregationEnabled, xmlDialect, protectedParts);
    }

    public String sourceToTMX() {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < this.size(); ++i) {
            buf.append(this.get(i).toTMX());
        }
        return buf.toString();
    }

    public String sourceToOriginal() {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < this.size(); ++i) {
            buf.append(this.get(i).toOriginal());
        }
        return buf.toString();
    }

    public void setTranslation(String translation, XMLDialect xmlDialect, List<ProtectedPart> protectedParts) throws TranslationException {
        if (!this.sourceToShortcut(xmlDialect, protectedParts).equals(translation)) {
            this.checkAndRecoverTags(translation, protectedParts);
        }
    }

    private void checkAndRecoverTags(String translation, List<ProtectedPart> protectedParts) throws TranslationException {
        this.translatedEntry = new Entry(this.xmlDialect, this.handler);
        List<TagUtil.Tag> shortTags = TagUtil.buildTagList(translation, protectedParts.toArray(new ProtectedPart[protectedParts.size()]));
        int pos = 0;
        block0: for (TagUtil.Tag shortTag : shortTags) {
            if (pos < shortTag.pos) {
                this.translatedEntry.add(this.createTextInstance(translation.substring(pos, shortTag.pos)));
                pos = shortTag.pos;
            }
            for (int j = this.getFirstGood(); j <= this.getLastGood(); ++j) {
                Tag longTag;
                Element longElem = this.get(j);
                if (!(longElem instanceof Tag) || !(longTag = (Tag)longElem).toShortcut().equals(shortTag.tag)) continue;
                this.translatedEntry.add(longTag);
                pos += shortTag.tag.length();
                continue block0;
            }
        }
        if (pos < translation.length()) {
            this.translatedEntry.add(this.createTextInstance(translation.substring(pos)));
        }
    }

    private Text createTextInstance(String str) {
        Text text = this.getTextInstance();
        if (text != null) {
            return text.createInstance(str);
        }
        return new XMLText(str, false);
    }

    public String translationToTMX() {
        int i;
        if (this.translatedEntry == null) {
            return this.sourceToTMX();
        }
        StringBuilder buf = new StringBuilder();
        for (i = 0; i < this.getFirstGood(); ++i) {
            buf.append(this.get(i).toTMX());
        }
        buf.append(this.translatedEntry.sourceToTMX());
        for (i = this.getLastGood() + 1; i < this.size(); ++i) {
            buf.append(this.get(i).toTMX());
        }
        return buf.toString();
    }

    public String translationToOriginal() {
        int i;
        if (this.translatedEntry == null) {
            return this.sourceToOriginal();
        }
        StringBuilder buf = new StringBuilder();
        for (i = 0; i < this.getFirstGood(); ++i) {
            buf.append(this.get(i).toOriginal());
        }
        buf.append(this.translatedEntry.sourceToOriginal());
        for (i = this.getLastGood() + 1; i < this.size(); ++i) {
            buf.append(this.get(i).toOriginal());
        }
        return buf.toString();
    }

    public void add(Element elem) {
        this.elements.add(elem);
        this.tagsDetected = false;
    }

    public void remove(int index) {
        this.elements.remove(index);
        this.tagsDetected = false;
    }

    public Element get(int i) {
        return this.elements.get(i);
    }

    public int size() {
        return this.elements.size();
    }

    public boolean isEmpty() {
        return this.elements.isEmpty();
    }

    static class ShortTag {
        String tag;
        int pos;

        ShortTag(String tag, int pos) {
            this.tag = tag;
            this.pos = pos;
        }
    }
}

