/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.filters3.xml.docbook;

import java.io.BufferedReader;
import java.util.regex.Matcher;
import org.omegat.filters2.Instance;
import org.omegat.filters3.xml.XMLDialect;
import org.omegat.filters3.xml.XMLFilter;
import org.omegat.filters3.xml.docbook.DocBookDialect;
import org.omegat.util.OStrings;

public class DocBookFilter
extends XMLFilter {
    public DocBookFilter() {
        super(new DocBookDialect());
    }

    @Override
    public String getFileFormatName() {
        return OStrings.getString("DocBook_FILTER_NAME");
    }

    @Override
    public String getHint() {
        return OStrings.getString("DocBook_HINT");
    }

    @Override
    public Instance[] getDefaultInstances() {
        return new Instance[]{new Instance("*.xml", null, null), new Instance("*.dbk", null, null)};
    }

    @Override
    public boolean isSourceEncodingVariable() {
        return false;
    }

    @Override
    public boolean isTargetEncodingVariable() {
        return true;
    }

    @Override
    protected boolean requirePrevNextFields() {
        return true;
    }

    @Override
    public boolean isFileSupported(BufferedReader reader) {
        XMLDialect dialect = this.getDialect();
        if (dialect.getConstraints() == null || dialect.getConstraints().isEmpty()) {
            return true;
        }
        try {
            char[] cbuf = new char[65536];
            int cbuf_len = reader.read(cbuf);
            String buf = new String(cbuf, 0, cbuf_len);
            Matcher matcher = DocBookDialect.DOCBOOK_PUBLIC_DTD.matcher(buf);
            if (matcher.find()) {
                return true;
            }
            matcher = DocBookDialect.DB5_XMLNS.matcher(buf);
            if (!matcher.find()) {
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }
}

