/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.common;

import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import javax.swing.JTextPane;
import org.omegat.core.Core;
import org.omegat.core.CoreEvents;
import org.omegat.core.events.IFontChangedEventListener;
import org.omegat.core.events.IProjectEventListener;
import org.omegat.util.gui.FontFallbackListener;
import org.omegat.util.gui.StaticUIUtils;
import org.omegat.util.gui.Styles;
import org.omegat.util.gui.UIThreadsUtil;

public abstract class EntryInfoPane<T>
extends JTextPane
implements IProjectEventListener {
    public EntryInfoPane(boolean useApplicationFont) {
        if (useApplicationFont) {
            this.setFont(Core.getMainWindow().getApplicationFont());
            CoreEvents.registerFontChangedEventListener(new IFontChangedEventListener(){

                @Override
                public void onFontChanged(Font newFont) {
                    EntryInfoPane.this.setFont(newFont);
                }
            });
        }
        CoreEvents.registerProjectChangeListener(this);
        if (!GraphicsEnvironment.isHeadless()) {
            this.setDragEnabled(true);
        }
        this.getDocument().addDocumentListener(new FontFallbackListener(this));
        this.setForeground(Styles.EditorColor.COLOR_FOREGROUND.getColor());
        this.setBackground(Styles.EditorColor.COLOR_BACKGROUND.getColor());
    }

    @Override
    public void setEditable(boolean isEditable) {
        StaticUIUtils.setCaretUpdateEnabled(this, isEditable);
        super.setEditable(isEditable);
    }

    @Override
    public void onProjectChanged(IProjectEventListener.PROJECT_CHANGE_TYPE eventType) {
        switch (eventType) {
            case CREATE: 
            case LOAD: {
                this.onProjectOpen();
                break;
            }
            case CLOSE: {
                this.onProjectClose();
                break;
            }
        }
    }

    public void clear() {
        UIThreadsUtil.mustBeSwingThread();
        this.setText(null);
        this.scrollRectToVisible(new Rectangle());
    }

    protected void onProjectOpen() {
    }

    protected void onProjectClose() {
    }
}

