/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.dialogs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.DefaultTableModel;
import org.omegat.gui.editor.chartable.CharTableModel;
import org.omegat.util.OStrings;
import org.omegat.util.Preferences;
import org.omegat.util.gui.DockingUI;
import org.omegat.util.gui.StaticUIUtils;
import org.openide.awt.Mnemonics;

public class CharTableAutoCompleterOptionsDialog
extends JDialog {
    CharTableModel allCharModel = new CharTableModel(null);
    CharTableModel selCharModel = new CharTableModel("");
    StringBuilder builder = new StringBuilder();
    private JLabel allCharLabel;
    private JTable allCharTable;
    private JButton cancelButton;
    private JButton clearButton;
    private JPanel customPanel;
    private JTextArea descriptionTextArea;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JPanel jPanel7;
    private JPanel jPanel8;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JButton okButton;
    private JLabel selCharLabel;
    private JTable selCharTable;
    private JCheckBox selectedCharsCheckBox;
    private JCheckBox uniqueCheckBox;

    public CharTableAutoCompleterOptionsDialog(Frame parent) {
        super(parent, true);
        this.initComponents();
        StaticUIUtils.setEscapeClosable(this);
        this.getRootPane().setDefaultButton(this.okButton);
        this.allCharTable.setModel(this.allCharModel);
        this.selCharTable.setModel(this.selCharModel);
        this.selectedCharsCheckBox.setSelected(Preferences.isPreference("ac_chartable_use_custom_chars"));
        this.uniqueCheckBox.setSelected(Preferences.isPreference("ac_chartable_unique_custom_chars"));
        this.selCharModel.setData(Preferences.getPreference("ac_chartable_custom_char_string"));
        this.panelSetEnabled(this.selectedCharsCheckBox.isSelected());
        this.setPreferredSize(new Dimension(400, 500));
        this.pack();
        DockingUI.displayCentered(this);
    }

    private void panelSetEnabled(boolean enabled) {
        this.customPanel.setEnabled(enabled);
        this.descriptionTextArea.setEnabled(enabled);
        this.allCharLabel.setEnabled(enabled);
        this.allCharTable.setEnabled(enabled);
        if (!enabled) {
            this.allCharTable.clearSelection();
        }
        this.selCharLabel.setEnabled(enabled);
        this.selCharTable.setEnabled(enabled);
        this.uniqueCheckBox.setEnabled(enabled);
    }

    private void initComponents() {
        this.jPanel3 = new JPanel();
        this.selectedCharsCheckBox = new JCheckBox();
        this.customPanel = new JPanel();
        this.jPanel8 = new JPanel();
        this.descriptionTextArea = new JTextArea();
        this.jPanel7 = new JPanel();
        this.jPanel6 = new JPanel();
        this.allCharLabel = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.allCharTable = new JTable();
        this.jPanel5 = new JPanel();
        this.selCharLabel = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.selCharTable = new JTable();
        this.jPanel4 = new JPanel();
        this.clearButton = new JButton();
        this.uniqueCheckBox = new JCheckBox();
        this.jPanel1 = new JPanel();
        this.jPanel2 = new JPanel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle(OStrings.getString("AC_CHARTABLE_DIALOG_TITLE"));
        this.jPanel3.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.jPanel3.setLayout(new BorderLayout());
        this.selectedCharsCheckBox.setText(OStrings.getString("AC_CHARTABLE_CUSTOM"));
        this.selectedCharsCheckBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                CharTableAutoCompleterOptionsDialog.this.selectedCharsCheckBoxStateChanged(evt);
            }
        });
        this.jPanel3.add((Component)this.selectedCharsCheckBox, "North");
        this.customPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0), BorderFactory.createEtchedBorder()));
        this.customPanel.setLayout(new BorderLayout());
        this.jPanel8.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.jPanel8.setLayout(new BorderLayout());
        this.descriptionTextArea.setEditable(false);
        this.descriptionTextArea.setFont(this.getFont());
        this.descriptionTextArea.setLineWrap(true);
        this.descriptionTextArea.setText(OStrings.getString("AC_CHARTABLE_EXPLANATION"));
        this.descriptionTextArea.setWrapStyleWord(true);
        this.descriptionTextArea.setOpaque(false);
        this.jPanel8.add((Component)this.descriptionTextArea, "North");
        this.customPanel.add((Component)this.jPanel8, "North");
        this.jPanel7.setLayout(new BoxLayout(this.jPanel7, 1));
        this.jPanel6.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.jPanel6.setLayout(new BorderLayout());
        this.allCharLabel.setText(OStrings.getString("AC_CHARTABLE_ALL_LABEL"));
        this.jPanel6.add((Component)this.allCharLabel, "North");
        this.allCharTable.setModel(new DefaultTableModel(new Object[0][], new String[0]));
        this.allCharTable.setCellSelectionEnabled(true);
        this.allCharTable.setFillsViewportHeight(true);
        this.allCharTable.setSelectionMode(0);
        this.allCharTable.setTableHeader(null);
        this.allCharTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                CharTableAutoCompleterOptionsDialog.this.allCharTableMouseClicked(evt);
            }
        });
        this.allCharTable.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                CharTableAutoCompleterOptionsDialog.this.allCharTableKeyReleased(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.allCharTable);
        this.jPanel6.add((Component)this.jScrollPane1, "Center");
        this.jPanel7.add(this.jPanel6);
        this.jPanel5.setBorder(BorderFactory.createEmptyBorder(0, 5, 5, 5));
        this.jPanel5.setLayout(new BorderLayout());
        this.selCharLabel.setText(OStrings.getString("AC_CHARTABLE_CUSTOM_LABEL"));
        this.jPanel5.add((Component)this.selCharLabel, "North");
        this.selCharTable.setModel(new DefaultTableModel(new Object[0][], new String[0]));
        this.selCharTable.setCellSelectionEnabled(true);
        this.selCharTable.setFillsViewportHeight(true);
        this.selCharTable.setTableHeader(null);
        this.selCharTable.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                CharTableAutoCompleterOptionsDialog.this.selCharTableKeyReleased(evt);
            }
        });
        this.jScrollPane2.setViewportView(this.selCharTable);
        this.jPanel5.add((Component)this.jScrollPane2, "Center");
        this.jPanel7.add(this.jPanel5);
        this.customPanel.add((Component)this.jPanel7, "Center");
        this.jPanel4.setBorder(BorderFactory.createEmptyBorder(0, 5, 5, 5));
        this.jPanel4.setLayout(new BorderLayout());
        this.clearButton.setText(OStrings.getString("AC_CHARTABLE_CLEAR_BUTTON"));
        this.clearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CharTableAutoCompleterOptionsDialog.this.clearButtonActionPerformed(evt);
            }
        });
        this.jPanel4.add((Component)this.clearButton, "East");
        this.uniqueCheckBox.setText(OStrings.getString("AC_CHARTABLE_CUSTOM_UNIQUE"));
        this.uniqueCheckBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                CharTableAutoCompleterOptionsDialog.this.uniqueCheckBoxStateChanged(evt);
            }
        });
        this.jPanel4.add((Component)this.uniqueCheckBox, "West");
        this.customPanel.add((Component)this.jPanel4, "South");
        this.jPanel3.add((Component)this.customPanel, "Center");
        this.getContentPane().add((Component)this.jPanel3, "Center");
        this.jPanel1.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10));
        this.jPanel1.setLayout(new BorderLayout());
        this.jPanel2.setLayout(new BoxLayout(this.jPanel2, 2));
        Mnemonics.setLocalizedText(this.okButton, OStrings.getString("BUTTON_OK"));
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CharTableAutoCompleterOptionsDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.okButton);
        Mnemonics.setLocalizedText(this.cancelButton, OStrings.getString("BUTTON_CANCEL"));
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CharTableAutoCompleterOptionsDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.cancelButton);
        this.jPanel1.add((Component)this.jPanel2, "East");
        this.getContentPane().add((Component)this.jPanel1, "South");
    }

    private void allCharTableKeyReleased(KeyEvent evt) {
        if (evt.getKeyCode() == 155) {
            int col = this.allCharTable.getSelectedColumn();
            int row = this.allCharTable.getSelectedRow();
            this.selCharModel.appendChar((Character)this.allCharModel.getValueAt(row, col), this.uniqueCheckBox.isSelected());
        }
    }

    private void selCharTableKeyReleased(KeyEvent evt) {
        if (evt.getKeyCode() == 127 || evt.getKeyCode() == 8) {
            if (this.selCharTable.getSelectedColumnCount() < 1) {
                return;
            }
            int row1 = this.selCharTable.getSelectedRow();
            int col1 = this.selCharTable.getSelectedColumn();
            int row2 = this.selCharTable.getSelectedRowCount() + row1 - 1;
            int col2 = this.selCharTable.getSelectedColumnCount() + col1 - 1;
            this.selCharModel.removeSelection(row1, col1, row2, col2);
        }
    }

    private void uniqueCheckBoxStateChanged(ChangeEvent evt) {
        if (this.uniqueCheckBox.isSelected()) {
            this.selCharModel.allowOnlyUnique();
        }
    }

    private void selectedCharsCheckBoxStateChanged(ChangeEvent evt) {
        this.panelSetEnabled(this.selectedCharsCheckBox.isSelected());
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        Preferences.setPreference("ac_chartable_use_custom_chars", this.selectedCharsCheckBox.isSelected());
        String customCharString = this.selCharModel.getData();
        Preferences.setPreference("ac_chartable_custom_char_string", customCharString);
        if (customCharString.isEmpty()) {
            Preferences.setPreference("ac_chartable_use_custom_chars", false);
        }
        Preferences.setPreference("ac_chartable_unique_custom_chars", this.uniqueCheckBox.isSelected());
        this.doClose();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.doClose();
    }

    private void allCharTableMouseClicked(MouseEvent evt) {
        if (this.allCharTable.isEnabled() && evt.getClickCount() == 2) {
            JTable target = (JTable)evt.getSource();
            int row = target.getSelectedRow();
            int col = target.getSelectedColumn();
            this.selCharModel.appendChar((Character)this.allCharModel.getValueAt(row, col), this.uniqueCheckBox.isSelected());
        }
    }

    private void clearButtonActionPerformed(ActionEvent evt) {
        this.selCharModel.setData("");
    }

    private void doClose() {
        this.setVisible(false);
        this.dispose();
    }
}

