/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.editor.filter;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.omegat.core.Core;
import org.omegat.core.data.PrepareTMXEntry;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.core.data.TMXEntry;
import org.omegat.core.search.SearchMatch;
import org.omegat.core.search.Searcher;
import org.omegat.gui.editor.EditorController;
import org.omegat.gui.editor.IEditor;
import org.omegat.gui.editor.IEditorFilter;
import org.omegat.gui.editor.filter.FilterBarReplace;

public class ReplaceFilter
implements IEditorFilter {
    private final Map<Integer, SourceTextEntry> entries = new HashMap<Integer, SourceTextEntry>();
    private FilterBarReplace controlComponent;
    private Searcher searcher;
    private String replacement;
    private int minEntryNum;
    private int maxEntryNum;

    public ReplaceFilter(List<Integer> entriesList, Searcher searcher, String replacement) {
        this.searcher = searcher;
        this.replacement = replacement;
        this.minEntryNum = Integer.MAX_VALUE;
        this.maxEntryNum = Integer.MIN_VALUE;
        HashSet<Integer> display = new HashSet<Integer>(entriesList);
        for (SourceTextEntry ste : Core.getProject().getAllEntries()) {
            this.minEntryNum = Math.min(this.minEntryNum, ste.entryNum());
            this.maxEntryNum = Math.max(this.maxEntryNum, ste.entryNum());
            if (!display.contains(ste.entryNum())) continue;
            this.entries.put(ste.entryNum(), ste);
        }
        this.controlComponent = new FilterBarReplace();
        this.controlComponent.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Core.getEditor().commitAndDeactivate();
                Core.getEditor().removeFilter();
            }
        });
        this.controlComponent.btnSkip.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReplaceFilter.this.skip();
            }
        });
        this.controlComponent.btnReplaceNext.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReplaceFilter.this.replace();
            }
        });
    }

    @Override
    public boolean isSourceAsEmptyTranslation() {
        return true;
    }

    public void replaceAll() {
        for (SourceTextEntry ste : this.entries.values()) {
            List<SearchMatch> found;
            TMXEntry en;
            String trans = this.getEntryText(ste, en = Core.getProject().getTranslationInfo(ste));
            if (trans == null || (found = this.getReplacementsForEntry(trans)) == null) continue;
            int off = 0;
            StringBuilder o = new StringBuilder(trans);
            for (SearchMatch m : found) {
                o.replace(m.getStart() + off, m.getEnd() + off, this.replacement);
                off += this.replacement.length() - m.getLength();
            }
            PrepareTMXEntry prepare = new PrepareTMXEntry(en);
            prepare.translation = o.toString();
            Core.getProject().setTranslation(ste, prepare, en.defaultTranslation, null);
        }
        EditorController ec = (EditorController)Core.getEditor();
        ec.refreshEntries(this.entries.keySet());
    }

    @Override
    public boolean allowed(SourceTextEntry ste) {
        return this.entries.containsKey(ste.entryNum());
    }

    @Override
    public Component getControlComponent() {
        return this.controlComponent;
    }

    public List<SearchMatch> getReplacementsForEntry(String translationText) {
        if (this.searcher.searchString(translationText)) {
            return this.searcher.getFoundMatches();
        }
        return null;
    }

    private void skip() {
        Iterator<SearchMatch> iterator;
        TMXEntry en;
        String trans;
        SourceTextEntry ste;
        int i;
        EditorController ec = (EditorController)Core.getEditor();
        int pos = ec.getCurrentPositionInEntryTranslation();
        String str = ec.getCurrentTranslation();
        List<SearchMatch> found = this.getReplacementsForEntry(str);
        if (found != null) {
            for (SearchMatch m : found) {
                if (m.getStart() <= pos) continue;
                ec.setCaretPosition(new IEditor.CaretPosition(m.getStart(), m.getEnd()));
                ec.requestFocus();
                return;
            }
        }
        int currentEntryNumber = ec.getCurrentEntryNumber();
        ec.commitAndDeactivate();
        for (i = currentEntryNumber + 1; i <= this.maxEntryNum; ++i) {
            ste = this.entries.get(i);
            if (ste == null || (trans = this.getEntryText(ste, en = Core.getProject().getTranslationInfo(ste))) == null || (found = this.getReplacementsForEntry(trans)) == null || !(iterator = found.iterator()).hasNext()) continue;
            SearchMatch m = iterator.next();
            ec.gotoEntry(i, new IEditor.CaretPosition(m.getStart(), m.getEnd()));
            ec.requestFocus();
            return;
        }
        for (i = this.minEntryNum; i < currentEntryNumber; ++i) {
            ste = this.entries.get(i);
            if (ste == null || (trans = this.getEntryText(ste, en = Core.getProject().getTranslationInfo(ste))) == null || (found = this.getReplacementsForEntry(trans)) == null || !(iterator = found.iterator()).hasNext()) continue;
            SearchMatch m = iterator.next();
            ec.gotoEntry(i, new IEditor.CaretPosition(m.getStart(), m.getEnd()));
            ec.requestFocus();
            return;
        }
        ec.activateEntry();
    }

    private void replace() {
        EditorController ec = (EditorController)Core.getEditor();
        int pos = ec.getCurrentPositionInEntryTranslation();
        String str = ec.getCurrentTranslation();
        List<SearchMatch> found = this.getReplacementsForEntry(str);
        if (found != null) {
            for (SearchMatch m : this.getReplacementsForEntry(str)) {
                if (m.getStart() > pos || pos > m.getEnd()) continue;
                ec.replacePartOfText(this.replacement, m.getStart(), m.getEnd());
                break;
            }
        }
        this.skip();
    }

    private String getEntryText(SourceTextEntry ste, TMXEntry en) {
        if (en.isTranslated()) {
            return en.translation;
        }
        if (this.searcher.getExpression().replaceUntranslated) {
            return ste.getSrcText();
        }
        return null;
    }
}

