/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.glossary;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import org.omegat.core.Core;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.gui.common.EntryInfoSearchThread;
import org.omegat.gui.glossary.GlossaryEntry;
import org.omegat.gui.glossary.GlossaryManager;
import org.omegat.gui.glossary.GlossaryTextArea;
import org.omegat.tokenizer.DefaultTokenizer;
import org.omegat.tokenizer.ITokenizer;
import org.omegat.util.Preferences;
import org.omegat.util.StringUtil;
import org.omegat.util.Token;

public class FindGlossaryThread
extends EntryInfoSearchThread<List<GlossaryEntry>> {
    private final String src;
    private final GlossaryManager manager;

    public FindGlossaryThread(GlossaryTextArea pane, SourceTextEntry newEntry, GlossaryManager manager) {
        super(pane, newEntry);
        this.src = newEntry.getSrcText();
        this.manager = manager;
    }

    @Override
    protected List<GlossaryEntry> search() {
        ITokenizer tok = Core.getProject().getSourceTokenizer();
        if (tok == null) {
            return Collections.emptyList();
        }
        List<GlossaryEntry> entries = this.manager.getGlossaryEntries(this.src);
        if (entries == null) {
            return Collections.emptyList();
        }
        ArrayList<GlossaryEntry> result = new ArrayList<GlossaryEntry>();
        Locale loc = Core.getProject().getProjectProperties().getSourceLanguage().getLocale();
        String srcLower = this.src.toLowerCase(loc);
        Token[] strTokens = this.tokenize(tok, srcLower);
        for (GlossaryEntry glosEntry : entries) {
            this.checkEntryChanged();
            String glosStr = glosEntry.getSrcText().toLowerCase(loc);
            Token[] glosTokens = this.tokenize(tok, glosStr);
            if (glosTokens.length == 0) continue;
            if (DefaultTokenizer.isContainsAll(strTokens, glosTokens, Preferences.isPreferenceDefault("glossary_not_exact_match", true))) {
                result.add(glosEntry);
                continue;
            }
            if (Core.getProject().getProjectProperties().getSourceLanguage().isSpaceDelimited() || !StringUtil.isCJK(glosEntry.getSrcText()) || !this.src.contains(glosEntry.getSrcText())) continue;
            result.add(glosEntry);
        }
        FindGlossaryThread.sortGlossaryEntries(result);
        return FindGlossaryThread.filterGlossary(result);
    }

    private Token[] tokenize(ITokenizer tok, String str) {
        if (Preferences.isPreferenceDefault("glossary_stemming", true)) {
            return tok.tokenizeWords(str, ITokenizer.StemmingMode.GLOSSARY);
        }
        return tok.tokenizeVerbatim(str);
    }

    static void sortGlossaryEntries(List<GlossaryEntry> entries) {
        Collections.sort(entries, new Comparator<GlossaryEntry>(){

            @Override
            public int compare(GlossaryEntry o1, GlossaryEntry o2) {
                int p2;
                int p1 = o1.getPriority() ? 1 : 2;
                int c = p1 - (p2 = o2.getPriority() ? 1 : 2);
                if (c == 0) {
                    c = o2.getSrcText().length() - o1.getSrcText().length();
                }
                if (c == 0) {
                    c = o1.getSrcText().compareToIgnoreCase(o2.getSrcText());
                }
                if (c == 0) {
                    c = o1.getSrcText().compareTo(o2.getSrcText());
                }
                if (c == 0) {
                    c = o1.getLocText().compareToIgnoreCase(o2.getLocText());
                }
                return c;
            }
        });
    }

    static List<GlossaryEntry> filterGlossary(List<GlossaryEntry> result) {
        int i;
        if (result.isEmpty()) {
            return result;
        }
        LinkedList<GlossaryEntry> returnList = new LinkedList<GlossaryEntry>();
        GlossaryEntry replaceEntry = new GlossaryEntry("", "", "", false);
        boolean removedDuplicate = false;
        for (i = 0; i < result.size(); ++i) {
            GlossaryEntry nowEntry = result.get(i);
            if (nowEntry.getSrcText().equals("")) continue;
            for (int j = i + 1; j < result.size(); ++j) {
                GlossaryEntry thenEntry = result.get(j);
                if (thenEntry.getSrcText().equals("") || !nowEntry.getSrcText().equals(thenEntry.getSrcText()) || !nowEntry.getLocText().equals(thenEntry.getLocText()) || !nowEntry.getCommentText().equals(thenEntry.getCommentText())) continue;
                result.set(j, replaceEntry);
                removedDuplicate = true;
            }
        }
        if (removedDuplicate) {
            Iterator<GlossaryEntry> myIter = result.iterator();
            LinkedList<GlossaryEntry> newList = new LinkedList<GlossaryEntry>();
            while (myIter.hasNext()) {
                GlossaryEntry checkEntry = myIter.next();
                if (checkEntry.getSrcText().equals("") || checkEntry.getLocText().equals("")) {
                    myIter.remove();
                    continue;
                }
                newList.add(checkEntry);
            }
            result = newList;
        }
        for (i = 0; i < result.size(); ++i) {
            LinkedList<GlossaryEntry> srcList = new LinkedList<GlossaryEntry>();
            GlossaryEntry nowEntry = result.get(i);
            if (nowEntry.getSrcText().equals("")) continue;
            srcList.add(nowEntry);
            for (int j = i + 1; j < result.size(); ++j) {
                GlossaryEntry thenEntry = result.get(j);
                if (thenEntry.getSrcText().equals("") || !nowEntry.getSrcText().equals(thenEntry.getSrcText())) continue;
                srcList.add(thenEntry);
                result.set(j, replaceEntry);
            }
            LinkedList<GlossaryEntry> sortList = new LinkedList<GlossaryEntry>();
            if (srcList.size() > 1) {
                for (int k = 0; k < srcList.size(); ++k) {
                    GlossaryEntry srcNow = (GlossaryEntry)srcList.get(k);
                    if (srcNow.getSrcText().equals("")) continue;
                    sortList.add(srcNow);
                    for (int l = k + 1; l < srcList.size(); ++l) {
                        GlossaryEntry srcThen = (GlossaryEntry)srcList.get(l);
                        if (srcThen.getSrcText().equals("") || !srcNow.getLocText().equals(srcThen.getLocText())) continue;
                        sortList.add(srcThen);
                        srcList.set(l, replaceEntry);
                    }
                }
            } else {
                sortList = srcList;
            }
            String srcTxt = ((GlossaryEntry)sortList.get(0)).getSrcText();
            ArrayList<String> locTxts = new ArrayList<String>();
            ArrayList<String> comTxts = new ArrayList<String>();
            ArrayList<Boolean> prios = new ArrayList<Boolean>();
            for (GlossaryEntry e : sortList) {
                for (String s : e.getLocTerms(false)) {
                    locTxts.add(s);
                }
                for (String s : e.getComments()) {
                    comTxts.add(s);
                }
                for (boolean s : e.getPriorities()) {
                    prios.add(s);
                }
            }
            boolean[] priorities = new boolean[prios.size()];
            for (int j = 0; j < prios.size(); ++j) {
                priorities[j] = (Boolean)prios.get(j);
            }
            GlossaryEntry combineEntry = new GlossaryEntry(srcTxt, locTxts.toArray(new String[locTxts.size()]), comTxts.toArray(new String[comTxts.size()]), priorities);
            returnList.add(combineEntry);
        }
        return returnList;
    }
}

