/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.help;

import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Locale;
import java.util.Properties;
import java.util.Random;
import org.omegat.util.OStrings;
import org.omegat.util.StaticUtils;

public class Help {
    public static final String ONLINE_HELP_URL = OStrings.IS_BETA ? "http://omegat.sourceforge.net/manual-latest/" : "http://omegat.sourceforge.net/manual-standard/";

    public static void showHelp() throws IOException {
        String lang = Help.detectHelpLanguage();
        URI uri = Help.getHelpFileURI(lang, "index.html");
        if (uri == null) {
            try {
                uri = new URI(ONLINE_HELP_URL);
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        Desktop.getDesktop().browse(uri);
    }

    public static URI getHelpFileURI(String lang, String filename) {
        String path = lang == null ? filename : lang + File.separator + filename;
        File file = new File(StaticUtils.installDir(), "docs" + File.separator + path);
        if (file.isFile()) {
            return file.toURI();
        }
        path = lang == null ? filename : lang + '/' + filename;
        URL url = Help.class.getResource("/docs/" + path);
        if (url != null) {
            try {
                return url.toURI();
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        return null;
    }

    public static String errorHaiku() {
        int id = new Random().nextInt(11) + 1;
        return OStrings.getString("HF_HAIKU_" + id);
    }

    private static String detectHelpLanguage() {
        String language = Locale.getDefault().getLanguage().toLowerCase(Locale.ENGLISH);
        String country = Locale.getDefault().getCountry().toUpperCase(Locale.ENGLISH);
        String locale = language + "_" + country;
        String version = Help.getDocVersion(locale);
        if (OStrings.VERSION.equals(version)) {
            return locale;
        }
        version = Help.getDocVersion(language);
        if (OStrings.VERSION.equals(version)) {
            return language;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getDocVersion(String locale) {
        if (Help.getHelpFileURI(locale, "index.html") == null) {
            return null;
        }
        Properties prop = new Properties();
        InputStream in = null;
        try {
            URI u = Help.getHelpFileURI(locale, "version.properties");
            prop.load(u.toURL().openStream());
        }
        catch (IOException ex) {
            String string = null;
            return string;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
        return prop.getProperty("version");
    }
}

