/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.tokenizer;

import java.io.Reader;
import java.io.StringReader;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.fr.FrenchAnalyzer;
import org.apache.lucene.analysis.standard.StandardTokenizer;
import org.apache.lucene.util.Version;
import org.omegat.tokenizer.BaseTokenizer;
import org.omegat.tokenizer.Tokenizer;

@Tokenizer(languages={"fr"}, isDefault=true)
public class LuceneFrenchTokenizer
extends BaseTokenizer {
    @Override
    public Map<Version, String> getSupportedBehaviors() {
        LinkedHashMap<Version, String> result = new LinkedHashMap<Version, String>();
        result.putAll(super.getSupportedBehaviors());
        result.put(Version.LUCENE_36, (String)result.get((Object)Version.LUCENE_36) + " (UniNE)");
        result.put(Version.LUCENE_31, (String)result.get((Object)Version.LUCENE_31) + " (Snowball)");
        result.put(Version.LUCENE_20, (String)result.get((Object)Version.LUCENE_20) + " (Porter)");
        return result;
    }

    @Override
    protected TokenStream getTokenStream(String strOrig, boolean stemsAllowed, boolean stopWordsAllowed) {
        if (stemsAllowed) {
            Set<Object> stopWords = stopWordsAllowed ? FrenchAnalyzer.getDefaultStopSet() : Collections.emptySet();
            return new FrenchAnalyzer(this.getBehavior(), stopWords).tokenStream("", new StringReader(strOrig));
        }
        return new StandardTokenizer(this.getBehavior(), (Reader)new StringReader(strOrig));
    }
}

