/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.util;

import java.util.regex.Pattern;

public class Token {
    private int hash;
    private static Pattern AMP = Pattern.compile("\\&");
    private int length;
    private int offset;

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof Token) {
            return this.hash == ((Token)other).hash;
        }
        return false;
    }

    public int hashCode() {
        return this.hash;
    }

    private final String stripAmpersand(String s) {
        return AMP.matcher(s).replaceAll("");
    }

    public Token(String _text, int _offset) {
        this(_text, _offset, _text.length());
    }

    public Token(String _text, int _offset, int _length) {
        this.length = _length;
        this.hash = _text == null ? -1 : this.stripAmpersand(_text).hashCode();
        this.offset = _offset;
    }

    public final int getLength() {
        return this.length;
    }

    public final int getOffset() {
        return this.offset;
    }

    public final String toString() {
        return this.hash + "@" + this.offset;
    }

    public String getTextFromString(String input) {
        return input.substring(this.offset, this.length + this.offset);
    }

    public static String[] getTextsFromString(Token[] tokens, String string) {
        String[] result = new String[tokens.length];
        for (int i = 0; i < tokens.length; ++i) {
            result[i] = tokens[i].getTextFromString(string);
        }
        return result;
    }
}

