/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.tagging.disambiguation.rules;

import java.io.IOException;
import java.util.List;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.Language;
import org.languagetool.rules.patterns.AbstractPatternRule;
import org.languagetool.rules.patterns.Element;
import org.languagetool.rules.patterns.Match;
import org.languagetool.tagging.disambiguation.rules.DisambiguatedExample;
import org.languagetool.tools.StringTools;

public class DisambiguationPatternRule
extends AbstractPatternRule {
    private final String disambiguatedPOS;
    private final Match matchElement;
    private final DisambiguatorAction disAction;
    private AnalyzedToken[] newTokenReadings;
    private List<DisambiguatedExample> examples;
    private List<String> untouchedExamples;

    DisambiguationPatternRule(String id, String description, Language language, List<Element> elements, String disamb, Match posSelect, DisambiguatorAction disambAction) {
        super(id, description, language, elements, true);
        if (id == null) {
            throw new NullPointerException("id cannot be null");
        }
        if (language == null) {
            throw new NullPointerException("language cannot be null");
        }
        if (elements == null) {
            throw new NullPointerException("elements cannot be null");
        }
        if (description == null) {
            throw new NullPointerException("description cannot be null");
        }
        if (disamb == null && posSelect == null && disambAction != DisambiguatorAction.UNIFY && disambAction != DisambiguatorAction.ADD && disambAction != DisambiguatorAction.REMOVE && disambAction != DisambiguatorAction.IMMUNIZE && disambAction != DisambiguatorAction.REPLACE && disambAction != DisambiguatorAction.FILTERALL) {
            throw new NullPointerException("disambiguated POS cannot be null");
        }
        this.disambiguatedPOS = disamb;
        this.matchElement = posSelect;
        this.disAction = disambAction;
        this.unifier = language.getDisambiguationUnifier();
    }

    public final void setNewInterpretations(AnalyzedToken[] newReadings) {
        this.newTokenReadings = (AnalyzedToken[])newReadings.clone();
    }

    public final AnalyzedSentence replace(AnalyzedSentence text) throws IOException {
        AnalyzedTokenReadings[] tokens = text.getTokensWithoutWhitespace();
        AnalyzedTokenReadings[] whTokens = text.getTokens();
        int[] tokenPositions = new int[tokens.length + 1];
        int patternSize = this.patternElements.size();
        int limit = Math.max(0, tokens.length - patternSize + 1);
        Element elem = null;
        boolean changed = false;
        for (int i = 0; !(i >= limit || this.sentStart && i > 0); ++i) {
            boolean allElementsMatch = false;
            this.unifiedTokens = null;
            int matchingTokens = 0;
            int skipShiftTotal = 0;
            int firstMatchToken = -1;
            int prevSkipNext = 0;
            if (this.testUnification) {
                this.unifier.reset();
            }
            for (int k = 0; k < patternSize; ++k) {
                Element prevElement = elem;
                elem = (Element)this.patternElements.get(k);
                this.setupRef(firstMatchToken, elem, tokens);
                int nextPos = i + k + skipShiftTotal;
                this.prevMatched = false;
                if (prevSkipNext + nextPos >= tokens.length || prevSkipNext < 0) {
                    prevSkipNext = tokens.length - (nextPos + 1);
                }
                int maxTok = Math.min(nextPos + prevSkipNext, tokens.length - (patternSize - k));
                for (int m = nextPos; m <= maxTok; ++m) {
                    allElementsMatch = this.testAllReadings(tokens, elem, prevElement, m, firstMatchToken, prevSkipNext);
                    if (!allElementsMatch) continue;
                    int skipShift = m - nextPos;
                    tokenPositions[matchingTokens] = skipShift + 1;
                    prevSkipNext = elem.getSkipNext();
                    ++matchingTokens;
                    skipShiftTotal += skipShift;
                    if (firstMatchToken != -1) break;
                    firstMatchToken = m;
                    break;
                }
                if (!allElementsMatch) break;
            }
            if (!allElementsMatch || matchingTokens != patternSize) continue;
            whTokens = this.executeAction(text, whTokens, this.unifiedTokens, firstMatchToken, matchingTokens, tokenPositions);
            changed = true;
        }
        if (changed) {
            return new AnalyzedSentence(whTokens, text.getWhPositions());
        }
        return text;
    }

    private AnalyzedTokenReadings[] executeAction(AnalyzedSentence text, AnalyzedTokenReadings[] whiteTokens, AnalyzedTokenReadings[] unifiedTokens, int firstMatchToken, int matchingTokens, int[] tokenPositions) {
        AnalyzedTokenReadings[] whTokens = (AnalyzedTokenReadings[])whiteTokens.clone();
        int correctedStPos = 0;
        if (this.startPositionCorrection > 0) {
            for (int l = 0; l <= this.startPositionCorrection; ++l) {
                correctedStPos += tokenPositions[l];
            }
            --correctedStPos;
        }
        int fromPos = text.getOriginalPosition(firstMatchToken + correctedStPos);
        int numRead = whTokens[fromPos].getReadingsLength();
        boolean spaceBefore = whTokens[fromPos].isWhitespaceBefore();
        boolean filtered = false;
        switch (this.disAction) {
            case UNIFY: {
                if (unifiedTokens == null || unifiedTokens.length != matchingTokens - this.startPositionCorrection + this.endPositionCorrection) break;
                if (whTokens[text.getOriginalPosition(firstMatchToken + correctedStPos + unifiedTokens.length - 1)].isSentEnd()) {
                    unifiedTokens[unifiedTokens.length - 1].setSentEnd();
                }
                for (int i = 0; i < unifiedTokens.length; ++i) {
                    int position = text.getOriginalPosition(firstMatchToken + correctedStPos + i);
                    unifiedTokens[i].setStartPos(whTokens[position].getStartPos());
                    String prevValue = whTokens[position].toString();
                    String prevAnot = whTokens[position].getHistoricalAnnotations();
                    whTokens[position] = unifiedTokens[i];
                    this.annotateChange(whTokens[position], prevValue, prevAnot);
                }
                break;
            }
            case REMOVE: {
                if (this.newTokenReadings == null || this.newTokenReadings.length != matchingTokens - this.startPositionCorrection + this.endPositionCorrection) break;
                for (int i = 0; i < this.newTokenReadings.length; ++i) {
                    int position = text.getOriginalPosition(firstMatchToken + correctedStPos + i);
                    String prevValue = whTokens[position].toString();
                    String prevAnot = whTokens[position].getHistoricalAnnotations();
                    whTokens[position].removeReading(this.newTokenReadings[i]);
                    this.annotateChange(whTokens[position], prevValue, prevAnot);
                }
                break;
            }
            case ADD: {
                if (this.newTokenReadings == null || this.newTokenReadings.length != matchingTokens - this.startPositionCorrection + this.endPositionCorrection) break;
                String lemma = "";
                String token = "";
                for (int i = 0; i < this.newTokenReadings.length; ++i) {
                    int position = text.getOriginalPosition(firstMatchToken + correctedStPos + i);
                    token = "".equals(this.newTokenReadings[i].getToken()) ? whTokens[position].getToken() : this.newTokenReadings[i].getToken();
                    lemma = this.newTokenReadings[i].getLemma() == null ? token : this.newTokenReadings[i].getLemma();
                    AnalyzedToken newTok = new AnalyzedToken(token, this.newTokenReadings[i].getPOSTag(), lemma);
                    String prevValue = whTokens[position].toString();
                    String prevAnot = whTokens[position].getHistoricalAnnotations();
                    whTokens[position].addReading(newTok);
                    this.annotateChange(whTokens[position], prevValue, prevAnot);
                }
                break;
            }
            case FILTERALL: {
                for (int i = 0; i < matchingTokens - this.startPositionCorrection + this.endPositionCorrection; ++i) {
                    int position = text.getOriginalPosition(firstMatchToken + correctedStPos + i);
                    Element myEl = (Element)this.patternElements.get(i + this.startPositionCorrection);
                    Match tmpMatchToken = new Match(myEl.getPOStag(), null, true, myEl.getPOStag(), null, Match.CaseConversion.NONE, false, false, Match.IncludeRange.NONE);
                    tmpMatchToken.setToken(whTokens[position]);
                    String prevValue = whTokens[position].toString();
                    String prevAnot = whTokens[position].getHistoricalAnnotations();
                    whTokens[position] = tmpMatchToken.filterReadings();
                    this.annotateChange(whTokens[position], prevValue, prevAnot);
                }
                break;
            }
            case IMMUNIZE: {
                for (int i = 0; i < matchingTokens - this.startPositionCorrection + this.endPositionCorrection; ++i) {
                    whTokens[text.getOriginalPosition(firstMatchToken + correctedStPos + i)].immunize();
                }
                break;
            }
            case FILTER: {
                if (this.matchElement == null) {
                    Match tmpMatchToken = new Match(this.disambiguatedPOS, null, true, this.disambiguatedPOS, null, Match.CaseConversion.NONE, false, false, Match.IncludeRange.NONE);
                    tmpMatchToken.setToken(whTokens[fromPos]);
                    String prevValue = whTokens[fromPos].toString();
                    String prevAnot = whTokens[fromPos].getHistoricalAnnotations();
                    whTokens[fromPos] = tmpMatchToken.filterReadings();
                    this.annotateChange(whTokens[fromPos], prevValue, prevAnot);
                    filtered = true;
                }
            }
            default: {
                String lemma;
                if (filtered) break;
                if (this.newTokenReadings != null && this.newTokenReadings.length > 0) {
                    if (this.newTokenReadings.length != matchingTokens - this.startPositionCorrection + this.endPositionCorrection) break;
                    lemma = "";
                    String token = "";
                    for (int i = 0; i < this.newTokenReadings.length; ++i) {
                        int position = text.getOriginalPosition(firstMatchToken + correctedStPos + i);
                        token = "".equals(this.newTokenReadings[i].getToken()) ? whTokens[position].getToken() : this.newTokenReadings[i].getToken();
                        lemma = this.newTokenReadings[i].getLemma() == null ? token : this.newTokenReadings[i].getLemma();
                        AnalyzedTokenReadings toReplace = new AnalyzedTokenReadings(new AnalyzedToken(token, this.newTokenReadings[i].getPOSTag(), lemma), whTokens[fromPos].getStartPos());
                        whTokens[position] = this.replaceTokens(whTokens[position], toReplace);
                    }
                    break;
                }
                if (this.matchElement == null) {
                    lemma = "";
                    for (int l = 0; l < numRead; ++l) {
                        if (whTokens[fromPos].getAnalyzedToken(l).getPOSTag() == null || !whTokens[fromPos].getAnalyzedToken(l).getPOSTag().equals(this.disambiguatedPOS) || whTokens[fromPos].getAnalyzedToken(l).getLemma() == null) continue;
                        lemma = whTokens[fromPos].getAnalyzedToken(l).getLemma();
                    }
                    if (StringTools.isEmpty(lemma)) {
                        lemma = whTokens[fromPos].getAnalyzedToken(0).getLemma();
                    }
                    AnalyzedTokenReadings toReplace = new AnalyzedTokenReadings(new AnalyzedToken(whTokens[fromPos].getToken(), this.disambiguatedPOS, lemma), whTokens[fromPos].getStartPos());
                    whTokens[fromPos] = this.replaceTokens(whTokens[fromPos], toReplace);
                    break;
                }
                this.matchElement.setToken(whTokens[fromPos]);
                String prevValue = whTokens[fromPos].toString();
                String prevAnot = whTokens[fromPos].getHistoricalAnnotations();
                whTokens[fromPos] = this.matchElement.filterReadings();
                whTokens[fromPos].setWhitespaceBefore(spaceBefore);
                this.annotateChange(whTokens[fromPos], prevValue, prevAnot);
            }
        }
        return whTokens;
    }

    private AnalyzedTokenReadings replaceTokens(AnalyzedTokenReadings oldAtr, AnalyzedTokenReadings newAtr) {
        String prevValue = oldAtr.toString();
        String prevAnot = oldAtr.getHistoricalAnnotations();
        boolean isSentEnd = oldAtr.isSentEnd();
        boolean isParaEnd = oldAtr.isParaEnd();
        boolean spaceBefore = oldAtr.isWhitespaceBefore();
        int startPosition = oldAtr.getStartPos();
        if (isSentEnd) {
            newAtr.setSentEnd();
        }
        if (isParaEnd) {
            newAtr.setParaEnd();
        }
        newAtr.setWhitespaceBefore(spaceBefore);
        newAtr.setStartPos(startPosition);
        this.annotateChange(newAtr, prevValue, prevAnot);
        return newAtr;
    }

    private void annotateChange(AnalyzedTokenReadings atr, String prevValue, String prevAnot) {
        atr.setHistoricalAnnotations(prevAnot + "\n" + this.getId() + ":" + this.getSubId() + " " + prevValue + " -> " + atr.toString());
    }

    public void setExamples(List<DisambiguatedExample> examples) {
        this.examples = examples;
    }

    public List<DisambiguatedExample> getExamples() {
        return this.examples;
    }

    public void setUntouchedExamples(List<String> untouchedExamples) {
        this.untouchedExamples = untouchedExamples;
    }

    public List<String> getUntouchedExamples() {
        return this.untouchedExamples;
    }

    public final List<Element> getElements() {
        return this.patternElements;
    }

    public static enum DisambiguatorAction {
        ADD,
        FILTER,
        REMOVE,
        REPLACE,
        UNIFY,
        IMMUNIZE,
        FILTERALL;


        public static DisambiguatorAction toAction(String str) {
            try {
                return DisambiguatorAction.valueOf(str);
            }
            catch (Exception ex) {
                return REPLACE;
            }
        }
    }
}

