/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.tagging.disambiguation.rules;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.languagetool.AnalyzedToken;
import org.languagetool.Language;
import org.languagetool.rules.patterns.Element;
import org.languagetool.rules.patterns.Match;
import org.languagetool.tagging.disambiguation.rules.DisambXMLRuleHandler;
import org.languagetool.tagging.disambiguation.rules.DisambiguatedExample;
import org.languagetool.tagging.disambiguation.rules.DisambiguationPatternRule;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

class DisambiguationRuleHandler
extends DisambXMLRuleHandler {
    private static final String WD = "wd";
    private static final String ACTION = "action";
    private static final String DISAMBIG = "disambig";
    private int subId;
    private String name;
    private String ruleGroupId;
    private String ruleGroupName;
    private StringBuilder disamb = new StringBuilder();
    private StringBuilder wd = new StringBuilder();
    private StringBuilder example = new StringBuilder();
    private boolean inWord;
    private String disambiguatedPOS;
    private int startPos = -1;
    private int endPos = -1;
    private int tokenCountForMarker = 0;
    private Match posSelector;
    private int uniCounter;
    private List<AnalyzedToken> newWdList;
    private String wdLemma;
    private String wdPos;
    private boolean inExample;
    private boolean untouched;
    private List<String> untouchedExamples;
    private List<DisambiguatedExample> disambExamples;
    private String input;
    private String output;
    private DisambiguationPatternRule.DisambiguatorAction disambigAction;

    DisambiguationRuleHandler() {
    }

    @Override
    public void startElement(String namespaceURI, String lName, String qName, Attributes attrs) throws SAXException {
        if (qName.equals("rule")) {
            this.id = attrs.getValue("id");
            if (this.inRuleGroup) {
                ++this.subId;
            }
            this.name = attrs.getValue("name");
            if (this.inRuleGroup && this.id == null) {
                this.id = this.ruleGroupId;
            }
            if (this.inRuleGroup && this.name == null) {
                this.name = this.ruleGroupName;
            }
        } else if ("rules".equals(qName)) {
            this.language = Language.getLanguageForShortName(attrs.getValue("lang"));
        } else if (qName.equals("pattern")) {
            this.inPattern = true;
            this.tokenCountForMarker = 0;
            if (attrs.getValue("case_sensitive") != null && "yes".equals(attrs.getValue("case_sensitive"))) {
                this.caseSensitive = true;
            }
        } else if (qName.equals("exception")) {
            this.setExceptions(attrs);
        } else if (qName.equals("and")) {
            this.inAndGroup = true;
            ++this.tokenCountForMarker;
            if (this.inUnification) {
                ++this.uniCounter;
            }
        } else if (qName.equals("unify")) {
            this.inUnification = true;
            this.uniNegation = "yes".equals(attrs.getValue("negate"));
            this.uniCounter = 0;
        } else if ("feature".equals(qName)) {
            this.uFeature = attrs.getValue("id");
        } else if (qName.equals("type")) {
            this.uType = attrs.getValue("id");
            this.uTypeList.add(this.uType);
        } else if (qName.equals("token")) {
            this.setToken(attrs);
            if (!this.inAndGroup) {
                ++this.tokenCountForMarker;
            }
        } else if (qName.equals(DISAMBIG)) {
            this.inDisambiguation = true;
            this.disambiguatedPOS = attrs.getValue("postag");
            this.disambigAction = attrs.getValue(ACTION) == null ? DisambiguationPatternRule.DisambiguatorAction.toAction("REPLACE") : DisambiguationPatternRule.DisambiguatorAction.toAction(attrs.getValue(ACTION).toUpperCase());
            this.disamb = new StringBuilder();
        } else if (qName.equals("match")) {
            this.inMatch = true;
            this.match = new StringBuilder();
            Match.CaseConversion caseConversion = Match.CaseConversion.NONE;
            if (attrs.getValue("case_conversion") != null) {
                caseConversion = Match.CaseConversion.toCase(attrs.getValue("case_conversion").toUpperCase());
            }
            Match.IncludeRange includeRange = Match.IncludeRange.NONE;
            if (attrs.getValue("include_skipped") != null) {
                includeRange = Match.IncludeRange.toRange(attrs.getValue("include_skipped").toUpperCase());
            }
            Match mWorker = new Match(attrs.getValue("postag"), attrs.getValue("postag_replace"), "yes".equals(attrs.getValue("postag_regexp")), attrs.getValue("regexp_match"), attrs.getValue("regexp_replace"), caseConversion, "yes".equals(attrs.getValue("setpos")), "yes".equals(attrs.getValue("suppress_mispelled")), includeRange);
            if (this.inDisambiguation) {
                if (attrs.getValue("no") != null) {
                    int refNumber = Integer.parseInt(attrs.getValue("no"));
                    if (refNumber > this.elementList.size()) {
                        throw new SAXException("Only backward references in match elements are possible, tried to specify token " + refNumber + "\n Line: " + this.pLocator.getLineNumber() + ", column: " + this.pLocator.getColumnNumber() + ".");
                    }
                    mWorker.setTokenRef(refNumber);
                    this.posSelector = mWorker;
                }
            } else if (this.inToken && attrs.getValue("no") != null) {
                int refNumber = Integer.parseInt(attrs.getValue("no"));
                if (refNumber > this.elementList.size()) {
                    throw new SAXException("Only backward references in match elements are possible, tried to specify token " + refNumber + "\n Line: " + this.pLocator.getLineNumber() + ", column: " + this.pLocator.getColumnNumber() + ".");
                }
                mWorker.setTokenRef(refNumber);
                this.tokenReference = mWorker;
                this.elements.append('\\');
                this.elements.append(refNumber);
            }
        } else if (qName.equals("rulegroup")) {
            this.ruleGroupId = attrs.getValue("id");
            this.ruleGroupName = attrs.getValue("name");
            this.inRuleGroup = true;
            this.subId = 0;
        } else if (qName.equals("unification")) {
            this.uFeature = attrs.getValue("feature");
            this.inUnificationDef = true;
        } else if ("equivalence".equals(qName)) {
            this.uType = attrs.getValue("type");
        } else if (qName.equals(WD)) {
            this.wdLemma = attrs.getValue("lemma");
            this.wdPos = attrs.getValue("pos");
            this.inWord = true;
            this.wd = new StringBuilder();
        } else if (qName.equals("example")) {
            this.inExample = true;
            if (this.untouchedExamples == null) {
                this.untouchedExamples = new ArrayList<String>();
            }
            if (this.disambExamples == null) {
                this.disambExamples = new ArrayList<DisambiguatedExample>();
            }
            this.untouched = attrs.getValue("type").equals("untouched");
            if (attrs.getValue("type").equals("ambiguous")) {
                this.input = attrs.getValue("inputform");
                this.output = attrs.getValue("outputform");
            }
            this.example = new StringBuilder();
        } else if ("marker".equals(qName)) {
            this.example.append("<marker>");
            if (this.inPattern) {
                this.startPos = this.tokenCounter;
            }
        }
    }

    @Override
    public void endElement(String namespaceURI, String sName, String qName) throws SAXException {
        if ("rule".equals(qName)) {
            boolean singleTokenCorrection;
            DisambiguationPatternRule rule = new DisambiguationPatternRule(this.id, this.name, this.language, this.elementList, this.disambiguatedPOS, this.posSelector, this.disambigAction);
            this.endPositionCorrection = this.endPos - this.tokenCountForMarker;
            if (this.startPos != -1 && this.endPos != -1) {
                rule.setStartPositionCorrection(this.startPos);
                rule.setEndPositionCorrection(this.endPositionCorrection);
            } else {
                this.startPos = 0;
                this.endPos = this.tokenCountForMarker;
            }
            rule.setSubId(this.inRuleGroup ? Integer.toString(this.subId) : "1");
            int matchedTokenCount = this.endPos - this.startPos;
            if (this.newWdList != null) {
                if (this.disambigAction == DisambiguationPatternRule.DisambiguatorAction.ADD || this.disambigAction == DisambiguationPatternRule.DisambiguatorAction.REMOVE || this.disambigAction == DisambiguationPatternRule.DisambiguatorAction.REPLACE) {
                    if (!this.newWdList.isEmpty() && this.disambigAction == DisambiguationPatternRule.DisambiguatorAction.REPLACE && this.newWdList.size() != matchedTokenCount) {
                        throw new SAXException(this.language.getName() + " rule error. The number of interpretations specified with wd: " + this.newWdList.size() + " must be equal to the number of matched tokens (" + matchedTokenCount + ")" + "\n Line: " + this.pLocator.getLineNumber() + ", column: " + this.pLocator.getColumnNumber() + ".");
                    }
                    rule.setNewInterpretations(this.newWdList.toArray(new AnalyzedToken[this.newWdList.size()]));
                }
                this.newWdList.clear();
            }
            this.caseSensitive = false;
            if (this.disambExamples != null) {
                rule.setExamples(this.disambExamples);
            }
            if (this.untouchedExamples != null) {
                rule.setUntouchedExamples(this.untouchedExamples);
            }
            this.rules.add(rule);
            if (this.disambigAction == DisambiguationPatternRule.DisambiguatorAction.UNIFY && matchedTokenCount != this.uniCounter) {
                throw new SAXException(this.language.getName() + " rule error. The number unified tokens: " + this.uniCounter + " must be equal to the number of matched tokens: " + matchedTokenCount + "\n Line: " + this.pLocator.getLineNumber() + ", column: " + this.pLocator.getColumnNumber() + ".");
            }
            boolean bl = singleTokenCorrection = this.endPos - this.startPos > 1;
            if (!(singleTokenCorrection || this.disambigAction != DisambiguationPatternRule.DisambiguatorAction.FILTER && this.disambigAction != DisambiguationPatternRule.DisambiguatorAction.REPLACE || matchedTokenCount <= 1)) {
                throw new SAXException(this.language.getName() + " rule error. Cannot replace or filter more than one token at a time." + "\n Line: " + this.pLocator.getLineNumber() + ", column: " + this.pLocator.getColumnNumber() + ".");
            }
            this.elementList.clear();
            this.posSelector = null;
            this.disambExamples = null;
            this.untouchedExamples = null;
            this.startPos = -1;
            this.endPos = -1;
        } else if (qName.equals("exception")) {
            this.finalizeExceptions();
        } else if (qName.equals("and")) {
            this.inAndGroup = false;
            this.andGroupCounter = 0;
            ++this.tokenCounter;
        } else if (qName.equals("token")) {
            if (!this.exceptionSet || this.tokenElement == null) {
                this.tokenElement = new Element(this.elements.toString(), this.caseSensitive, this.regExpression, this.tokenInflected);
                this.tokenElement.setNegation(this.tokenNegated);
            } else {
                this.tokenElement.setStringElement(this.elements.toString());
            }
            if (this.skipPos != 0) {
                this.tokenElement.setSkipNext(this.skipPos);
                this.skipPos = 0;
            }
            if (this.posToken != null) {
                this.tokenElement.setPosElement(this.posToken, this.posRegExp, this.posNegation);
                this.posToken = null;
            }
            if (this.tokenReference != null) {
                this.tokenElement.setMatch(this.tokenReference);
            }
            if (this.inAndGroup && this.andGroupCounter > 0) {
                ((Element)this.elementList.get(this.elementList.size() - 1)).setAndGroupElement(this.tokenElement);
            } else {
                this.elementList.add(this.tokenElement);
            }
            if (this.inAndGroup) {
                ++this.andGroupCounter;
            }
            if (this.inUnification) {
                this.tokenElement.setUnification(this.equivalenceFeatures);
                if (!this.inAndGroup) {
                    ++this.uniCounter;
                }
            }
            if (this.inUnificationDef) {
                this.language.getDisambiguationUnifier().setEquivalence(this.uFeature, this.uType, this.tokenElement);
                this.elementList.clear();
            }
            if (this.tokenSpaceBeforeSet) {
                this.tokenElement.setWhitespaceBefore(this.tokenSpaceBefore);
            }
            this.resetToken();
        } else if (qName.equals("pattern")) {
            this.inPattern = false;
            this.tokenCounter = 0;
        } else if (qName.equals("match")) {
            if (this.inDisambiguation) {
                this.posSelector.setLemmaString(this.match.toString());
            } else if (this.inToken) {
                this.tokenReference.setLemmaString(this.match.toString());
            }
            this.inMatch = false;
        } else if (qName.equals(DISAMBIG)) {
            this.inDisambiguation = false;
        } else if (qName.equals("rulegroup")) {
            this.inRuleGroup = false;
        } else if (qName.equals("unification") && this.inUnificationDef) {
            this.inUnificationDef = false;
            this.tokenCounter = 0;
        } else if ("feature".equals(qName)) {
            this.equivalenceFeatures.put(this.uFeature, this.uTypeList);
            this.uTypeList = new ArrayList();
        } else if (qName.equals("unify")) {
            this.inUnification = false;
            this.equivalenceFeatures = new HashMap();
            int lastElement = this.elementList.size() - 1;
            ((Element)this.elementList.get(lastElement)).setLastInUnification();
            if (this.uniNegation) {
                ((Element)this.elementList.get(lastElement)).setUniNegation();
            }
        } else if (qName.equals(WD)) {
            this.addNewWord(this.wd.toString(), this.wdLemma, this.wdPos);
            this.inWord = false;
        } else if ("example".equals(qName)) {
            this.inExample = false;
            if (this.untouched) {
                this.untouchedExamples.add(this.example.toString());
            } else {
                this.disambExamples.add(new DisambiguatedExample(this.example.toString(), this.input, this.output));
            }
        } else if ("marker".equals(qName)) {
            this.example.append("</marker>");
            if (this.inPattern) {
                this.endPos = this.tokenCountForMarker;
            }
        }
    }

    private void addNewWord(String word, String lemma, String pos) {
        AnalyzedToken newWd = new AnalyzedToken(word, pos, lemma);
        if (this.newWdList == null) {
            this.newWdList = new ArrayList<AnalyzedToken>();
        }
        this.newWdList.add(newWd);
    }

    @Override
    public final void characters(char[] buf, int offset, int len) {
        String s = new String(buf, offset, len);
        if (this.inException) {
            this.exceptions.append(s);
        } else if (this.inToken && this.inPattern) {
            this.elements.append(s);
        } else if (this.inMatch) {
            this.match.append(s);
        } else if (this.inWord) {
            this.wd.append(s);
        } else if (this.inDisambiguation) {
            this.disamb.append(s);
        } else if (this.inExample) {
            this.example.append(s);
        }
    }
}

