/*
 * Decompiled with CFR 0.152.
 */
package org.dict.zip;

import java.io.EOFException;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;

public class DictZipHeader {
    int headerLength;
    int[] chunks;
    int[] offsets;
    int extraLength;
    byte subfieldID1;
    byte subfieldID2;
    int subfieldLength;
    int subfieldVersion;
    int chunkLength;
    int chunkCount;
    public static final int GZIP_MAGIC = 35615;
    public static final int FTEXT = 1;
    public static final int FHCRC = 2;
    public static final int FEXTRA = 4;
    public static final int FNAME = 8;
    public static final int FCOMMENT = 16;

    private void initOffsets() {
        this.offsets = new int[this.chunks.length];
        this.offsets[0] = this.headerLength;
        for (int i = 1; i < this.chunks.length; ++i) {
            this.offsets[i] = this.offsets[i - 1] + this.chunks[i - 1];
        }
    }

    private static void log(Object object) {
        System.out.println(object);
    }

    public static DictZipHeader readHeader(String string) throws IOException {
        DictZipHeader dictZipHeader = new DictZipHeader();
        CRC32 cRC32 = new CRC32();
        FileInputStream fileInputStream = new FileInputStream(string);
        DictZipHeader.readHeader(dictZipHeader, fileInputStream, cRC32);
        ((InputStream)fileInputStream).close();
        return dictZipHeader;
    }

    public static void readHeader(DictZipHeader dictZipHeader, InputStream inputStream, CRC32 cRC32) throws IOException {
        int n;
        CheckedInputStream checkedInputStream = new CheckedInputStream(inputStream, cRC32);
        cRC32.reset();
        if (DictZipHeader.readUShort(checkedInputStream) != 35615) {
            throw new IOException("Not in GZIP format");
        }
        if (DictZipHeader.readUByte(checkedInputStream) != 8) {
            throw new IOException("Unsupported compression method");
        }
        int n2 = DictZipHeader.readUByte(checkedInputStream);
        DictZipHeader.skipBytes(checkedInputStream, 6);
        dictZipHeader.headerLength = 10;
        if ((n2 & 4) == 4) {
            dictZipHeader.extraLength = DictZipHeader.readUShort(checkedInputStream);
            dictZipHeader.headerLength += dictZipHeader.extraLength + 2;
            dictZipHeader.subfieldID1 = (byte)DictZipHeader.readUByte(checkedInputStream);
            dictZipHeader.subfieldID2 = (byte)DictZipHeader.readUByte(checkedInputStream);
            dictZipHeader.subfieldLength = DictZipHeader.readUShort(checkedInputStream);
            dictZipHeader.subfieldVersion = DictZipHeader.readUShort(checkedInputStream);
            dictZipHeader.chunkLength = DictZipHeader.readUShort(checkedInputStream);
            dictZipHeader.chunkCount = DictZipHeader.readUShort(checkedInputStream);
            dictZipHeader.chunks = new int[dictZipHeader.chunkCount];
            for (n = 0; n < dictZipHeader.chunkCount; ++n) {
                dictZipHeader.chunks[n] = DictZipHeader.readUShort(checkedInputStream);
            }
        }
        if ((n2 & 8) == 8) {
            while (DictZipHeader.readUByte(checkedInputStream) != 0) {
                ++dictZipHeader.headerLength;
            }
            ++dictZipHeader.headerLength;
        }
        if ((n2 & 0x10) == 16) {
            while (DictZipHeader.readUByte(checkedInputStream) != 0) {
                ++dictZipHeader.headerLength;
            }
            ++dictZipHeader.headerLength;
        }
        if ((n2 & 2) == 2) {
            n = (int)cRC32.getValue() & 0xFFFF;
            if (DictZipHeader.readUShort(checkedInputStream) != n) {
                throw new IOException("Corrupt GZIP header");
            }
            dictZipHeader.headerLength += 2;
        }
        dictZipHeader.initOffsets();
    }

    public static int readUByte(InputStream inputStream) throws IOException {
        int n = inputStream.read();
        if (n == -1) {
            throw new EOFException();
        }
        return n;
    }

    public static long readUInt(InputStream inputStream) throws IOException {
        long l = DictZipHeader.readUShort(inputStream);
        return (long)DictZipHeader.readUShort(inputStream) << 16 | l;
    }

    public static int readUShort(InputStream inputStream) throws IOException {
        int n = DictZipHeader.readUByte(inputStream);
        return DictZipHeader.readUByte(inputStream) << 8 | n;
    }

    public static void skipBytes(InputStream inputStream, int n) throws IOException {
        byte[] byArray = new byte[128];
        while (n > 0) {
            int n2 = inputStream.read(byArray, 0, n < byArray.length ? n : byArray.length);
            if (n2 == -1) {
                throw new EOFException();
            }
            n -= n2;
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\nHeader length = " + this.headerLength);
        stringBuffer.append("\nSubfield ID = " + (char)this.subfieldID1 + (char)this.subfieldID2);
        stringBuffer.append("\nSubfield length = " + this.subfieldLength);
        stringBuffer.append("\nSubfield version = " + this.subfieldVersion);
        stringBuffer.append("\nChunk length = " + this.chunkLength);
        stringBuffer.append("\nNumber of chunks = " + this.chunkCount);
        return stringBuffer.toString();
    }

    public static void writeHeader(DictZipHeader dictZipHeader, OutputStream outputStream) throws IOException {
        DictZipHeader.writeShort(outputStream, 35615);
        outputStream.write(8);
        outputStream.write(4);
        DictZipHeader.writeInt(outputStream, 0);
        outputStream.write(0);
        outputStream.write(0);
        DictZipHeader.writeShort(outputStream, dictZipHeader.extraLength);
        outputStream.write(dictZipHeader.subfieldID1);
        outputStream.write(dictZipHeader.subfieldID2);
        DictZipHeader.writeShort(outputStream, dictZipHeader.extraLength);
        DictZipHeader.writeShort(outputStream, dictZipHeader.subfieldVersion);
        DictZipHeader.writeShort(outputStream, dictZipHeader.chunkLength);
        DictZipHeader.writeShort(outputStream, dictZipHeader.chunkCount);
        for (int i = 0; i < dictZipHeader.chunkCount; ++i) {
            DictZipHeader.writeShort(outputStream, dictZipHeader.chunks[i]);
        }
    }

    public static void writeInt(OutputStream outputStream, int n) throws IOException {
        DictZipHeader.writeShort(outputStream, n & 0xFFFF);
        DictZipHeader.writeShort(outputStream, n >> 16 & 0xFFFF);
    }

    public static void writeShort(OutputStream outputStream, int n) throws IOException {
        outputStream.write(n & 0xFF);
        outputStream.write(n >> 8 & 0xFF);
    }

    public int getOffset(int n) {
        return n % this.chunkLength;
    }

    public int getPosition(int n) {
        int n2 = n / this.chunkLength;
        return this.offsets[n2];
    }
}

