/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.machinetranslators;

import java.io.IOException;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.omegat.core.machinetranslators.BaseTranslate;
import org.omegat.util.Language;
import org.omegat.util.OStrings;
import org.omegat.util.WikiGet;

public class Google2Translate
extends BaseTranslate {
    protected static final String GT_URL = "https://www.googleapis.com/language/translate/v2";
    protected static final Pattern RE_UNICODE = Pattern.compile("\\\\u([0-9A-Fa-f]{4})");
    protected static final Pattern RE_HTML = Pattern.compile("&#([0-9]+);");

    @Override
    protected String getPreferenceName() {
        return "allow_google2_translate";
    }

    @Override
    public String getName() {
        return OStrings.getString("MT_ENGINE_GOOGLE2");
    }

    @Override
    protected String translate(Language sLang, Language tLang, String text) throws Exception {
        char c;
        String g;
        Matcher m;
        String v;
        String trText = text.length() > 5000 ? text.substring(0, 4997) + "..." : text;
        String prev = this.getFromCache(sLang, tLang, trText);
        if (prev != null) {
            return prev;
        }
        String targetLang = tLang.getLanguageCode();
        if (tLang.getLanguage().compareToIgnoreCase("zh-cn") == 0 || tLang.getLanguage().compareToIgnoreCase("zh-tw") == 0) {
            targetLang = tLang.getLanguage();
        } else if (tLang.getLanguage().compareToIgnoreCase("zh-hk") == 0) {
            targetLang = "ZH-TW";
        }
        String googleKey = System.getProperty("google.api.key");
        if (googleKey == null) {
            return OStrings.getString("GOOGLE_API_KEY_NOTFOUND");
        }
        TreeMap<String, String> params = new TreeMap<String, String>();
        params.put("key", googleKey);
        params.put("source", sLang.getLanguageCode());
        params.put("target", targetLang);
        params.put("q", trText);
        TreeMap<String, String> headers = new TreeMap<String, String>();
        headers.put("X-HTTP-Method-Override", "GET");
        try {
            v = WikiGet.post(GT_URL, params, headers);
        }
        catch (IOException e) {
            return e.getLocalizedMessage();
        }
        while ((m = RE_UNICODE.matcher(v)).find()) {
            g = m.group();
            c = (char)Integer.parseInt(m.group(1), 16);
            v = v.replace(g, Character.toString(c));
        }
        v = v.replace("&quot;", "&#34;");
        v = v.replace("&nbsp;", "&#160;");
        v = v.replace("&amp;", "&#38;");
        while ((m = RE_HTML.matcher(v)).find()) {
            g = m.group();
            c = (char)Integer.parseInt(m.group(1));
            v = v.replace(g, Character.toString(c));
        }
        Pattern pattern = Pattern.compile("\\{\\s*\"translatedText\"\\s*:\\s*\"(.*?)\"\\s*\\s*\\}\\s*]");
        Matcher matcher = pattern.matcher(v);
        boolean matchFound = matcher.find();
        String tr = "";
        if (matchFound) {
            tr = matcher.group(1);
        }
        tr = this.cleanSpacesAroundTags(tr, text);
        this.putToCache(sLang, tLang, trText, tr);
        return tr;
    }
}

