/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.matching.external;

import java.io.IOException;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.omegat.core.data.PrepareTMXEntry;
import org.omegat.core.matching.external.MenuMemory;
import org.omegat.util.Language;
import org.omegat.util.OStrings;
import org.omegat.util.WikiGet;
import org.openide.awt.Mnemonics;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class MyMemory
extends MenuMemory {
    private String name = "MyMemory";
    private String user;
    private String key;
    private byte mt = 0;
    protected static String GT_URL = "http://mymemory.translated.net/api/get?q=";
    protected static String GT_URL2 = "&langpair=#sourceLang#|#targetLang#&of=#format#";
    protected static String XPATH_QUERY_ALL_TU = "//tu";
    protected static String XPATH_QUERY_TUV = "child::tuv[starts-with(@lang, '#langCode#')]/seg/text()";
    public static final SimpleDateFormat dateFormat1 = new SimpleDateFormat("yyyyMMdd'T'HHmmss'Z'", Locale.ENGLISH);

    public MyMemory() {
        Mnemonics.setLocalizedText(this.menuItem, this.getMemoryName());
    }

    public MyMemory(Properties prop) {
        if (prop.getProperty("name") != null) {
            this.name = prop.getProperty("name");
        }
        if (prop.getProperty("mt") != null) {
            String mtString = prop.getProperty("mt");
            if (mtString.equals("0") || mtString.equalsIgnoreCase("false")) {
                this.mt = 0;
            }
            if (mtString.equals("1") || mtString.equalsIgnoreCase("true")) {
                this.mt = 1;
            }
        }
        this.user = prop.getProperty("user");
        this.key = prop.getProperty("key");
        this.enabled = true;
    }

    protected String mymemoryCode(Language language) {
        String lCode = language.getLanguageCode().toLowerCase();
        return lCode;
    }

    protected String buildMyMemoryUrl(Language sLang, Language tLang, String text, String format) throws UnsupportedEncodingException {
        String sourceLang = this.mymemoryCode(sLang);
        String targetLang = this.mymemoryCode(tLang);
        String url2 = GT_URL2.replace("#sourceLang#", sourceLang).replace("#targetLang#", targetLang).replace("#format#", format);
        String url = GT_URL + URLEncoder.encode(text, "UTF-8") + url2 + "&mt=" + this.mt;
        if (this.user != null) {
            url = url + "&user=" + this.user;
        }
        if (this.key != null) {
            url = url + "&key=" + this.key;
        }
        return url;
    }

    protected String getMyMemoryResponse(Language sLang, Language tLang, String text, String format) throws UnsupportedEncodingException, IOException {
        String url = this.buildMyMemoryUrl(sLang, tLang, text, format);
        String myMemoryResponse = "";
        myMemoryResponse = WikiGet.getURL(url);
        return myMemoryResponse;
    }

    protected String cleanUpText(String str) {
        str = str.replace("&quot;", "\"");
        str = str.replace("&nbsp;", "\u00a0");
        str = str.replace("&amp;", "&");
        str = str.replace("&apos;", "'");
        str = str.replace("&#39;", "'");
        str = str.replace("&lt;", "<");
        str = str.replace("&gt;", ">");
        str = str.trim();
        return str;
    }

    @Override
    protected String getPreferenceName() {
        return "allow_mymemory_translation_memory";
    }

    @Override
    public String getProviderName() {
        return OStrings.getString("XTM_ENGINE_MYMEMORY");
    }

    @Override
    public String getMemoryName() {
        return this.name;
    }

    @Override
    public List<PrepareTMXEntry> retreiveMatchingTranslations(Language sLang, Language tLang, String text, int minScore, int maxCount) throws Exception {
        String tmxResponse = "";
        try {
            tmxResponse = this.getMyMemoryResponse(sLang, tLang, text, "tmx");
        }
        catch (Exception e) {
            e.printStackTrace();
            return Collections.EMPTY_LIST;
        }
        tmxResponse = tmxResponse.replace("<!DOCTYPE tmx SYSTEM \"tmx11.dtd\">", "");
        tmxResponse = tmxResponse.replace("&", "&amp;");
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        InputSource source = new InputSource(new StringReader(tmxResponse));
        Document document = factory.newDocumentBuilder().parse(source);
        XPathFactory xPathFactory = XPathFactory.newInstance();
        XPath xpath = xPathFactory.newXPath();
        XPathExpression expr = xpath.compile(XPATH_QUERY_ALL_TU);
        Object result = expr.evaluate(document, XPathConstants.NODESET);
        NodeList allTUs = (NodeList)result;
        if (allTUs.getLength() == 0) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<PrepareTMXEntry> entries = new ArrayList<PrepareTMXEntry>(allTUs.getLength());
        String targetSegQueryString = XPATH_QUERY_TUV.replace("#langCode#", tLang.getLanguageCode());
        String sourceSegQueryString = XPATH_QUERY_TUV.replace("#langCode#", sLang.getLanguageCode());
        for (int i = 0; i < allTUs.getLength(); ++i) {
            Element tu = (Element)allTUs.item(i);
            PrepareTMXEntry entry = new PrepareTMXEntry();
            entry.source = xpath.evaluate(sourceSegQueryString, tu);
            entry.translation = xpath.evaluate(targetSegQueryString, tu);
            try {
                entry.creator = tu.getAttribute("creationid");
                entry.creationDate = dateFormat1.parse(tu.getAttribute("creationdate")).getTime();
                entry.changer = tu.getAttribute("changeid");
                entry.changeDate = dateFormat1.parse(tu.getAttribute("changedate")).getTime();
            }
            catch (Exception exception) {
                // empty catch block
            }
            entries.add(entry);
        }
        return entries;
    }
}

