/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.matching.external;

import java.io.File;
import java.io.FileInputStream;
import java.lang.reflect.Constructor;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.omegat.core.Core;
import org.omegat.core.CoreEvents;
import org.omegat.core.data.IProject;
import org.omegat.core.data.PrepareTMXEntry;
import org.omegat.core.data.ProjectTMX;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.core.data.TMXEntry;
import org.omegat.core.events.IEntryEventListener;
import org.omegat.filters2.master.PluginUtils;
import org.omegat.util.Language;
import org.omegat.util.Log;

public class ProjectMemory
extends ProjectTMX
implements IEntryEventListener {
    private IExternalProjectMemory memory;
    private IProject project;
    private long timeStamp = 0L;
    private long timeStamp_interval = 1000L;
    public static final long TIMESTAMP_REFRESH = -1L;
    private static final List<ContextTMXEntry> EMPTY_CHANGES = Collections.EMPTY_LIST;

    public ProjectMemory(Language sourceLanguage, Language targetLanguage, boolean isSentenceSegmentingEnabled, File saveTmxFile, ProjectTMX.CheckOrphanedCallback callback, IProject project, File propertiesFile) throws Exception {
        super(sourceLanguage, targetLanguage, isSentenceSegmentingEnabled, saveTmxFile, callback);
        this.project = project;
        Properties config = new Properties();
        FileInputStream fis = new FileInputStream(propertiesFile);
        config.load(fis);
        fis.close();
        Class<?> memoryClass = PluginUtils.getPluginsClassLoader().loadClass(config.getProperty("class"));
        Constructor<?> cons = memoryClass.getConstructor(Properties.class);
        this.memory = (IExternalProjectMemory)cons.newInstance(config);
        try {
            this.timeStamp_interval = Long.parseLong(config.getProperty("timestamp.interval"));
            Log.log("Created project memory with timestamp interval " + this.timeStamp_interval + " milliseconds");
        }
        catch (Exception e) {
            Log.log("Created project memory with default timestamp interval (1 second)");
        }
        CoreEvents.registerEntryEventListener(this);
    }

    @Override
    public void onNewFile(String activeFileName) {
    }

    @Override
    public void onEntryActivated(SourceTextEntry newEntry) {
        block5: {
            try {
                List<ContextTMXEntry> changes = this.refresh();
                if (changes.size() <= 0) break block5;
                int num = Core.getEditor().getCurrentEntryNumber();
                try {
                    for (ContextTMXEntry tmx0 : changes) {
                        Core.getEditor().gotoEntry(tmx0.entryNum);
                    }
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
                Core.getEditor().gotoEntry(num);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private synchronized List<ContextTMXEntry> refresh() throws Exception {
        if (this.timeStamp == -1L) {
            return EMPTY_CHANGES;
        }
        if (System.currentTimeMillis() - this.timeStamp < this.timeStamp_interval) {
            return EMPTY_CHANGES;
        }
        List<ContextTMXEntry> changes = this.memory.findChanges(this.timeStamp);
        this.timeStamp = -1L;
        List<SourceTextEntry> sourceEntries = Core.getProject().getAllEntries();
        for (ContextTMXEntry tmx0 : changes) {
            this.project.setTranslation(sourceEntries.get(tmx0.entryNum - 1), tmx0, tmx0.isDefault, tmx0.linked);
        }
        this.timeStamp = System.currentTimeMillis();
        return changes;
    }

    @Override
    public void setTranslation(SourceTextEntry ste, TMXEntry te, boolean isDefault) {
        super.setTranslation(ste, te, isDefault);
        if (this.timeStamp == -1L) {
            return;
        }
        try {
            if (te == null) {
                this.memory.removeTranslation(new ContextTMXEntry(ste, isDefault));
            } else {
                this.memory.registerTranslation(new ContextTMXEntry(te, ste));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static interface IExternalProjectMemory {
        public List<ContextTMXEntry> findChanges(long var1) throws Exception;

        public void registerTranslation(ContextTMXEntry var1) throws Exception;

        public void removeTranslation(ContextTMXEntry var1) throws Exception;
    }

    public static class ContextTMXEntry
    extends PrepareTMXEntry {
        public int entryNum = -1;
        public boolean isDefault;
        public TMXEntry.ExternalLinked linked;

        public ContextTMXEntry() {
        }

        public ContextTMXEntry(SourceTextEntry sourceEntry, boolean isDefault) {
            this.isDefault = isDefault;
            this.entryNum = sourceEntry.entryNum();
            this.linked = null;
            this.source = sourceEntry.getSrcText();
            this.translation = null;
            this.note = null;
        }

        public ContextTMXEntry(TMXEntry tmx, SourceTextEntry sourceEntry) {
            super(tmx);
            this.isDefault = tmx.defaultTranslation;
            this.entryNum = sourceEntry.entryNum();
            this.linked = tmx.linked;
        }
    }
}

