/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.matching.external.rmi;

import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.omegat.core.Core;
import org.omegat.core.CoreEvents;
import org.omegat.core.data.IProject;
import org.omegat.core.data.RealProject;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.core.data.TMXEntry;
import org.omegat.core.events.IEntryEventListener;
import org.omegat.core.matching.external.ProjectMemory;
import org.omegat.core.matching.external.rmi.IDistantExternalMemory;

public class Server
extends UnicastRemoteObject
implements IDistantExternalMemory,
IEntryEventListener {
    private Set<Integer> changes = new HashSet<Integer>();
    private Set<SourceTextEntry> used = new HashSet<SourceTextEntry>();

    public Server() throws RemoteException {
        CoreEvents.registerEntryEventListener(this);
    }

    @Override
    public void onNewFile(String activeFileName) {
    }

    @Override
    public void onEntryActivated(SourceTextEntry newEntry) {
        try {
            if (this.changes.size() > 0) {
                int num = Core.getEditor().getCurrentEntryNumber();
                try {
                    for (int id : this.changes) {
                        Core.getEditor().gotoEntry(id);
                    }
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
                Core.getEditor().gotoEntry(num);
            }
            this.changes.clear();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.used.add(newEntry);
    }

    @Override
    public List<ProjectMemory.ContextTMXEntry> findChanges(long timeStamp) throws RemoteException {
        IProject proj = Core.getProject();
        if (!(proj instanceof RealProject)) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<ProjectMemory.ContextTMXEntry> res = new ArrayList<ProjectMemory.ContextTMXEntry>();
        List<SourceTextEntry> usedEntries = timeStamp == 0L ? Core.getProject().getAllEntries() : (this.used.isEmpty() ? Core.getProject().getAllEntries() : this.used);
        for (SourceTextEntry sourceEntry : usedEntries) {
            TMXEntry trans = proj.getTranslationInfo(sourceEntry);
            if (!trans.isTranslated() || trans.changeDate < timeStamp && trans.creationDate < timeStamp) continue;
            res.add(new ProjectMemory.ContextTMXEntry(trans, sourceEntry));
        }
        return res;
    }

    @Override
    public void registerTranslation(ProjectMemory.ContextTMXEntry entry) throws RemoteException {
        int num = entry.entryNum - 1;
        this.changes.add(num);
        SourceTextEntry ste = Core.getProject().getAllEntries().get(num);
        this.used.add(ste);
        Core.getProject().setTranslation(ste, entry, entry.isDefault, entry.linked);
    }

    @Override
    public void removeTranslation(ProjectMemory.ContextTMXEntry entry) throws RemoteException {
        int num = entry.entryNum - 1;
        this.changes.add(num);
        SourceTextEntry ste = Core.getProject().getAllEntries().get(num);
        this.used.add(ste);
        Core.getProject().setTranslation(ste, entry, entry.isDefault, entry.linked);
    }

    @Override
    public long timeStamp() throws RemoteException {
        return System.currentTimeMillis();
    }
}

