/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.statistics;

import org.omegat.core.statistics.StatCount;

public class MatchStatCounts {
    private final StatCount[] counts;
    private final int baseForPercents;

    public MatchStatCounts(boolean isTotal) {
        this.counts = new StatCount[isTotal ? 8 : 9];
        this.baseForPercents = isTotal ? 1 : 2;
        for (int i = 0; i < this.counts.length; ++i) {
            this.counts[i] = new StatCount();
        }
    }

    public void addRepetition(StatCount count) {
        this.counts[0].add(count);
    }

    public void addRepetitionWithinThisFile(StatCount count) {
        this.counts[0].add(count);
    }

    public void addRepetitionFromOtherFiles(StatCount count) {
        this.counts[1].add(count);
    }

    public void addExact(StatCount count) {
        this.counts[this.getRowByPercent(101)].add(count);
    }

    public void addForPercents(int percent, StatCount count) {
        this.counts[this.getRowByPercent(percent)].add(count);
    }

    private int getRowByPercent(int percent) {
        if (percent == 101) {
            return this.baseForPercents;
        }
        if (percent >= 95) {
            return this.baseForPercents + 1;
        }
        if (percent >= 85) {
            return this.baseForPercents + 2;
        }
        if (percent >= 75) {
            return this.baseForPercents + 3;
        }
        if (percent >= 50) {
            return this.baseForPercents + 4;
        }
        return this.baseForPercents + 5;
    }

    public String[][] calcTableWithoutPercentage(String[] rows) {
        String[][] table = new String[this.baseForPercents + 1][5];
        for (int i = 0; i <= this.baseForPercents; ++i) {
            table[i][0] = rows[i];
            table[i][1] = Integer.toString(this.counts[i].segments);
            table[i][2] = Integer.toString(this.counts[i].words);
            table[i][3] = Integer.toString(this.counts[i].charsWithoutSpaces);
            table[i][4] = Integer.toString(this.counts[i].charsWithSpaces);
        }
        return table;
    }

    public String[][] calcTable(String[] rows) {
        this.counts[this.counts.length - 1].reset();
        for (int i = 0; i < this.counts.length - 1; ++i) {
            this.counts[this.counts.length - 1].add(this.counts[i]);
        }
        String[][] table = new String[this.counts.length][5];
        for (int i = 0; i < this.counts.length; ++i) {
            table[i][0] = rows[i];
            table[i][1] = Integer.toString(this.counts[i].segments);
            table[i][2] = Integer.toString(this.counts[i].words);
            table[i][3] = Integer.toString(this.counts[i].charsWithoutSpaces);
            table[i][4] = Integer.toString(this.counts[i].charsWithSpaces);
        }
        return table;
    }
}

