/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.filters2.html2;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.regex.Matcher;
import org.omegat.util.PatternConsts;

public class HTMLReader
extends Reader {
    private BufferedReader reader;
    private String encoding = null;
    boolean readFirstTime = true;

    public HTMLReader(String fileName, String encoding) throws IOException {
        this.reader = new BufferedReader(this.createReader(fileName, encoding));
    }

    public String getEncoding() {
        return this.encoding;
    }

    private Reader createReader(String fileName, String defaultEncoding) throws IOException {
        BufferedInputStream is = new BufferedInputStream(new FileInputStream(fileName));
        is.mark(65536);
        int char1 = is.read();
        int char2 = is.read();
        int char3 = is.read();
        if (char1 == 254 && char2 == 255) {
            this.encoding = "UTF-16BE";
        }
        if (char1 == 255 && char2 == 254) {
            this.encoding = "UTF-16LE";
        }
        if (char1 == 239 && char2 == 187 && char3 == 191) {
            this.encoding = "UTF-8";
        }
        is.reset();
        if (this.encoding != null) {
            return new InputStreamReader((InputStream)is, this.encoding);
        }
        is.mark(65536);
        byte[] buf = new byte[65536];
        int len = is.read(buf);
        if (len > 0) {
            String buffer = new String(buf, 0, len);
            Matcher matcher_html = PatternConsts.HTML_ENCODING.matcher(buffer);
            if (matcher_html.find()) {
                this.encoding = matcher_html.group(1);
            } else if (this.encoding == null) {
                Matcher matcher_xml;
                Matcher matcher_html5 = PatternConsts.HTML5_ENCODING.matcher(buffer);
                if (matcher_html5.find()) {
                    this.encoding = matcher_html5.group(1);
                } else if (this.encoding == null && (matcher_xml = PatternConsts.XML_ENCODING.matcher(buffer)).find()) {
                    this.encoding = matcher_xml.group(1);
                }
            }
        }
        is.reset();
        InputStreamReader isr = null;
        if (this.encoding != null) {
            try {
                isr = new InputStreamReader((InputStream)is, this.encoding);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (isr == null) {
            try {
                isr = new InputStreamReader((InputStream)is, defaultEncoding);
                this.encoding = defaultEncoding;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (isr == null) {
            isr = new InputStreamReader(is);
        }
        return isr;
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        if (this.readFirstTime) {
            this.readFirstTime = false;
            this.reader.mark(1);
            int ch = this.reader.read();
            if (ch != 65279) {
                this.reader.reset();
            }
        }
        return this.reader.read(cbuf, off, len);
    }
}

