/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.filters2.text;

import java.io.IOException;
import java.io.Writer;
import org.omegat.tokenizer.ITokenizer;
import org.omegat.util.StringUtil;
import org.omegat.util.Token;

public class LineLengthLimitWriter
extends Writer {
    public static String PLATFORM_LINE_SEPARATOR = System.getProperty("line.separator");
    final Writer out;
    final int lineLength;
    final int maxLineLength;
    final ITokenizer tokenizer;
    final StringBuilder str = new StringBuilder();
    int breakChars;
    char eol1;
    char eol2;

    public LineLengthLimitWriter(Writer out, int lineLength, int maxLineLength, ITokenizer tokenizer) {
        this.out = out;
        this.lineLength = lineLength;
        this.maxLineLength = maxLineLength;
        this.tokenizer = tokenizer;
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        int cp;
        for (int i = 0; i < len; i += Character.charCount(cp)) {
            cp = Character.codePointAt(cbuf, off + i);
            if (this.breakChars > 0 && cp == this.str.codePointBefore(this.str.length())) {
                this.outLine();
            }
            if (cp == 10 || cp == 13) {
                this.str.appendCodePoint(cp);
                ++this.breakChars;
                if (this.breakChars <= 1) continue;
                this.outLine();
                continue;
            }
            if (this.breakChars > 0) {
                this.outLine();
            }
            this.str.appendCodePoint(cp);
        }
    }

    void outLine() throws IOException {
        if (this.str.length() == 0) {
            return;
        }
        int cp = this.str.codePointBefore(this.str.length());
        if (cp == 10 || cp == 13) {
            this.eol2 = (char)cp;
            this.str.setLength(this.str.length() - 1);
        }
        if (this.str.length() > 0 && ((cp = this.str.codePointBefore(this.str.length())) == 10 || cp == 13)) {
            this.eol1 = (char)cp;
            this.str.setLength(this.str.length() - 1);
        }
        if (this.str.length() == 0) {
            this.writeSourceEol();
        } else {
            Token[] tokens = this.tokenizer.tokenizeVerbatim(this.str.toString());
            while (this.str.length() > 0) {
                int p = this.getBreakPos(tokens);
                this.breakAt(p, tokens);
            }
        }
        this.breakChars = 0;
        this.eol1 = '\u0000';
        this.eol2 = '\u0000';
    }

    int getBreakPos(Token[] tokens) {
        int cps;
        if (this.str.codePointCount(0, this.str.length()) <= this.maxLineLength) {
            return this.str.length();
        }
        int latestNonSpacesTokenPos = 0;
        for (int i = tokens.length - 1; i >= 0; --i) {
            Token[] t = tokens[i];
            if (t == null || this.isSpaces((Token)t)) continue;
            latestNonSpacesTokenPos = t.getOffset() + t.getLength();
            break;
        }
        if (this.str.codePointCount(0, latestNonSpacesTokenPos) <= this.maxLineLength) {
            return this.str.length();
        }
        int spacesStart = -1;
        for (Token t : tokens) {
            if (t == null) continue;
            if (this.str.codePointCount(0, t.getOffset()) >= this.lineLength && spacesStart >= 0 && this.str.codePointCount(0, spacesStart) < this.maxLineLength) {
                return t.getOffset();
            }
            if (this.isSpaces(t)) {
                if (spacesStart >= 0) continue;
                spacesStart = t.getOffset();
                continue;
            }
            spacesStart = -1;
        }
        for (Token t : tokens) {
            if (t == null) continue;
            cps = this.str.codePointCount(0, t.getOffset());
            if (cps >= this.lineLength && cps < this.maxLineLength && this.isSpaces(t)) {
                return t.getOffset();
            }
            cps = this.str.codePointCount(0, t.getOffset() + t.getLength());
            if (cps < this.lineLength || cps >= this.maxLineLength || !this.isSpaces(t)) continue;
            return t.getOffset() + t.getLength();
        }
        for (Token t : tokens) {
            if (t == null) continue;
            cps = this.str.codePointCount(0, t.getOffset());
            if (cps >= this.lineLength && cps < this.maxLineLength && this.isPossibleBreakBefore(t.getOffset())) {
                return t.getOffset();
            }
            cps = this.str.codePointCount(0, t.getOffset() + t.getLength());
            if (cps < this.lineLength || cps >= this.maxLineLength || !this.isPossibleBreakBefore(t.getOffset() + t.getLength())) continue;
            return t.getOffset() + t.getLength();
        }
        for (int i = 0; i < tokens.length; ++i) {
            Token t = tokens[i];
            if (t == null || this.str.codePointCount(0, t.getOffset()) < this.lineLength) continue;
            if (i == 0) {
                return t.getOffset() + t.getLength();
            }
            int j = i - 1;
            while (j >= 0) {
                Token tp;
                if ((tp = tokens[j--]) == null || tp.getOffset() <= 0 || !this.isPossibleBreakBefore(tp.getOffset())) continue;
                return tp.getOffset();
            }
            return t.getOffset();
        }
        return this.str.length();
    }

    boolean isSpaces(Token token) {
        int cp;
        for (int i = 0; i < token.getLength(); i += Character.charCount(cp)) {
            cp = this.str.codePointAt(token.getOffset() + i);
            if (Character.isWhitespace(cp)) continue;
            return false;
        }
        return true;
    }

    void breakAt(int pos, Token[] tokens) throws IOException {
        this.out.write(StringUtil.rstrip(this.str.substring(0, pos)));
        this.str.delete(0, pos);
        if (this.str.length() > 0) {
            this.writeBreakEol();
        } else {
            this.writeSourceEol();
        }
        for (int i = 0; i < tokens.length; ++i) {
            Token t = tokens[i];
            tokens[i] = t == null || t.getOffset() < pos ? null : new Token(null, t.getOffset() - pos, t.getLength());
        }
    }

    void writeBreakEol() throws IOException {
        if (this.eol1 == '\u0000' && this.eol2 == '\u0000') {
            this.out.write(PLATFORM_LINE_SEPARATOR);
        } else {
            if (this.eol1 != '\u0000') {
                this.out.write(this.eol1);
            }
            if (this.eol2 != '\u0000') {
                this.out.write(this.eol2);
            }
        }
    }

    void writeSourceEol() throws IOException {
        if (this.eol1 != '\u0000') {
            this.out.write(this.eol1);
        }
        if (this.eol2 != '\u0000') {
            this.out.write(this.eol2);
        }
    }

    boolean isPossibleBreakBefore(int pos) {
        int cp2;
        try {
            cp2 = this.str.codePointBefore(pos);
            if (":\\([{<\u00c2\u00ab\u00e2\u0080\u009e".indexOf(cp2) >= 0) {
                return false;
            }
        }
        catch (StringIndexOutOfBoundsException cp2) {
            // empty catch block
        }
        try {
            cp2 = this.str.codePointAt(pos);
            if ("{:)]}>\u00c2\u00bb\u00e2\u0080\u009c,.".indexOf(cp2) >= 0) {
                return false;
            }
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            // empty catch block
        }
        return true;
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void close() throws IOException {
        this.outLine();
        this.out.flush();
        this.out.close();
    }
}

