/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.filters2.text;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.omegat.util.OStrings;
import org.omegat.util.gui.DockingUI;
import org.omegat.util.gui.StaticUIUtils;
import org.openide.awt.Mnemonics;

public class TextOptionsDialog
extends JDialog {
    public static final int RET_CANCEL = 0;
    public static final int RET_OK = 1;
    private Map<String, String> options;
    private JRadioButton breaksRB;
    private ButtonGroup buttonGroup1;
    private JPanel buttonPanel;
    private JButton cancelButton;
    private JRadioButton emptyLinesRB;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JLabel lineLengthLabel;
    private JSpinner lineLengthSpinner;
    private JLabel maxLineLengthLabel;
    private JSpinner maxLineLengthSpinner;
    private JRadioButton neverRB;
    private JButton okButton;
    private int returnStatus = 0;

    private void checkLineLengthValue() {
        try {
            if (Integer.parseInt(this.lineLengthSpinner.getValue().toString()) <= 0) {
                this.lineLengthSpinner.setValue(0);
                this.maxLineLengthSpinner.setValue(0);
                this.maxLineLengthSpinner.setEnabled(false);
            } else if (Integer.parseInt(this.lineLengthSpinner.getValue().toString()) > 0) {
                this.maxLineLengthSpinner.setEnabled(true);
            }
            if (Integer.parseInt(this.maxLineLengthSpinner.getValue().toString()) < Integer.parseInt(this.lineLengthSpinner.getValue().toString())) {
                this.maxLineLengthSpinner.setValue(Integer.parseInt(this.lineLengthSpinner.getValue().toString()));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public TextOptionsDialog(Dialog parent, Map<String, String> options) {
        super(parent, true);
        this.options = new TreeMap<String, String>(options);
        this.initComponents();
        String segmentOn = options.get("segmentOn");
        if ("BREAKS".equals(segmentOn)) {
            this.breaksRB.setSelected(true);
        } else if ("NEVER".equals(segmentOn)) {
            this.neverRB.setSelected(true);
        } else {
            this.emptyLinesRB.setSelected(true);
        }
        try {
            this.lineLengthSpinner.setValue(Integer.parseInt(options.get("lineLength")));
        }
        catch (Exception e) {
            this.lineLengthSpinner.setValue(0);
        }
        try {
            this.maxLineLengthSpinner.setValue(Integer.parseInt(options.get("maxLineLength")));
        }
        catch (Exception e) {
            this.maxLineLengthSpinner.setValue(0);
        }
        this.checkLineLengthValue();
        StaticUIUtils.setEscapeAction(this, (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TextOptionsDialog.this.doClose(0);
            }
        });
        DockingUI.displayCentered(this);
    }

    public int getReturnStatus() {
        return this.returnStatus;
    }

    public Map<String, String> getOptions() {
        return this.options;
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.buttonPanel = new JPanel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.breaksRB = new JRadioButton();
        this.emptyLinesRB = new JRadioButton();
        this.neverRB = new JRadioButton();
        this.jLabel2 = new JLabel();
        this.lineLengthLabel = new JLabel();
        this.lineLengthSpinner = new JSpinner();
        this.maxLineLengthLabel = new JLabel();
        this.maxLineLengthSpinner = new JSpinner();
        this.setTitle(OStrings.getString("TEXTFILTER_OPTIONS_DIALOG_TITLE"));
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                TextOptionsDialog.this.closeDialog(evt);
            }
        });
        this.buttonPanel.setLayout(new FlowLayout(2));
        Mnemonics.setLocalizedText(this.okButton, OStrings.getString("BUTTON_OK"));
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TextOptionsDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.okButton);
        Mnemonics.setLocalizedText(this.cancelButton, OStrings.getString("BUTTON_CANCEL"));
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TextOptionsDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.cancelButton);
        this.getContentPane().add((Component)this.buttonPanel, "South");
        this.jPanel1.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        this.jPanel1.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText(this.jLabel1, OStrings.getString("TEXTFILTER_OPTIONS_DIALOG_DESCRIPTION"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.jPanel1.add((Component)this.jLabel1, gridBagConstraints);
        this.buttonGroup1.add(this.breaksRB);
        Mnemonics.setLocalizedText(this.breaksRB, OStrings.getString("TEXTFILTER_OPTION_SEGMENT_ON_LINE_BREAKS"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.jPanel1.add((Component)this.breaksRB, gridBagConstraints);
        this.buttonGroup1.add(this.emptyLinesRB);
        this.emptyLinesRB.setSelected(true);
        Mnemonics.setLocalizedText(this.emptyLinesRB, OStrings.getString("TEXTFILTER_OPTION_SEGMENT_ON_EMPTY_LINES"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.jPanel1.add((Component)this.emptyLinesRB, gridBagConstraints);
        this.buttonGroup1.add(this.neverRB);
        Mnemonics.setLocalizedText(this.neverRB, OStrings.getString("TEXTFILTER_OPTION_NEVER_SEGMENT"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.jPanel1.add((Component)this.neverRB, gridBagConstraints);
        Mnemonics.setLocalizedText(this.jLabel2, OStrings.getString("TEXT_FILTER_LINE_LENGTH_DESCRIPTION"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 4, 0, 4);
        this.jPanel1.add((Component)this.jLabel2, gridBagConstraints);
        Mnemonics.setLocalizedText(this.lineLengthLabel, OStrings.getString("TEXT_FILTER_LINE_LENGTH"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 16, 4, 4);
        this.jPanel1.add((Component)this.lineLengthLabel, gridBagConstraints);
        this.lineLengthSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                TextOptionsDialog.this.lineLengthSpinnerStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 50;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.lineLengthSpinner, gridBagConstraints);
        Mnemonics.setLocalizedText(this.maxLineLengthLabel, OStrings.getString("TEXT_FILTER_MAX_LINE_LENGTH"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 16, 4, 4);
        this.jPanel1.add((Component)this.maxLineLengthLabel, gridBagConstraints);
        this.maxLineLengthSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                TextOptionsDialog.this.maxLineLengthSpinnerStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 50;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.maxLineLengthSpinner, gridBagConstraints);
        this.getContentPane().add((Component)this.jPanel1, "Center");
        this.pack();
    }

    private void lineLengthSpinnerStateChanged(ChangeEvent evt) {
        this.checkLineLengthValue();
    }

    private void maxLineLengthSpinnerStateChanged(ChangeEvent evt) {
        this.checkLineLengthValue();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        String segmentOn = this.breaksRB.isSelected() ? "BREAKS" : (this.neverRB.isSelected() ? "NEVER" : "EMPTYLINES");
        this.options.put("segmentOn", segmentOn);
        this.options.put("lineLength", this.lineLengthSpinner.getValue().toString());
        this.options.put("maxLineLength", this.maxLineLengthSpinner.getValue().toString());
        this.doClose(1);
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.doClose(0);
    }

    private void closeDialog(WindowEvent evt) {
        this.doClose(0);
    }

    private void doClose(int retStatus) {
        this.returnStatus = retStatus;
        this.setVisible(false);
        this.dispose();
    }
}

