/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.filters3.xml.opendoc;

import java.awt.Dialog;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.omegat.filters2.AbstractFilter;
import org.omegat.filters2.FilterContext;
import org.omegat.filters2.Instance;
import org.omegat.filters2.TranslationException;
import org.omegat.filters3.xml.opendoc.EditOpenDocOptionsDialog;
import org.omegat.filters3.xml.opendoc.OpenDocDialect;
import org.omegat.filters3.xml.opendoc.OpenDocOptions;
import org.omegat.filters3.xml.opendoc.OpenDocXMLFilter;
import org.omegat.util.Log;
import org.omegat.util.OStrings;

public class OpenDocFilter
extends AbstractFilter {
    private static final Set<String> TRANSLATABLE = new HashSet<String>(Arrays.asList("content.xml", "styles.xml", "meta.xml"));
    OpenDocXMLFilter xmlfilter = null;

    @Override
    protected boolean requirePrevNextFields() {
        return true;
    }

    @Override
    public boolean isFileSupported(File inFile, Map<String, String> config, FilterContext fc) {
        try {
            ZipFile file = new ZipFile(inFile);
            Enumeration<? extends ZipEntry> entries = file.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (!TRANSLATABLE.contains(entry.getName())) continue;
                file.close();
                return true;
            }
            file.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    private OpenDocXMLFilter createXMLFilter(Map<String, String> options) {
        this.xmlfilter = new OpenDocXMLFilter();
        this.xmlfilter.setCallbacks(this.entryParseCallback, this.entryTranslateCallback);
        OpenDocDialect dialect = (OpenDocDialect)this.xmlfilter.getDialect();
        dialect.defineDialect(new OpenDocOptions(options));
        return this.xmlfilter;
    }

    private File tmp() throws IOException {
        return File.createTempFile("ot-oo-", ".xml");
    }

    @Override
    public void processFile(File inFile, File outFile, FilterContext fc) throws IOException, TranslationException {
        ZipFile zipfile = new ZipFile(inFile);
        ZipOutputStream zipout = null;
        if (outFile != null) {
            zipout = new ZipOutputStream(new FileOutputStream(outFile));
        }
        Enumeration<? extends ZipEntry> zipcontents = zipfile.entries();
        while (zipcontents.hasMoreElements()) {
            ZipEntry zipentry = zipcontents.nextElement();
            String shortname = zipentry.getName();
            if (shortname.lastIndexOf(47) >= 0) {
                shortname = shortname.substring(shortname.lastIndexOf(47) + 1);
            }
            if (TRANSLATABLE.contains(shortname)) {
                File tmpin = this.tmp();
                FileUtils.copyInputStreamToFile(zipfile.getInputStream(zipentry), tmpin);
                File tmpout = null;
                if (zipout != null) {
                    tmpout = this.tmp();
                }
                try {
                    this.createXMLFilter(this.processOptions).processFile(tmpin, tmpout, fc);
                }
                catch (Exception e) {
                    zipfile.close();
                    throw new TranslationException(e.getLocalizedMessage() + "\n" + OStrings.getString("OpenDoc_ERROR_IN_FILE") + inFile);
                }
                if (zipout != null) {
                    ZipEntry outentry = new ZipEntry(zipentry.getName());
                    outentry.setMethod(8);
                    zipout.putNextEntry(outentry);
                    FileUtils.copyFile(tmpout, zipout);
                    zipout.closeEntry();
                }
                if (!tmpin.delete()) {
                    tmpin.deleteOnExit();
                }
                if (tmpout == null || tmpout.delete()) continue;
                tmpout.deleteOnExit();
                continue;
            }
            if (zipout == null) continue;
            ZipEntry outentry = new ZipEntry(zipentry.getName());
            zipout.putNextEntry(outentry);
            IOUtils.copy(zipfile.getInputStream(zipentry), (OutputStream)zipout);
            zipout.closeEntry();
        }
        if (zipout != null) {
            zipout.close();
        }
        zipfile.close();
    }

    @Override
    public String getFileFormatName() {
        return OStrings.getString("OpenDoc_FILTER_NAME");
    }

    @Override
    public Instance[] getDefaultInstances() {
        return new Instance[]{new Instance("*.sx?"), new Instance("*.st?"), new Instance("*.od?"), new Instance("*.ot?")};
    }

    @Override
    public boolean isSourceEncodingVariable() {
        return false;
    }

    @Override
    public boolean isTargetEncodingVariable() {
        return false;
    }

    @Override
    protected void processFile(BufferedReader inFile, BufferedWriter outFile, FilterContext fc) throws IOException, TranslationException {
        throw new IOException("Not Implemented!");
    }

    @Override
    public boolean hasOptions() {
        return true;
    }

    @Override
    public Map<String, String> changeOptions(Dialog parent, Map<String, String> currentOptions) {
        try {
            EditOpenDocOptionsDialog dialog = new EditOpenDocOptionsDialog(parent, currentOptions);
            dialog.setVisible(true);
            if (1 == dialog.getReturnStatus()) {
                return dialog.getOptions().getOptionsMap();
            }
            return null;
        }
        catch (Exception e) {
            Log.logErrorRB("HTML_EXC_EDIT_OPTIONS", new Object[0]);
            Log.log(e);
            return null;
        }
    }

    @Override
    public String getInEncodingLastParsedFile() {
        return "OpenDoc";
    }
}

